/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.compiler;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.file.compiler.ErrorCodes;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;

public class FileServiceValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String FILE_EVENT = "file:FileEvent";
    private static final String RESOURCE_NAME_ON_CREATE = "onCreate";
    private static final String RESOURCE_NAME_ON_DELETE = "onDelete";
    private static final String RESOURCE_NAME_ON_MODIFY = "onModify";
    public static final String BALLERINA_ORG_NAME = "ballerina";
    public static final String PACKAGE_NAME = "file";

    public void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        List diagnostics = syntaxNodeAnalysisContext.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        if (this.isFileService(syntaxNodeAnalysisContext)) {
            ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)syntaxNodeAnalysisContext.node();
            long size = serviceDeclarationNode.members().stream().filter(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).count();
            if (size > 0L) {
                serviceDeclarationNode.members().stream().filter(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).forEach(node -> {
                    FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                    this.validateServiceFunctions(functionDefinitionNode, syntaxNodeAnalysisContext);
                    this.validateFunctionSignature(functionDefinitionNode, syntaxNodeAnalysisContext);
                });
            } else {
                this.reportErrorDiagnostic((Location)serviceDeclarationNode.location(), syntaxNodeAnalysisContext, ErrorCodes.FILE_106, new Object[0]);
            }
        }
    }

    public void validateServiceFunctions(FunctionDefinitionNode functionDefinitionNode, SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        boolean hasRemoteKeyword;
        boolean bl = hasRemoteKeyword = functionDefinitionNode.qualifierList().stream().filter(q -> q.kind() == SyntaxKind.REMOTE_KEYWORD).toArray().length == 1;
        if (!hasRemoteKeyword) {
            this.reportErrorDiagnostic((Location)functionDefinitionNode.location(), syntaxNodeAnalysisContext, ErrorCodes.FILE_102, functionDefinitionNode.functionName().text());
        }
    }

    public void validateFunctionSignature(FunctionDefinitionNode functionDefinitionNode, SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        FunctionSignatureNode functionSignatureNode = functionDefinitionNode.functionSignature();
        SeparatedNodeList parameterNodes = functionSignatureNode.parameters();
        String functionName = functionDefinitionNode.functionName().text();
        if (!(functionName.equals(RESOURCE_NAME_ON_CREATE) || functionName.equals(RESOURCE_NAME_ON_DELETE) || functionName.equals(RESOURCE_NAME_ON_MODIFY))) {
            this.reportErrorDiagnostic((Location)functionDefinitionNode.location(), syntaxNodeAnalysisContext, ErrorCodes.FILE_103, functionName);
        }
        if (parameterNodes.size() == 1) {
            RequiredParameterNode requiredParameterNode = (RequiredParameterNode)functionSignatureNode.parameters().get(0);
            String value = requiredParameterNode.toString();
            if (!value.contains(FILE_EVENT)) {
                this.reportErrorDiagnostic((Location)functionDefinitionNode.location(), syntaxNodeAnalysisContext, ErrorCodes.FILE_101, value.split(" ")[0]);
            } else if (functionSignatureNode.returnTypeDesc().isPresent()) {
                this.reportErrorDiagnostic((Location)functionDefinitionNode.location(), syntaxNodeAnalysisContext, ErrorCodes.FILE_104, functionName);
            }
        } else {
            this.reportErrorDiagnostic((Location)functionDefinitionNode.location(), syntaxNodeAnalysisContext, ErrorCodes.FILE_105, new Object[0]);
        }
    }

    public boolean isFileService(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)syntaxNodeAnalysisContext.node();
        Optional serviceDeclarationSymbol = syntaxNodeAnalysisContext.semanticModel().symbol((Node)serviceDeclarationNode);
        if (serviceDeclarationSymbol.isPresent()) {
            List listenerTypes = ((ServiceDeclarationSymbol)serviceDeclarationSymbol.get()).listenerTypes();
            for (TypeSymbol listenerType : listenerTypes) {
                if (listenerType.typeKind() == TypeDescKind.UNION) {
                    List memberDescriptors = ((UnionTypeSymbol)listenerType).memberTypeDescriptors();
                    for (TypeSymbol typeSymbol : memberDescriptors) {
                        if (!typeSymbol.getModule().isPresent() || !((ModuleSymbol)typeSymbol.getModule().get()).id().orgName().equals(BALLERINA_ORG_NAME) || !typeSymbol.getModule().flatMap(Symbol::getName).orElse("").equals(PACKAGE_NAME)) continue;
                        return true;
                    }
                    continue;
                }
                if (listenerType.typeKind() != TypeDescKind.TYPE_REFERENCE || !listenerType.getModule().isPresent() || !((ModuleSymbol)listenerType.getModule().get()).id().orgName().equals(BALLERINA_ORG_NAME) || !((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().flatMap(Symbol::getName).orElse("").equals(PACKAGE_NAME)) continue;
                return true;
            }
        }
        return false;
    }

    public void reportErrorDiagnostic(Location location, SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, ErrorCodes errorCode, Object ... args) {
        DiagnosticInfo diagnosticErrInfo = new DiagnosticInfo(errorCode.getErrorCode(), errorCode.getError(), DiagnosticSeverity.ERROR);
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticErrInfo, (Location)location, (Object[])args);
        syntaxNodeAnalysisContext.reportDiagnostic(diagnostic);
    }
}

