/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.compiler.staticcodeanalyzer;

import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.file.compiler.Constants;
import io.ballerina.stdlib.file.compiler.staticcodeanalyzer.FileRule;
import io.ballerina.tools.diagnostics.Location;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;

public class FilePathInjectionAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;

    public FilePathInjectionAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        Node node = context.node();
        if (!(node instanceof FunctionCallExpressionNode)) {
            return;
        }
        FunctionCallExpressionNode functionCall = (FunctionCallExpressionNode)node;
        Document document = FilePathInjectionAnalyzer.getDocument(context);
        List<Object> importPrefix = new ArrayList();
        Node node2 = document.syntaxTree().rootNode();
        if (node2 instanceof ModulePartNode) {
            ModulePartNode modulePartNode = (ModulePartNode)node2;
            importPrefix = modulePartNode.imports().stream().filter(importDeclarationNode -> {
                ImportOrgNameNode importOrgNameNode = importDeclarationNode.orgName().orElse(null);
                return importOrgNameNode != null && "ballerina".equals(importOrgNameNode.orgName().text());
            }).filter(importDeclarationNode -> importDeclarationNode.moduleName().stream().anyMatch(moduleNameNode -> "file".equals(moduleNameNode.text()))).map(importDeclarationNode -> {
                ImportPrefixNode importPrefixNode = importDeclarationNode.prefix().orElse(null);
                return importPrefixNode != null ? importPrefixNode.prefix().text() : "file";
            }).toList();
        }
        String functionName = functionCall.functionName().toString();
        boolean isFileOperation = importPrefix.stream().anyMatch(prefix -> Constants.FILE_FUNCTIONS.stream().anyMatch(func -> functionName.equals(prefix + ":" + func)));
        if (isFileOperation && !this.isSafePath(functionCall)) {
            this.reporter.reportIssue(document, (Location)functionCall.location(), FileRule.AVOID_PATH_INJECTION.getId());
        }
    }

    public static Document getDocument(SyntaxNodeAnalysisContext context) {
        return context.currentPackage().module(context.moduleId()).document(context.documentId());
    }

    private boolean isSafePath(FunctionCallExpressionNode functionCall) {
        BinaryExpressionNode binaryExpression;
        SeparatedNodeList arguments = functionCall.arguments();
        if (arguments.isEmpty()) {
            return true;
        }
        FunctionArgumentNode firstArg = (FunctionArgumentNode)arguments.get(0);
        if (!(firstArg instanceof PositionalArgumentNode)) {
            return true;
        }
        ExpressionNode argument = ((PositionalArgumentNode)firstArg).expression();
        if (argument instanceof BinaryExpressionNode && (binaryExpression = (BinaryExpressionNode)argument).operator().kind() == SyntaxKind.PLUS_TOKEN) {
            return false;
        }
        if (argument instanceof SimpleNameReferenceNode) {
            SimpleNameReferenceNode variableRef = (SimpleNameReferenceNode)argument;
            return this.isVariableSafe(variableRef);
        }
        return true;
    }

    private boolean isVariableSafe(SimpleNameReferenceNode variableRef) {
        String variableName = variableRef.name().text();
        for (NonTerminalNode currentNode = variableRef.parent(); currentNode != null; currentNode = currentNode.parent()) {
            if (!(currentNode instanceof FunctionBodyBlockNode)) continue;
            FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)currentNode;
            for (StatementNode statement : functionBody.statements()) {
                VariableDeclarationNode varDecl;
                if (!(statement instanceof VariableDeclarationNode) || !this.isMatchingVariable(varDecl = (VariableDeclarationNode)statement, variableName)) continue;
                if (this.hasConcatenationAssignment(varDecl) || this.isAssignedFromFunctionParameter(varDecl)) {
                    return this.isFunctionParameter(variableRef);
                }
                return true;
            }
        }
        return true;
    }

    private boolean isMatchingVariable(VariableDeclarationNode varDecl, String variableName) {
        CaptureBindingPatternNode bindingPattern;
        BindingPatternNode bindingPatternNode = varDecl.typedBindingPattern().bindingPattern();
        return bindingPatternNode instanceof CaptureBindingPatternNode && (bindingPattern = (CaptureBindingPatternNode)bindingPatternNode).variableName().text().equals(variableName);
    }

    private boolean hasConcatenationAssignment(VariableDeclarationNode varDecl) {
        BinaryExpressionNode binaryExpr;
        Object var3_2 = varDecl.initializer().orElse(null);
        return var3_2 instanceof BinaryExpressionNode && (binaryExpr = (BinaryExpressionNode)var3_2).operator().kind() == SyntaxKind.PLUS_TOKEN;
    }

    private boolean isAssignedFromFunctionParameter(VariableDeclarationNode varDecl) {
        return varDecl.initializer().orElse(null) instanceof SimpleNameReferenceNode;
    }

    private boolean isFunctionParameter(SimpleNameReferenceNode variableRef) {
        String paramName = variableRef.name().text();
        for (NonTerminalNode currentNode = variableRef.parent(); currentNode != null; currentNode = currentNode.parent()) {
            FunctionDefinitionNode functionDef;
            if (!(currentNode instanceof FunctionDefinitionNode) || !this.hasDirectParameterReference(functionDef = (FunctionDefinitionNode)currentNode, paramName) && !this.hasIndirectParameterReference(variableRef, functionDef)) continue;
            return false;
        }
        return true;
    }

    private boolean hasDirectParameterReference(FunctionDefinitionNode functionDef, String paramName) {
        for (ParameterNode param : functionDef.functionSignature().parameters()) {
            RequiredParameterNode reqParam;
            if (!(param instanceof RequiredParameterNode) || !(reqParam = (RequiredParameterNode)param).paramName().isPresent() || !((Token)reqParam.paramName().get()).text().equals(paramName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasIndirectParameterReference(SimpleNameReferenceNode variableRef, FunctionDefinitionNode functionDef) {
        for (ParameterNode param : functionDef.functionSignature().parameters()) {
            RequiredParameterNode reqParam;
            if (!(param instanceof RequiredParameterNode) || !this.isIndirectFunctionParameter(variableRef, reqParam = (RequiredParameterNode)param)) continue;
            return true;
        }
        return false;
    }

    private boolean isIndirectFunctionParameter(SimpleNameReferenceNode variableRef, RequiredParameterNode reqParam) {
        for (NonTerminalNode currentNode = variableRef.parent(); currentNode != null; currentNode = currentNode.parent()) {
            if (!(currentNode instanceof FunctionBodyBlockNode)) continue;
            FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)currentNode;
            for (StatementNode statement : functionBody.statements()) {
                VariableDeclarationNode varDecl;
                if (!(statement instanceof VariableDeclarationNode) || !this.isBindingPatternMatch(varDecl = (VariableDeclarationNode)statement, variableRef)) continue;
                return this.checkVariableInitializer(varDecl, reqParam);
            }
        }
        return false;
    }

    private boolean isBindingPatternMatch(VariableDeclarationNode varDecl, SimpleNameReferenceNode variableRef) {
        CaptureBindingPatternNode bindingPattern;
        BindingPatternNode bindingPatternNode = varDecl.typedBindingPattern().bindingPattern();
        return bindingPatternNode instanceof CaptureBindingPatternNode && (bindingPattern = (CaptureBindingPatternNode)bindingPatternNode).variableName().text().equals(variableRef.name().text());
    }

    private boolean checkVariableInitializer(VariableDeclarationNode varDecl, RequiredParameterNode reqParam) {
        ExpressionNode initializer;
        ExpressionNode expressionNode = initializer = (ExpressionNode)varDecl.initializer().orElse(null);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleNameReferenceNode.class, BinaryExpressionNode.class}, (Object)expressionNode, n)) {
            case -1 -> false;
            case 0 -> {
                SimpleNameReferenceNode initializerRef = (SimpleNameReferenceNode)expressionNode;
                yield initializerRef.name().text().equals(((Token)reqParam.paramName().get()).text());
            }
            case 1 -> {
                BinaryExpressionNode binaryExpr = (BinaryExpressionNode)expressionNode;
                if (binaryExpr.operator().kind() == SyntaxKind.PLUS_TOKEN && this.isIndirectFunctionParameterFromBinary(binaryExpr, reqParam)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isIndirectFunctionParameterFromBinary(BinaryExpressionNode binaryExpr, RequiredParameterNode reqParam) {
        SimpleNameReferenceNode rightRef;
        SimpleNameReferenceNode leftRef;
        Node node = binaryExpr.lhsExpr();
        if (node instanceof SimpleNameReferenceNode && (leftRef = (SimpleNameReferenceNode)node).name().text().equals(((Token)reqParam.paramName().get()).text())) {
            return true;
        }
        node = binaryExpr.rhsExpr();
        return node instanceof SimpleNameReferenceNode && (rightRef = (SimpleNameReferenceNode)node).name().text().equals(((Token)reqParam.paramName().get()).text());
    }
}

