/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.file.compiler.staticcodeanalyzer;

import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.projects.Document;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.scan.Reporter;
import io.ballerina.stdlib.file.compiler.Constants;
import io.ballerina.stdlib.file.compiler.staticcodeanalyzer.FileRule;
import io.ballerina.tools.diagnostics.Location;
import org.ballerinalang.model.tree.expressions.StringTemplateLiteralNode;

public class InsecureDirectoryAccessAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Reporter reporter;

    public InsecureDirectoryAccessAnalyzer(Reporter reporter) {
        this.reporter = reporter;
    }

    public void perform(SyntaxNodeAnalysisContext context) {
        Node node = context.node();
        if (!(node instanceof FunctionCallExpressionNode)) {
            return;
        }
        FunctionCallExpressionNode functionCall = (FunctionCallExpressionNode)node;
        if (!this.isFileMethodCall(functionCall)) {
            return;
        }
        Document document = InsecureDirectoryAccessAnalyzer.getDocument(context);
        NodeLocation location = functionCall.location();
        this.reporter.reportIssue(document, (Location)location, FileRule.AVOID_INSECURE_DIRECTORY_ACCESS.getId());
    }

    public static Document getDocument(SyntaxNodeAnalysisContext context) {
        return context.currentPackage().module(context.moduleId()).document(context.documentId());
    }

    private boolean isFileMethodCall(FunctionCallExpressionNode functionCall) {
        for (FunctionCallExpressionNode currentNode = functionCall; currentNode != null; currentNode = currentNode.parent()) {
            StringTemplateLiteralNode templatePath;
            BasicLiteralNode pathLiteral;
            String filePath;
            PositionalArgumentNode posArg;
            ExpressionNode pathExpr;
            FunctionArgumentNode pathArg;
            SeparatedNodeList arguments;
            Object modulePrefix;
            if (!(currentNode instanceof FunctionCallExpressionNode)) continue;
            FunctionCallExpressionNode currentMethodCall = currentNode;
            NameReferenceNode nameReferenceNode = currentMethodCall.functionName();
            if (nameReferenceNode instanceof QualifiedNameReferenceNode) {
                String envVarName;
                QualifiedNameReferenceNode qNode = (QualifiedNameReferenceNode)nameReferenceNode;
                modulePrefix = qNode.modulePrefix().text();
                String functionName = qNode.identifier().text();
                if (((String)modulePrefix).equals("os") && functionName.equals("getEnv") && Constants.PUBLIC_DIRECTORIES.contains(envVarName = ((FunctionArgumentNode)currentMethodCall.arguments().get(0)).toString())) {
                    return true;
                }
            }
            if (!((modulePrefix = currentMethodCall.functionName()) instanceof QualifiedNameReferenceNode)) continue;
            QualifiedNameReferenceNode fileCallNode = (QualifiedNameReferenceNode)modulePrefix;
            String fileModulePrefix = fileCallNode.modulePrefix().text();
            String fileFunctionName = fileCallNode.identifier().text();
            if (!fileModulePrefix.equals("file") || !Constants.FILE_FUNCTIONS.contains(fileFunctionName) || (arguments = currentMethodCall.arguments()) == null || arguments.isEmpty() || !((pathArg = (FunctionArgumentNode)arguments.get(0)) instanceof PositionalArgumentNode) || !((pathExpr = (posArg = (PositionalArgumentNode)pathArg).expression()) instanceof BasicLiteralNode ? this.isInsecureDirectory(filePath = (pathLiteral = (BasicLiteralNode)pathExpr).toString().trim()) : pathExpr instanceof StringTemplateLiteralNode && this.isInsecureDirectory(filePath = (templatePath = (StringTemplateLiteralNode)pathExpr).toString().trim()))) continue;
            return true;
        }
        return false;
    }

    private boolean isInsecureDirectory(String filePath) {
        return Constants.PUBLIC_DIRECTORIES.contains(filePath);
    }
}

