/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateExecutableTask;
import io.ballerina.cli.task.DumpBuildTimeTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.nio.file.Path;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="build", description={"Compile the current package"})
public class BuildCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    @CommandLine.Option(names={"--output", "-o"}, description={"Write the output to the given file. The provided output file name may or may not contain the '.jar' extension."})
    private String output;
    @CommandLine.Option(names={"--offline"}, description={"Build/Compile offline without downloading dependencies."})
    private Boolean offline;
    @CommandLine.Parameters(arity="0..1")
    private final Path projectPath;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--dump-bir-file"}, hidden=true)
    private Boolean dumpBIRFile;
    @CommandLine.Option(names={"--dump-graph"}, description={"Print the dependency graph."}, hidden=true)
    private boolean dumpGraph;
    @CommandLine.Option(names={"--dump-raw-graphs"}, description={"Print all intermediate graphs created in the dependency resolution process."}, hidden=true)
    private boolean dumpRawGraphs;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--generate-config-schema"}, hidden=true)
    private Boolean configSchemaGen;
    private static final String buildCmd = "bal build [-o <output>] [--offline] [--taint-check]\n                    [<ballerina-file | package-path>]";
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable JAR file(s)."})
    private Boolean observabilityIncluded;
    @CommandLine.Option(names={"--cloud"}, description={"Enable cloud artifact generation"})
    private String cloud;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--remote-management"}, description={"enable service management tools in the executable JAR file(s)."})
    private Boolean remoteManagement;
    @CommandLine.Option(names={"--list-conflicted-classes"}, description={"list conflicted classes when generating executable"})
    private Boolean listConflictedClasses;
    @CommandLine.Option(names={"--dump-build-time"}, description={"calculate and dump build time"}, hidden=true)
    private Boolean dumpBuildTime;
    @CommandLine.Option(names={"--sticky"}, description={"stick to exact versions locked (if exists)"})
    private Boolean sticky;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--export-openapi"}, description={"generate openAPI contract files for all the services in the current package"})
    private Boolean exportOpenAPI;
    @CommandLine.Option(names={"--export-component-model"}, description={"generate a model to represent interactions between the package components (i.e. service/type definitions) and, export it in JSON format"}, hidden=true)
    private Boolean exportComponentModel;
    @CommandLine.Option(names={"--enable-cache"}, description={"enable caches for the compilation"}, hidden=true)
    private Boolean enableCache;
    @CommandLine.Option(names={"--graalvm"}, description={"enable native image generation"})
    private Boolean nativeImage;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--graalvm-build-options"}, description={"additional build options for native image generation"})
    private String graalVMBuildOptions;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    @CommandLine.Option(names={"--locking-mode"}, hidden=true, description={"allow passing the package locking mode."})
    private String lockingMode;

    public BuildCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean dumpBuildTime) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.dumpBuildTime = dumpBuildTime;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, String output) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.output = output;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Path targetDir) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.targetDir = targetDir;
        this.offline = true;
    }

    BuildCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean dumpBuildTime, boolean nativeImage, String graalVMBuildOptions) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.dumpBuildTime = dumpBuildTime;
        this.offline = true;
        this.nativeImage = nativeImage;
        this.graalVMBuildOptions = graalVMBuildOptions;
    }

    @Override
    public void execute() {
        SingleFileProject project;
        long start = 0L;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("build");
            this.errStream.println(commandUsageInfo);
            return;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        boolean isSingleFileBuild = false;
        if (FileUtils.hasExtension(this.projectPath)) {
            try {
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
                }
                project = SingleFileProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
                }
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            isSingleFileBuild = true;
        } else {
            if (null != this.output) {
                CommandUtil.printError(this.errStream, "'-o' and '--output' are only supported when building a single Ballerina file.", "bal build -o <output-file> <ballerina-file> ", true);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            try {
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
                }
                project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
                }
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        RepoUtils.readSettings();
        if (!project.buildOptions().nativeImage() && !project.buildOptions().graalVMBuildOptions().isEmpty()) {
            this.outStream.println("WARNING: Additional GraalVM build options are ignored since graalvm flag is not set");
        }
        boolean isPackageModified = ProjectUtils.isProjectUpdated((Project)project);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(isPackageModified, buildOptions.enableCache()), isSingleFileBuild).addTask(new RunBuildToolsTask(this.outStream), isSingleFileBuild).addTask(new ResolveMavenDependenciesTask(this.outStream)).addTask(new CompileTask(this.outStream, this.errStream, false, true, isPackageModified, buildOptions.enableCache())).addTask(new CreateExecutableTask(this.outStream, this.output, null, false)).addTask(new DumpBuildTimeTask(this.outStream), !project.buildOptions().dumpBuildTime()).build();
        taskExecutor.executeTasks((Project)project);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setExperimental(Boolean.valueOf(this.experimentalFlag)).setOffline(this.offline).setObservabilityIncluded(this.observabilityIncluded).setCloud(this.cloud).setRemoteManagement(this.remoteManagement).setDumpBir(Boolean.valueOf(this.dumpBIR)).setDumpBirFile(this.dumpBIRFile).setDumpGraph(Boolean.valueOf(this.dumpGraph)).setDumpRawGraphs(Boolean.valueOf(this.dumpRawGraphs)).setListConflictedClasses(this.listConflictedClasses).setDumpBuildTime(this.dumpBuildTime).setSticky(this.sticky).setConfigSchemaGen(this.configSchemaGen).setExportOpenAPI(this.exportOpenAPI).setExportComponentModel(this.exportComponentModel).setEnableCache(this.enableCache).setNativeImage(this.nativeImage).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setGraalVMBuildOptions(this.graalVMBuildOptions).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation).setLockingMode(this.lockingMode);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.setConfigSchemaGen(this.configSchemaGen).build();
    }

    @Override
    public String getName() {
        return "build";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("build"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal build [-o <output>] [--offline] \\n\" +\n            \"                    [<ballerina-file | package-path>]");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

