/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import picocli.CommandLine;

@CommandLine.Command(name="clean", description={"Clean the artifacts generated during the build"})
public class CleanCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final Path projectPath;
    private final boolean exitWhenFinish;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;

    public CleanCommand(Path projectPath, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = System.out;
        this.exitWhenFinish = exitWhenFinish;
    }

    public CleanCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.exitWhenFinish = true;
    }

    public CleanCommand(Path projectPath, PrintStream printStream, boolean exitWhenFinish, Path targetDir) {
        this.projectPath = projectPath;
        this.outStream = printStream;
        this.exitWhenFinish = exitWhenFinish;
        this.targetDir = targetDir;
    }

    @Override
    public void execute() {
        Path generatedDir;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("clean");
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (this.targetDir != null) {
            if (Files.notExists(this.targetDir, new LinkOption[0])) {
                CommandUtil.printError(this.outStream, "provided target directory '" + String.valueOf(this.targetDir) + "' does not exist.", null, false);
            } else if (!Files.isDirectory(this.targetDir, new LinkOption[0])) {
                CommandUtil.printError(this.outStream, "provided target path '" + String.valueOf(this.targetDir) + "' is not a directory.", null, false);
            } else {
                ProjectUtils.deleteDirectory((Path)this.targetDir);
                this.outStream.println("Successfully deleted '" + String.valueOf(this.targetDir) + "'.");
            }
        } else {
            try {
                BuildProject project = BuildProject.load((Path)this.projectPath);
                this.targetDir = project.targetDir();
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.outStream, e.getMessage(), null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (Files.exists(this.targetDir, new LinkOption[0])) {
                ProjectUtils.deleteDirectory((Path)this.targetDir);
                this.outStream.println("Successfully deleted '" + String.valueOf(this.targetDir) + "'.");
            }
        }
        try {
            BuildProject project = BuildProject.load((Path)this.projectPath);
            generatedDir = project.sourceRoot().resolve("generated");
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.outStream, e.getMessage(), null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (Files.exists(generatedDir, new LinkOption[0])) {
            ProjectUtils.deleteDirectory((Path)generatedDir);
            this.outStream.println("Successfully deleted '" + String.valueOf(generatedDir) + "'.");
        }
    }

    @Override
    public String getName() {
        return "clean";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("clean"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(" bal clean \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

