/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.CompilationCacheFactory;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.PackageVersion;
import io.ballerina.projects.PlatformLibraryScope;
import io.ballerina.projects.ProjectEnvironmentBuilder;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.bala.BalaProject;
import io.ballerina.projects.internal.bala.BalToolJson;
import io.ballerina.projects.internal.bala.BalaJson;
import io.ballerina.projects.internal.bala.DependencyGraphJson;
import io.ballerina.projects.internal.bala.ModuleDependency;
import io.ballerina.projects.internal.bala.PackageJson;
import io.ballerina.projects.internal.model.Dependency;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.repos.FileSystemCache;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.projects.util.ProjectUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;
import org.wso2.ballerinalang.util.RepoUtils;

public final class CommandUtil {
    public static final String ORG_NAME = "ORG_NAME";
    public static final String PKG_NAME = "PKG_NAME";
    public static final String DIST_VERSION = "DIST_VERSION";
    public static final String TOOL_ID = "TOOL_ID";
    public static final String USER_HOME = "user.home";
    public static final String GITIGNORE = "gitignore";
    public static final String DEVCONTAINER = "devcontainer";
    public static final String NEW_CMD_DEFAULTS = "new_cmd_defaults";
    public static final String CREATE_CMD_TEMPLATES = "create_cmd_templates";
    public static final String LIBS_DIR = "libs";
    public static final String DEFAULT_TEMPLATE = "default";
    public static final String MAIN_TEMPLATE = "main";
    public static final String FILE_STRING_SEPARATOR = ", ";
    private static FileSystem jarFs;
    private static Map<String, String> env;
    private static PrintStream errStream;
    private static PrintStream outStream;
    private static Path homeCache;
    private static boolean exitWhenFinish;
    private static String platform;

    private CommandUtil() {
    }

    static void setPrintStream(PrintStream errStream) {
        CommandUtil.errStream = errStream;
    }

    public static void initJarFs() {
        URI uri = null;
        try {
            uri = CommandUtil.class.getClassLoader().getResource(CREATE_CMD_TEMPLATES).toURI();
            if (uri.toString().contains("!")) {
                String[] array = uri.toString().split("!");
                if (null == jarFs) {
                    env = new HashMap<String, String>();
                    jarFs = FileSystems.newFileSystem(URI.create(array[0]), env);
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new AssertionError();
        }
    }

    public static void printError(PrintStream stream, String error, String usage, boolean help) {
        stream.println("ballerina: " + error);
        if (null != usage) {
            stream.println();
            stream.println("USAGE:");
            stream.println("    " + usage);
        }
        if (help) {
            stream.println();
            stream.println("For more information try --help");
        }
    }

    public static void exitError(boolean exit) {
        if (exit) {
            Runtime.getRuntime().exit(1);
        }
    }

    static void applyTemplate(String orgName, String templatePkgName, String version, String packageName, Path projectPath, Path balaCache, List<Path> filesInDir) {
        Path balaPath = CommandUtil.getPlatformSpecificBalaPath(orgName, templatePkgName, version, balaCache);
        if (!Files.exists(balaPath, new LinkOption[0])) {
            CommandUtil.printError(errStream, "unable to find the bala: " + String.valueOf(balaPath), null, false);
            CommandUtil.exitError(exitWhenFinish);
        }
        try {
            CommandUtil.addModules(balaPath, projectPath, packageName);
        }
        catch (IOException e) {
            ProjectUtils.deleteSelectedFilesInDirectory((Path)projectPath, filesInDir);
            CommandUtil.printError(errStream, "error occurred while creating the package: " + e.getMessage(), null, false);
            CommandUtil.exitError(exitWhenFinish);
        }
    }

    private static void addModules(Path balaPath, Path projectPath, String packageName) throws IOException {
        List<Path> modulesList;
        InputStreamReader fileReader;
        FileInputStream inputStream;
        Gson gson = new Gson();
        Path packageJsonPath = balaPath.resolve("package.json");
        Path dependencyGraphJsonPath = balaPath.resolve("dependency-graph.json");
        Path balToolJsonPath = balaPath.resolve("tool").resolve("bal-tool.json");
        PackageJson templatePackageJson = null;
        BalaJson templateBalaJson = null;
        Path balaJsonPath = balaPath.resolve("bala.json");
        DependencyGraphJson templateDependencyGraphJson = null;
        BalToolJson templateBalToolJson = null;
        try {
            inputStream = new FileInputStream(String.valueOf(packageJsonPath));
            try {
                fileReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
                templatePackageJson = (PackageJson)gson.fromJson((Reader)fileReader, PackageJson.class);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (IOException e) {
            CommandUtil.printError(errStream, "Error while reading the package json file: " + e.getMessage(), null, false);
            Runtime.getRuntime().exit(1);
        }
        try {
            inputStream = new FileInputStream(String.valueOf(balaJsonPath));
            try {
                fileReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
                templateBalaJson = (BalaJson)gson.fromJson((Reader)fileReader, BalaJson.class);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (IOException e) {
            CommandUtil.printError(errStream, "Error while reading the bala.json file: " + e.getMessage(), null, false);
            Runtime.getRuntime().exit(1);
        }
        if (dependencyGraphJsonPath.toFile().exists()) {
            try {
                inputStream = new FileInputStream(String.valueOf(dependencyGraphJsonPath));
                try {
                    fileReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
                    templateDependencyGraphJson = (DependencyGraphJson)gson.fromJson((Reader)fileReader, DependencyGraphJson.class);
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                CommandUtil.printError(errStream, "Error while reading the dependency graph json file: " + e.getMessage(), null, false);
                Runtime.getRuntime().exit(1);
            }
        }
        if (balToolJsonPath.toFile().exists()) {
            try {
                inputStream = new FileInputStream(String.valueOf(balToolJsonPath));
                try {
                    fileReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
                    templateBalToolJson = (BalToolJson)gson.fromJson((Reader)fileReader, BalToolJson.class);
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                CommandUtil.printError(errStream, "Error while reading the bal-tool.json file: " + e.getMessage(), null, false);
                Runtime.getRuntime().exit(1);
            }
        }
        if (!templatePackageJson.getTemplate()) {
            throw LauncherUtils.createLauncherException("unable to create the package: specified package is not a template");
        }
        Path ballerinaToml = projectPath.resolve("Ballerina.toml");
        Files.createDirectories(projectPath, new FileAttribute[0]);
        Files.createFile(ballerinaToml, new FileAttribute[0]);
        CommandUtil.writeBallerinaToml(ballerinaToml, templatePackageJson, templateBalaJson, packageName, platform);
        if (dependencyGraphJsonPath.toFile().exists()) {
            Path dependenciesToml = projectPath.resolve("Dependencies.toml");
            Files.createFile(dependenciesToml, new FileAttribute[0]);
            CommandUtil.writeDependenciesToml(projectPath, templateDependencyGraphJson, templatePackageJson);
        }
        if (balToolJsonPath.toFile().exists()) {
            Path balToolToml = projectPath.resolve("BalTool.toml");
            Files.createFile(balToolToml, new FileAttribute[0]);
            CommandUtil.writeBalToolToml(balToolToml, templateBalToolJson, packageName);
            CommandUtil.copyToolDependencies(projectPath, balaPath.resolve("tool").resolve(LIBS_DIR));
        }
        Path toPackageMdPath = projectPath.resolve("README.md");
        Path docFilePath = balaPath.resolve("docs").resolve("Package.md");
        if (templatePackageJson.getReadme() != null) {
            docFilePath = balaPath.resolve(templatePackageJson.getReadme());
        }
        if (Files.exists(docFilePath, new LinkOption[0])) {
            Files.copy(docFilePath, toPackageMdPath, StandardCopyOption.REPLACE_EXISTING);
        }
        CommandUtil.createDefaultGitignore(projectPath);
        CommandUtil.createDefaultDevContainer(projectPath);
        String templatePkgName = templatePackageJson.getName();
        Path modulesRoot = balaPath.resolve("modules");
        Path moduleMdDirRoot = balaPath.resolve("docs").resolve("modules");
        try (Stream<Path> pathStream = Files.list(modulesRoot);){
            modulesList = pathStream.toList();
        }
        CommandUtil.copyIcon(balaPath, projectPath);
        CommandUtil.copyPlatformLibraries(balaPath, projectPath);
        CommandUtil.copyIncludeFiles(balaPath, projectPath, templatePackageJson);
        Map<Object, Object> otherModulesMap = new HashMap();
        if (templatePackageJson.getModules() != null) {
            otherModulesMap = templatePackageJson.getModules().stream().collect(Collectors.toMap(PackageManifest.Module::name, PackageManifest.Module::readme));
        }
        for (Path moduleRoot : modulesList) {
            String moduleName;
            Path destDir;
            Path moduleDir = Optional.of(moduleRoot.getFileName()).get();
            if (moduleDir.toString().equals(templatePkgName)) {
                destDir = projectPath;
            } else {
                String moduleDirName = moduleDir.toString().split(templatePkgName + ".", 2)[1];
                destDir = projectPath.resolve("modules").resolve(moduleDirName);
                Files.createDirectories(destDir, new FileAttribute[0]);
            }
            Files.walkFileTree(moduleRoot, (FileVisitor<? super Path>)new FileUtils.Copy(moduleRoot, destDir, templatePkgName, packageName));
            Path moduleMdSource = moduleMdDirRoot.resolve(moduleDir).resolve("Module.md");
            if (templatePackageJson.getReadme() != null && otherModulesMap.containsKey(moduleName = Optional.of(moduleRoot.getFileName()).get().toString())) {
                moduleMdSource = balaPath.resolve((String)otherModulesMap.get(moduleName));
            }
            if (!Files.exists(moduleMdSource, new LinkOption[0])) continue;
            Files.copy(moduleMdSource, destDir.resolve("README.md"), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static void copyIcon(Path balaPath, Path projectPath) {
        Path docsPath = balaPath.resolve("docs");
        try (Stream<Path> pathStream = Files.walk(docsPath, 1, new FileVisitOption[0]);){
            List<Path> icon = pathStream.filter(FileSystems.getDefault().getPathMatcher("glob:**.png")::matches).toList();
            if (!icon.isEmpty()) {
                Path projectDocsDir = projectPath.resolve("docs");
                Files.createDirectory(projectDocsDir, new FileAttribute[0]);
                Path projectIconPath = projectDocsDir.resolve(Optional.of(icon.get(0).getFileName()).get());
                Files.copy(icon.get(0), projectIconPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            CommandUtil.printError(errStream, "Error while retrieving the icon: " + e.getMessage(), null, false);
            Runtime.getRuntime().exit(1);
        }
    }

    private static void copyPlatformLibraries(Path balaPath, Path projectPath) throws IOException {
        Path platformLibPath = balaPath.resolve("platform").resolve(platform);
        if (Files.exists(platformLibPath, new LinkOption[0])) {
            Path libs = projectPath.resolve(LIBS_DIR);
            Files.createDirectories(libs, new FileAttribute[0]);
            Files.walkFileTree(platformLibPath, (FileVisitor<? super Path>)new FileUtils.Copy(platformLibPath, libs));
        }
    }

    private static void copyIncludeFiles(Path balaPath, Path projectPath, PackageJson templatePackageJson) throws IOException {
        if (templatePackageJson.getInclude() != null) {
            String templatePkgName = templatePackageJson.getName();
            List includePaths = ProjectUtils.getPathsMatchingIncludePatterns((List)templatePackageJson.getInclude(), (Path)balaPath);
            for (Path includePath : includePaths) {
                Path moduleNameUpdatedIncludePath = CommandUtil.updateModuleDirectoryNaming(includePath, balaPath, templatePkgName);
                Path fromIncludeFilePath = balaPath.resolve(includePath);
                Path toIncludeFilePath = projectPath.resolve(moduleNameUpdatedIncludePath);
                if (!Files.notExists(toIncludeFilePath, new LinkOption[0])) continue;
                Files.createDirectories(toIncludeFilePath, new FileAttribute[0]);
                Files.walkFileTree(fromIncludeFilePath, (FileVisitor<? super Path>)new FileUtils.Copy(fromIncludeFilePath, toIncludeFilePath));
            }
        }
    }

    private static Path updateModuleDirectoryNaming(Path includePath, Path balaPath, String templatePkgName) {
        Path modulesDirPath = balaPath.resolve("modules");
        Path absoluteIncludePath = balaPath.resolve(includePath);
        if (absoluteIncludePath.startsWith(modulesDirPath)) {
            Path moduleRootPath = modulesDirPath.relativize(absoluteIncludePath).subpath(0, 1);
            String moduleDirName = Optional.of(moduleRootPath.getFileName()).get().toString();
            String destinationDirName = moduleDirName.split(templatePkgName + ".", 2)[1];
            Path includePathRelativeToModuleRoot = modulesDirPath.resolve(moduleRootPath).relativize(absoluteIncludePath);
            return Path.of("modules", new String[0]).resolve(destinationDirName).resolve(includePathRelativeToModuleRoot);
        }
        return includePath;
    }

    static Path findBalaTemplate(String template, Path balaCache) {
        String packageName = CommandUtil.findPkgName(template);
        String orgName = CommandUtil.findOrg(template);
        String version = CommandUtil.findPkgVersion(template);
        if (version != null) {
            Path balaPath = CommandUtil.getPlatformSpecificBalaPath(orgName, packageName, version, balaCache);
            if (Files.exists(balaPath, new LinkOption[0])) {
                return balaPath;
            }
            return null;
        }
        return null;
    }

    public static void initPackageFromCentral(Path balaCache, Path projectPath, String packageName, String template, List<Path> filesInDir) {
        Path pkgCacheParent;
        String version;
        String orgName;
        String templatePackageName;
        block7: {
            List<PackageVersion> packageVersions;
            System.setProperty("enableOutputStream", "true");
            templatePackageName = CommandUtil.findPkgName(template);
            orgName = CommandUtil.findOrg(template);
            version = CommandUtil.findPkgVersion(template);
            pkgCacheParent = balaCache.resolve(orgName).resolve(templatePackageName);
            try {
                CommandUtil.pullPackageFromRemote(orgName, templatePackageName, version, pkgCacheParent);
            }
            catch (PackageAlreadyExistsException e) {
                if (version == null) {
                    packageVersions = CommandUtil.getPackageVersions(pkgCacheParent);
                    PackageVersion latest = CommandUtil.findLatest(packageVersions);
                    if (latest == null) {
                        throw LauncherUtils.createLauncherException("unable to find package in the filesystem cache. This is an unexpected error : " + e.getMessage());
                    }
                    version = latest.toString();
                }
            }
            catch (CentralClientException e) {
                errStream.println("Warning: Unable to pull the package from Ballerina Central: " + e.getMessage());
                if (CommandUtil.findBalaTemplate(template, balaCache) != null) break block7;
                packageVersions = CommandUtil.getPackageVersions(pkgCacheParent);
                PackageVersion latest = CommandUtil.findLatest(packageVersions);
                if (latest == null) {
                    throw LauncherUtils.createLauncherException("template not found in filesystem cache.");
                }
                version = latest.toString();
            }
        }
        if (version == null) {
            List<PackageVersion> packageVersions = CommandUtil.getPackageVersions(pkgCacheParent);
            PackageVersion latest = CommandUtil.findLatest(packageVersions);
            version = Objects.requireNonNull(latest).toString();
        }
        CommandUtil.applyTemplate(orgName, templatePackageName, version, packageName, projectPath, balaCache, filesInDir);
    }

    private static void pullPackageFromRemote(String orgName, String packageName, String version, Path destination) throws CentralClientException {
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        Settings settings = RepoUtils.readSettings();
        CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
        client.pullPackage(orgName, packageName, version, destination, supportedPlatform, RepoUtils.getBallerinaVersion(), false);
    }

    public static void writeBallerinaToml(Path balTomlPath, PackageJson packageJson, BalaJson balaJson, String packageName, String platform) throws IOException {
        JsonArray platformLibraries;
        Files.writeString(balTomlPath, (CharSequence)"[package]", StandardOpenOption.APPEND);
        Files.writeString(balTomlPath, (CharSequence)("\norg = \"" + packageJson.getOrganization() + "\""), StandardOpenOption.APPEND);
        Files.writeString(balTomlPath, (CharSequence)("\nname = \"" + packageName + "\""), StandardOpenOption.APPEND);
        Files.writeString(balTomlPath, (CharSequence)("\nversion = \"" + packageJson.getVersion() + "\""), StandardOpenOption.APPEND);
        Files.writeString(balTomlPath, (CharSequence)("\ndistribution = \"" + packageJson.getBallerinaVersion() + "\""), StandardOpenOption.APPEND);
        CommandUtil.writePackageAttributeArray(balTomlPath, packageJson.getLicenses(), "license");
        CommandUtil.writePackageAttributeArray(balTomlPath, packageJson.getAuthors(), "authors");
        CommandUtil.writePackageAttributeArray(balTomlPath, packageJson.getKeywords(), "keywords");
        CommandUtil.writePackageAttributeValue(balTomlPath, packageJson.getSourceRepository(), "repository");
        CommandUtil.writePackageAttributeValue(balTomlPath, packageJson.getVisibility(), "visibility");
        CommandUtil.writePackageAttributeValue(balTomlPath, packageJson.getIcon(), "icon");
        Files.writeString(balTomlPath, (CharSequence)"\n\n[build-options]", StandardOpenOption.APPEND);
        Files.writeString(balTomlPath, (CharSequence)"\nobservabilityIncluded = true\n", StandardOpenOption.APPEND);
        StringJoiner stringJoiner = new StringJoiner("\n");
        if ("2.0.0".equals(balaJson.getBala_version())) {
            List<String> newModuleNames = packageJson.getExport().stream().map(module -> module.replaceFirst(packageJson.getName(), packageName)).toList();
            Iterator iterator = newModuleNames.iterator();
            while (iterator.hasNext()) {
                String newModuleName = (String)iterator.next();
                if (newModuleName.equals(packageName)) continue;
                stringJoiner.add("\n[[package.modules]]");
                stringJoiner.add("name = \"" + newModuleName.replaceFirst(packageJson.getName(), packageName) + "\"");
                stringJoiner.add("export = true");
            }
        } else if (packageJson.getModules() != null) {
            for (PackageManifest.Module module2 : packageJson.getModules()) {
                stringJoiner.add("\n[[package.modules]]");
                stringJoiner.add("name = \"" + module2.name().replaceFirst(packageJson.getName(), packageName) + "\"");
                stringJoiner.add("export = true");
            }
        }
        if (!stringJoiner.toString().isEmpty()) {
            Files.writeString(balTomlPath, (CharSequence)(String.valueOf(stringJoiner) + "\n"), StandardOpenOption.APPEND);
        }
        if ((platformLibraries = packageJson.getPlatformDependencies()) == null) {
            return;
        }
        Files.writeString(balTomlPath, (CharSequence)("\n[[platform." + platform + ".dependency]]"), StandardOpenOption.APPEND);
        for (Object dependencies : platformLibraries) {
            JsonObject dependenciesObj = (JsonObject)dependencies;
            if (null == dependenciesObj.get("scope")) {
                String libPath = dependenciesObj.get("path").getAsString();
                Path libName = Optional.of(Path.of(libPath, new String[0]).getFileName()).get();
                Path libRelPath = Path.of(LIBS_DIR, libName.toString());
                Files.writeString(balTomlPath, (CharSequence)("\npath = \"" + String.valueOf(libRelPath) + "\""), StandardOpenOption.APPEND);
            }
            if (dependenciesObj.get("artifactId") != null) {
                String artifactId = dependenciesObj.get("artifactId").getAsString();
                Files.writeString(balTomlPath, (CharSequence)("\nartifactId = \"" + artifactId + "\""), StandardOpenOption.APPEND);
            }
            if (dependenciesObj.get("groupId") != null) {
                String groupId = dependenciesObj.get("groupId").getAsString();
                Files.writeString(balTomlPath, (CharSequence)("\ngroupId = \"" + groupId + "\""), StandardOpenOption.APPEND);
            }
            if (dependenciesObj.get("version") != null) {
                String dependencyVersion = dependenciesObj.get("version").getAsString();
                Files.writeString(balTomlPath, (CharSequence)("\nversion = \"" + dependencyVersion + "\"\n"), StandardOpenOption.APPEND);
            }
            if (null == dependenciesObj.get("scope") || !dependenciesObj.get("scope").getAsString().equals("provided")) continue;
            String scope = dependenciesObj.get("scope").getAsString();
            Files.writeString(balTomlPath, (CharSequence)("scope = \"" + scope + "\"\n"), StandardOpenOption.APPEND);
            String artifactId = dependenciesObj.get("artifactId").getAsString();
            CommandUtil.printError(errStream, "WARNING: path for the platform dependency " + artifactId + " with provided scope should be specified in the Ballerina.toml", null, false);
        }
    }

    public static void writeDependenciesToml(Path projectPath, DependencyGraphJson templateDependencyGraphJson, PackageJson templatePackageJson) throws IOException {
        Path depsTomlPath = projectPath.resolve("Dependencies.toml");
        String autoGenCode = "# AUTO-GENERATED FILE. DO NOT MODIFY.\n\n# This file is auto-generated by Ballerina for managing dependency versions.\n# It should not be modified by hand.\n\n";
        Files.writeString(depsTomlPath, (CharSequence)autoGenCode, StandardOpenOption.APPEND);
        String balTomlVersion = "[ballerina]\ndependencies-toml-version = \"2\"\n\n";
        Files.writeString(depsTomlPath, (CharSequence)balTomlVersion, StandardOpenOption.APPEND);
        ArrayList currentPkgModules = new ArrayList();
        for (ModuleDependency module : templateDependencyGraphJson.getModuleDependencies()) {
            if (!module.getOrg().equals(templatePackageJson.getOrganization()) || !module.getPackageName().equals(templatePackageJson.getName())) continue;
            List currentPkgModuleDeps = module.getDependencies();
            currentPkgModules.addAll(currentPkgModuleDeps);
        }
        StringBuilder pkgDesc = new StringBuilder();
        for (Dependency packageDependency : templateDependencyGraphJson.getPackageDependencyGraph()) {
            if (templatePackageJson.getOrganization().equals(packageDependency.getOrg()) && templatePackageJson.getName().equals(packageDependency.getName())) {
                pkgDesc.append("[[package]]\n").append("org = \"").append(packageDependency.getOrg()).append("\"\n").append("name = \"").append(ProjectUtils.defaultName((Path)projectPath)).append("\"\n").append("version = \"").append(packageDependency.getVersion()).append("\"\n");
                pkgDesc.append(CommandUtil.getDependenciesArrayContent(packageDependency));
                pkgDesc.append(CommandUtil.getDependencyModulesArrayContent(templateDependencyGraphJson.getModuleDependencies(), true, projectPath));
            } else {
                pkgDesc.append("[[package]]\n").append("org = \"").append(packageDependency.getOrg()).append("\"\n").append("name = \"").append(packageDependency.getName()).append("\"\n").append("version = \"").append(packageDependency.getVersion()).append("\"\n");
                pkgDesc.append(CommandUtil.getDependenciesArrayContent(packageDependency));
                ArrayList<ModuleDependency> packageDependencyModules = new ArrayList<ModuleDependency>();
                for (ModuleDependency module : currentPkgModules) {
                    if (!packageDependency.getOrg().equals(module.getOrg()) || !packageDependency.getName().equals(module.getPackageName())) continue;
                    packageDependencyModules.add(module);
                }
                if (!packageDependencyModules.isEmpty()) {
                    pkgDesc.append(CommandUtil.getDependencyModulesArrayContent(packageDependencyModules, false, projectPath));
                }
            }
            pkgDesc.append("\n");
        }
        Files.writeString(depsTomlPath, (CharSequence)pkgDesc.toString(), StandardOpenOption.APPEND);
    }

    public static Path getPlatformSpecificBalaPath(String orgName, String pkgName, String version, Path balaCache) {
        Path balaPath = balaCache.resolve(ProjectUtils.getRelativeBalaPath((String)orgName, (String)pkgName, (String)version, null));
        platform = "any";
        if (!Files.exists(balaPath, new LinkOption[0])) {
            for (JvmTarget supportedPlatform : JvmTarget.values()) {
                balaPath = balaCache.resolve(ProjectUtils.getRelativeBalaPath((String)orgName, (String)pkgName, (String)version, (String)supportedPlatform.code()));
                if (!Files.exists(balaPath, new LinkOption[0])) continue;
                platform = supportedPlatform.code();
                break;
            }
        }
        return balaPath;
    }

    public static void writeBalToolToml(Path balToolTomlPath, BalToolJson balToolJson, String packageName) throws IOException {
        Files.writeString(balToolTomlPath, (CharSequence)"[tool]", StandardOpenOption.APPEND);
        Files.writeString(balToolTomlPath, (CharSequence)("\nid = \"" + packageName + "\"\n"), StandardOpenOption.APPEND);
        List dependencyPaths = balToolJson.dependencyPaths();
        StringBuilder dependenciesContent = new StringBuilder();
        for (String dependencyPath : dependencyPaths) {
            dependenciesContent.append("\n[[dependency]]\n").append("path = \"").append(dependencyPath).append("\"\n");
        }
        Files.writeString(balToolTomlPath, (CharSequence)dependenciesContent.toString(), StandardOpenOption.APPEND);
    }

    public static void copyToolDependencies(Path projectPath, Path toolsLibPath) throws IOException {
        Path toolDirectory = projectPath.resolve("tool");
        Files.createDirectory(toolDirectory, new FileAttribute[0]);
        Files.createDirectory(toolDirectory.resolve(LIBS_DIR), new FileAttribute[0]);
        Files.walkFileTree(toolsLibPath, (FileVisitor<? super Path>)new FileUtils.Copy(toolsLibPath, toolDirectory.resolve(LIBS_DIR)));
    }

    private static String getDependenciesArrayContent(Dependency packageDependency) {
        StringBuilder dependenciesContent = new StringBuilder();
        if (!packageDependency.getDependencies().isEmpty()) {
            for (Dependency dependency : packageDependency.getDependencies()) {
                dependenciesContent.append("\t{org = \"").append(dependency.getOrg()).append("\", name = \"").append(dependency.getName()).append("\"},\n");
            }
            String dependenciesPart = dependenciesContent.toString();
            dependenciesPart = CommandUtil.removeLastCharacter(CommandUtil.trimStartingWhitespaces(dependenciesPart));
            return "dependencies = [\n" + dependenciesPart + "\n]\n";
        }
        return "";
    }

    private static String getDependencyModulesArrayContent(List<ModuleDependency> dependencyModules, boolean isCurrentPackage, Path projectPath) {
        StringBuilder modulesContent = new StringBuilder();
        if (isCurrentPackage) {
            for (ModuleDependency module : dependencyModules) {
                String currentPkgName = ProjectUtils.defaultName((Path)projectPath).value();
                String modulePkgPart = module.getModuleName().split("\\.")[0];
                String currentPkgModuleName = module.getModuleName().replaceFirst(modulePkgPart, currentPkgName);
                modulesContent.append("\t{org = \"").append(module.getOrg()).append("\", packageName = \"").append(currentPkgName).append("\", moduleName = \"").append(currentPkgModuleName).append("\"},\n");
            }
        } else {
            for (ModuleDependency module : dependencyModules) {
                modulesContent.append("\t{org = \"").append(module.getOrg()).append("\", packageName = \"").append(module.getPackageName()).append("\", moduleName = \"").append(module.getModuleName()).append("\"},\n");
            }
        }
        String modulesPart = modulesContent.toString();
        modulesPart = CommandUtil.removeLastCharacter(CommandUtil.trimStartingWhitespaces(modulesPart));
        return "modules = [\n" + modulesPart + "\n]\n";
    }

    private static void writePackageAttributeArray(Path balTomlPath, List<String> attributeArray, String attributeName) throws IOException {
        if (attributeArray != null && !attributeArray.isEmpty()) {
            StringJoiner stringJoiner = new StringJoiner(",");
            for (String attributeElement : attributeArray) {
                stringJoiner.add("\"" + attributeElement + "\"");
            }
            Files.writeString(balTomlPath, (CharSequence)("\n" + attributeName + " = [" + String.valueOf(stringJoiner) + "]"), StandardOpenOption.APPEND);
        }
    }

    private static void writePackageAttributeValue(Path balTomlPath, String attributeValue, String attributeName) throws IOException {
        if (attributeValue != null && !attributeValue.isEmpty()) {
            Files.writeString(balTomlPath, (CharSequence)("\n" + attributeName + " = \"" + attributeValue + "\""), StandardOpenOption.APPEND);
        }
    }

    public static String findPkgName(String template) {
        String[] orgSplit = template.split("/");
        String packagePart = orgSplit.length > 1 ? orgSplit[1] : "";
        String[] pkgSplit = packagePart.split(":");
        return pkgSplit[0].trim();
    }

    public static String findOrg(String template) {
        String[] orgSplit = template.split("/");
        return orgSplit[0].trim();
    }

    public static String findPkgVersion(String template) {
        String[] orgSplit = template.split("/");
        String packagePart = orgSplit.length > 1 ? orgSplit[1] : "";
        String[] pkgSplit = packagePart.split(":");
        if (pkgSplit.length > 1) {
            return pkgSplit[1].trim();
        }
        return null;
    }

    public static void initPackageByTemplate(Path path, String packageName, String template, boolean balFilesExist) throws IOException, URISyntaxException {
        CommandUtil.applyTemplate(path, template, balFilesExist);
        if (template.equalsIgnoreCase("lib")) {
            CommandUtil.initLibPackage(path, packageName);
            Path source = path.resolve("lib.bal");
            Files.move(source, source.resolveSibling(ProjectUtils.guessPkgName((String)packageName, (String)template) + ".bal"), StandardCopyOption.REPLACE_EXISTING);
        } else if (template.equalsIgnoreCase("tool")) {
            CommandUtil.initToolPackage(path, packageName);
        } else {
            CommandUtil.initPackage(path, packageName);
        }
        CommandUtil.createDefaultGitignore(path);
        CommandUtil.createDefaultDevContainer(path);
    }

    private static void createDefaultGitignore(Path path) throws IOException {
        Path gitignore = path.resolve(".gitignore");
        if (Files.notExists(gitignore, new LinkOption[0])) {
            Files.createFile(gitignore, new FileAttribute[0]);
        }
        if (Files.size(gitignore) == 0L) {
            String defaultGitignore = FileUtils.readFileAsString((String)"new_cmd_defaults/gitignore");
            Files.writeString(gitignore, (CharSequence)defaultGitignore, new OpenOption[0]);
        }
    }

    private static void createDefaultDevContainer(Path path) throws IOException {
        Path devContainer = path.resolve(".devcontainer.json");
        if (Files.notExists(devContainer, new LinkOption[0])) {
            Files.createFile(devContainer, new FileAttribute[0]);
        }
        if (Files.size(devContainer) == 0L) {
            String defaultDevContainer = FileUtils.readFileAsString((String)"new_cmd_defaults/devcontainer");
            defaultDevContainer = defaultDevContainer.replace("latest", RepoUtils.getBallerinaVersion());
            Files.writeString(devContainer, (CharSequence)defaultDevContainer, new OpenOption[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getTemplates() {
        try {
            Path templateDir = CommandUtil.getTemplatePath();
            try (Stream<Path> walk = Files.walk(templateDir, 1, new FileVisitOption[0]);){
                List<String> templates = walk.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(directory -> !templateDir.equals(directory)).map(directory -> directory.getFileName()).filter(Objects::nonNull).map(Path::toString).toList();
                if (null != jarFs) {
                    List<String> list2 = templates.stream().map(t -> t.replace(jarFs.getSeparator(), "")).toList();
                    return list2;
                }
                List<String> list = templates;
                return list;
            }
        }
        catch (IOException | URISyntaxException e) {
            return new ArrayList<String>();
        }
    }

    private static Path getTemplatePath() throws URISyntaxException {
        URI uri = CommandUtil.class.getClassLoader().getResource(CREATE_CMD_TEMPLATES).toURI();
        if (uri.toString().contains("!")) {
            String[] array = uri.toString().split("!");
            return jarFs.getPath(array[1], new String[0]);
        }
        return Path.of(uri);
    }

    public static void applyTemplate(Path modulePath, String template, boolean balFilesExist) throws IOException, URISyntaxException {
        Path templateDir = CommandUtil.getTemplatePath().resolve(template);
        if (template.equalsIgnoreCase(MAIN_TEMPLATE)) {
            templateDir = CommandUtil.getTemplatePath().resolve(DEFAULT_TEMPLATE);
            Path tempDirTest = CommandUtil.getTemplatePath().resolve(MAIN_TEMPLATE);
            Files.walkFileTree(templateDir, (FileVisitor<? super Path>)new FileUtils.Copy(templateDir, modulePath));
            Files.walkFileTree(tempDirTest, (FileVisitor<? super Path>)new FileUtils.Copy(tempDirTest, modulePath));
        } else if (template.equalsIgnoreCase(DEFAULT_TEMPLATE)) {
            if (!balFilesExist) {
                Files.walkFileTree(templateDir, (FileVisitor<? super Path>)new FileUtils.Copy(templateDir, modulePath));
            }
        } else {
            Files.walkFileTree(templateDir, (FileVisitor<? super Path>)new FileUtils.Copy(templateDir, modulePath));
        }
    }

    public static void initPackage(Path path, String packageName) throws IOException {
        Path ballerinaToml = path.resolve("Ballerina.toml");
        Files.createFile(ballerinaToml, new FileAttribute[0]);
        String defaultManifest = FileUtils.readFileAsString((String)"new_cmd_defaults/manifest-app.toml");
        defaultManifest = defaultManifest.replace(ORG_NAME, ProjectUtils.guessOrgName()).replace(PKG_NAME, ProjectUtils.guessPkgName((String)packageName, (String)"app")).replace(DIST_VERSION, RepoUtils.getBallerinaShortVersion());
        Files.writeString(ballerinaToml, (CharSequence)defaultManifest, new OpenOption[0]);
    }

    private static void initLibPackage(Path path, String packageName) throws IOException {
        Path ballerinaToml = path.resolve("Ballerina.toml");
        Files.createFile(ballerinaToml, new FileAttribute[0]);
        String defaultManifest = FileUtils.readFileAsString((String)"new_cmd_defaults/manifest-lib.toml");
        defaultManifest = defaultManifest.replace(ORG_NAME, ProjectUtils.guessOrgName()).replace(PKG_NAME, ProjectUtils.guessPkgName((String)packageName, (String)"lib")).replace(DIST_VERSION, RepoUtils.getBallerinaShortVersion());
        Files.writeString(ballerinaToml, (CharSequence)defaultManifest, new OpenOption[0]);
        String packageMd = FileUtils.readFileAsString((String)"new_cmd_defaults/README.md");
        Files.write(path.resolve("README.md"), packageMd.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static void initToolPackage(Path path, String packageName) throws IOException {
        Path ballerinaToml = path.resolve("Ballerina.toml");
        Files.createFile(ballerinaToml, new FileAttribute[0]);
        String defaultManifest = FileUtils.readFileAsString((String)"new_cmd_defaults/manifest-app.toml");
        defaultManifest = defaultManifest.replace(ORG_NAME, ProjectUtils.guessOrgName()).replace(PKG_NAME, ProjectUtils.guessPkgName((String)packageName, (String)"tool")).replace(DIST_VERSION, RepoUtils.getBallerinaShortVersion());
        Files.writeString(ballerinaToml, (CharSequence)defaultManifest, new OpenOption[0]);
        Path balToolToml = path.resolve("BalTool.toml");
        Files.createFile(balToolToml, new FileAttribute[0]);
        String balToolManifest = FileUtils.readFileAsString((String)"new_cmd_defaults/manifest-tool.toml");
        balToolManifest = balToolManifest.replace(TOOL_ID, ProjectUtils.guessPkgName((String)packageName, (String)"tool"));
        Files.writeString(balToolToml, (CharSequence)balToolManifest, new OpenOption[0]);
    }

    private static PackageVersion findLatest(List<PackageVersion> packageVersions) {
        if (packageVersions.isEmpty()) {
            return null;
        }
        PackageVersion latestVersion = packageVersions.get(0);
        for (PackageVersion pkgVersion : packageVersions) {
            latestVersion = CommandUtil.getLatest(latestVersion, pkgVersion);
        }
        return latestVersion;
    }

    private static PackageVersion getLatest(PackageVersion v1, PackageVersion v2) {
        boolean isV2PreReleaseVersion;
        SemanticVersion semVer1 = v1.value();
        SemanticVersion semVer2 = v2.value();
        boolean isV1PreReleaseVersion = semVer1.isPreReleaseVersion();
        if (isV1PreReleaseVersion ^ (isV2PreReleaseVersion = semVer2.isPreReleaseVersion())) {
            return isV1PreReleaseVersion ? v2 : v1;
        }
        return semVer1.greaterThanOrEqualTo(semVer2) ? v1 : v2;
    }

    public static List<PackageVersion> getPackageVersions(Path balaPackagePath) {
        ArrayList<Path> versions = new ArrayList<Path>();
        if (Files.exists(balaPackagePath, new LinkOption[0])) {
            try (Stream<Path> collectVersions = Files.list(balaPackagePath);){
                versions.addAll(collectVersions.toList());
            }
            catch (IOException e) {
                throw new RuntimeException("Error while accessing Distribution cache: " + e.getMessage());
            }
        }
        return CommandUtil.pathToVersions(versions);
    }

    private static List<PackageVersion> pathToVersions(List<Path> versions) {
        ArrayList<PackageVersion> availableVersions = new ArrayList<PackageVersion>();
        versions.stream().map(path -> Optional.ofNullable(path).map(Path::getFileName).map(Path::toString).orElse("0.0.0")).forEach(version -> {
            try {
                availableVersions.add(PackageVersion.from((String)version));
            }
            catch (ProjectException projectException) {
                // empty catch block
            }
        });
        return availableVersions;
    }

    private static String trimStartingWhitespaces(String str) {
        return str.replaceFirst("\\s++$", "");
    }

    private static String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }

    public static String checkTemplateFilesExists(String template, Path packagePath) throws URISyntaxException, IOException {
        List<Path> templateFilePathList;
        Path templateDir = CommandUtil.getTemplatePath().resolve(template);
        try (Stream<Path> paths = Files.list(templateDir);){
            templateFilePathList = paths.toList();
        }
        StringBuilder existingFiles = new StringBuilder();
        for (Path path : templateFilePathList) {
            String fileName;
            Optional<String> fileNameOptional = Optional.ofNullable(path.getFileName()).map(Path::toString);
            if (!fileNameOptional.isPresent() || (fileName = fileNameOptional.get()).endsWith(".bal") || !Files.exists(packagePath.resolve(fileName), new LinkOption[0])) continue;
            existingFiles.append(fileName).append(FILE_STRING_SEPARATOR);
        }
        return existingFiles.toString();
    }

    public static String checkPackageFilesExists(Path packagePath) {
        String[] packageFiles = new String[]{"Dependencies.toml", "BalTool.toml", "Package.md", "Module.md", "modules", "tests"};
        StringBuilder existingFiles = new StringBuilder();
        for (String file : packageFiles) {
            if (!Files.exists(packagePath.resolve(file), new LinkOption[0])) continue;
            existingFiles.append(file).append(FILE_STRING_SEPARATOR);
        }
        return existingFiles.toString();
    }

    public static boolean balFilesExists(Path packagePath) throws IOException {
        try (Stream<Path> list = Files.list(packagePath);){
            boolean bl = list.anyMatch(path -> path.toString().endsWith(".bal"));
            return bl;
        }
    }

    static String getLatestVersion(List<String> versions) {
        String latestVersion = versions.get(0);
        for (String version : versions) {
            if (!SemanticVersion.from((String)version).greaterThan(SemanticVersion.from((String)latestVersion))) continue;
            latestVersion = version;
        }
        return latestVersion;
    }

    static boolean pullDependencyPackages(String orgName, String packageName, String version, BuildOptions buildOptions, String repository) {
        PackageCompilation packageCompilation;
        Collection resolutionDiagnostics;
        Path ballerinaUserHomeDirPath = ProjectUtils.createAndGetHomeReposPath();
        Path centralRepositoryDirPath = ballerinaUserHomeDirPath.resolve("repositories").resolve(repository);
        Path balaDirPath = centralRepositoryDirPath.resolve("bala");
        Path balaPath = ProjectUtils.getPackagePath((Path)balaDirPath, (String)orgName, (String)packageName, (String)version);
        String ballerinaShortVersion = RepoUtils.getBallerinaShortVersion();
        Path cacheDir = centralRepositoryDirPath.resolve("cache-" + ballerinaShortVersion);
        ProjectEnvironmentBuilder defaultBuilder = ProjectEnvironmentBuilder.getDefaultBuilder();
        defaultBuilder.addCompilationCacheFactory((CompilationCacheFactory)new FileSystemCache.FileSystemCacheFactory(cacheDir));
        BalaProject balaProject = BalaProject.loadProject((ProjectEnvironmentBuilder)defaultBuilder, (Path)balaPath, (BuildOptions)buildOptions);
        Path packageCacheDir = cacheDir.resolve(orgName).resolve(packageName).resolve(version);
        if (packageCacheDir.toFile().exists()) {
            ProjectUtils.deleteDirectory((Path)packageCacheDir);
        }
        if (!(resolutionDiagnostics = (packageCompilation = balaProject.currentPackage().getCompilation()).getResolution().diagnosticResult().diagnostics()).isEmpty()) {
            CommandUtil.printDiagnostics(resolutionDiagnostics);
        }
        if (packageCompilation.getResolution().diagnosticResult().hasErrors()) {
            return true;
        }
        if (!CommandUtil.hasProvidedPlatformDeps(balaProject.currentPackage())) {
            JBallerinaBackend jBallerinaBackend = JBallerinaBackend.from((PackageCompilation)packageCompilation, (JvmTarget)JvmTarget.JAVA_21);
            Collection backendDiagnostics = jBallerinaBackend.diagnosticResult().diagnostics(false);
            if (!backendDiagnostics.isEmpty()) {
                CommandUtil.printDiagnostics(backendDiagnostics);
            }
            return jBallerinaBackend.diagnosticResult().hasErrors();
        }
        errStream.println("Warning: Cache generation skipped due to platform dependencies with 'provided' scope");
        return false;
    }

    private static void printDiagnostics(Collection<Diagnostic> diagnostics) {
        for (Diagnostic diagnostic : diagnostics) {
            CommandUtil.printError(errStream, diagnostic.toString(), null, false);
        }
    }

    private static boolean hasProvidedPlatformDeps(Package pkg) {
        for (PackageManifest.Platform platform : pkg.manifest().platforms().values()) {
            for (Map dependency2 : platform.dependencies()) {
                if (!PlatformLibraryScope.PROVIDED.getStringValue().equals(dependency2.get("scope"))) continue;
                return true;
            }
        }
        PackageCompilation packageCompilation = pkg.getCompilation();
        HashSet providedDeps = new HashSet();
        packageCompilation.getResolution().allDependencies().stream().map(ResolvedPackageDependency::packageInstance).map(Package::manifest).flatMap(pkgManifest -> pkgManifest.platforms().values().stream()).filter(Objects::nonNull).flatMap(pkgPlatform -> pkgPlatform.dependencies().stream()).filter(dependency -> PlatformLibraryScope.PROVIDED.equals(dependency.get("scope"))).forEach(providedDeps::add);
        return !providedDeps.isEmpty();
    }
}

