/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.util.List;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="deprecate", description={"Deprecate a package in Ballerina Central"})
public class DeprecateCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    private static final String USAGE_TEXT = "bal deprecate {<org-name>/<package-name>:<version>} [OPTIONS]";
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--message"})
    private String deprecationMsg;
    @CommandLine.Option(names={"--undo"})
    private boolean undoFlag;

    public DeprecateCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    public DeprecateCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("deprecate");
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "no package given", "bal deprecate <package> [OPTIONS]", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments", "bal deprecate <package> ", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!this.validateDeprecationMsg(this.deprecationMsg)) {
            CommandUtil.printError(this.errStream, "invalid deprecation message. The message cannot contain non-space whitespace or back slash characters.", USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.deprecationMsg != null && this.undoFlag) {
            this.outStream.println("warning: ignoring --message flag since this is an undo request");
        }
        this.deprecateInCentral(this.argList.get(0));
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private boolean validateDeprecationMsg(String deprecationMsg) {
        if (deprecationMsg != null) {
            return deprecationMsg.matches("^[^\\f\\n\\r\\t\\v\\\\]*$");
        }
        return true;
    }

    @Override
    public String getName() {
        return "deprecate";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("deprecate"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(" bal deprecate {<org-name>/<package-name>:<version>} \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void deprecateInCentral(String packageInfo) {
        block4: {
            try {
                Settings settings = RepoUtils.readSettings();
                Object packageValue = packageInfo;
                if (packageInfo.split(":").length != 2) {
                    packageValue = packageInfo + ":*";
                }
                CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
                client.deprecatePackage((String)packageValue, this.deprecationMsg, JvmTarget.JAVA_21.code(), RepoUtils.getBallerinaVersion(), Boolean.valueOf(this.undoFlag));
            }
            catch (CentralClientException e) {
                String errorMessage = e.getMessage();
                if (null == errorMessage || errorMessage.trim().isEmpty()) break block4;
                if (errorMessage.contains("\n\tat")) {
                    errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n\tat"));
                }
                CommandUtil.printError(this.errStream, errorMessage, null, false);
                CommandUtil.exitError(this.exitWhenFinish);
            }
        }
    }
}

