/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.internal.model.Repository;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;
import org.ballerinalang.maven.bala.client.MavenResolverClient;
import org.ballerinalang.maven.bala.client.MavenResolverClientException;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="pull", description={"Pull a package from Ballerina Central"})
public class PullCommand
implements BLauncherCmd {
    private static final String USAGE_TEXT = "bal pull {<org-name>/<package-name> | <org-name>/<package-name>:<version>}";
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--repository"})
    private String repositoryName;
    @CommandLine.Option(names={"--sticky"}, hidden=true, defaultValue="false")
    private boolean sticky;
    @CommandLine.Option(names={"--offline"}, hidden=true)
    private boolean offline;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true)
    private Boolean optimizeDependencyCompilation;

    public PullCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    public PullCommand(PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = errStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.repositoryName = null;
    }

    @Override
    public void execute() {
        String version;
        String packageName;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("pull");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "no package given", "bal pull <package-name> ", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments", "bal pull <package-name> ", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        System.setProperty("enableOutputStream", "true");
        String resourceName = this.argList.get(0);
        String[] moduleInfo = resourceName.split("/");
        if (moduleInfo.length != 2) {
            CommandUtil.printError(this.errStream, "invalid package. Provide the package name with the organization.", USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String orgName = moduleInfo[0];
        String moduleNameAndVersion = moduleInfo[1];
        String[] packageInfo = moduleNameAndVersion.split(":");
        if (packageInfo.length == 2) {
            packageName = packageInfo[0];
            version = packageInfo[1];
        } else if (packageInfo.length == 1) {
            packageName = moduleNameAndVersion;
            version = Names.EMPTY.getValue();
        } else {
            CommandUtil.printError(this.errStream, "invalid package. Provide the package name with the organization.", USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validateOrgName((String)orgName)) {
            CommandUtil.printError(this.errStream, "invalid organization. Provide the package name with the organization.", USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!ProjectUtils.validatePackageName((String)packageName)) {
            CommandUtil.printError(this.errStream, "invalid package name. Provide the package name with the organization.", USAGE_TEXT, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (!version.equals(Names.EMPTY.getValue())) {
            try {
                SemanticVersion.from((String)version);
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, "invalid package version. " + e.getMessage(), USAGE_TEXT, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        Settings settings = RepoUtils.readSettings();
        if (this.repositoryName == null) {
            this.repositoryName = "central.ballerina.io";
            version = this.pullFromCentral(settings, orgName, packageName, version);
        } else if (!"local".equals(this.repositoryName)) {
            this.pullFromMavenRepo(settings, orgName, packageName, version);
        }
        if (!this.resolveDependencies(orgName, packageName, version)) {
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private String pullFromCentral(Settings settings, String orgName, String packageName, String version) {
        Path packagePathInBalaCache = ProjectUtils.createAndGetHomeReposPath().resolve("repositories").resolve("central.ballerina.io").resolve("bala").resolve(orgName).resolve(packageName);
        if (!version.equals(Names.EMPTY.getValue()) && Files.exists(packagePathInBalaCache.resolve(version), new LinkOption[0])) {
            this.outStream.println("Package already exists.\n");
            return version;
        }
        try {
            Files.createDirectories(packagePathInBalaCache, new FileAttribute[0]);
        }
        catch (IOException e) {
            CommandUtil.exitError(this.exitWhenFinish);
            throw LauncherUtils.createLauncherException("unexpected error occurred while creating package repository in bala cache: " + e.getMessage());
        }
        CommandUtil.setPrintStream(this.errStream);
        String supportedPlatform = Arrays.stream(JvmTarget.values()).map(JvmTarget::code).collect(Collectors.joining(","));
        try {
            CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
            client.pullPackage(orgName, packageName, version, packagePathInBalaCache, supportedPlatform, RepoUtils.getBallerinaVersion(), false);
            if (version.equals(Names.EMPTY.getValue())) {
                List versions = client.getPackageVersions(orgName, packageName, supportedPlatform, RepoUtils.getBallerinaVersion());
                version = CommandUtil.getLatestVersion(versions);
            }
        }
        catch (PackageAlreadyExistsException e) {
            assert (version.equals(Names.EMPTY.getValue()));
            this.outStream.println("Package already exists.\n");
            version = e.version();
        }
        catch (CentralClientException e) {
            this.errStream.println("package not found: " + orgName + "/" + packageName);
            CommandUtil.exitError(this.exitWhenFinish);
        }
        return version;
    }

    private void pullFromMavenRepo(Settings settings, String orgName, String packageName, String version) {
        Repository targetRepository = null;
        for (Repository repository : settings.getRepositories()) {
            if (!this.repositoryName.equals(repository.id())) continue;
            targetRepository = repository;
            break;
        }
        if (targetRepository == null && this.repositoryName != null) {
            String errMsg = "unsupported repository '" + this.repositoryName + "' found. Only repositories mentioned in the Settings.toml are supported.";
            CommandUtil.printError(this.errStream, errMsg, null, false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (targetRepository != null) {
            MavenResolverClient mavenResolverClient = new MavenResolverClient();
            if (!targetRepository.username().isEmpty() && !targetRepository.password().isEmpty()) {
                mavenResolverClient.addRepository(targetRepository.id(), targetRepository.url(), targetRepository.username(), targetRepository.password());
            } else {
                mavenResolverClient.addRepository(targetRepository.id(), targetRepository.url());
            }
            Proxy proxy = settings.getProxy();
            mavenResolverClient.setProxy(proxy.host(), proxy.port(), proxy.username(), proxy.password());
            Path mavenBalaCachePath = RepoUtils.createAndGetHomeReposPath().resolve("repositories").resolve(targetRepository.id()).resolve("bala").resolve(orgName).resolve(packageName).resolve(version);
            try {
                Path tmpDownloadDirectory = Files.createTempDirectory("ballerina-" + System.nanoTime(), new FileAttribute[0]);
                mavenResolverClient.pullPackage(orgName, packageName, version, String.valueOf(tmpDownloadDirectory.toAbsolutePath()));
                Path balaDownloadPath = tmpDownloadDirectory.resolve(orgName).resolve(packageName).resolve(version).resolve(packageName + "-" + version + ".bala");
                Path temporaryExtractionPath = tmpDownloadDirectory.resolve(orgName).resolve(packageName).resolve(version).resolve("platform");
                ProjectUtils.extractBala((Path)balaDownloadPath, (Path)temporaryExtractionPath);
                Path packageJsonPath = temporaryExtractionPath.resolve("package.json");
                try (BufferedReader bufferedReader = Files.newBufferedReader(packageJsonPath, StandardCharsets.UTF_8);){
                    JsonObject resultObj = (JsonObject)new Gson().fromJson((Reader)bufferedReader, JsonObject.class);
                    String platform = resultObj.get("platform").getAsString();
                    Path actualBalaPath = mavenBalaCachePath.resolve(platform);
                    FileUtils.copyDirectory((File)temporaryExtractionPath.toFile(), (File)actualBalaPath.toFile());
                }
            }
            catch (MavenResolverClientException e) {
                this.errStream.println("unexpected error occurred while pulling package:" + e.getMessage());
                CommandUtil.exitError(this.exitWhenFinish);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("unexpected error occurred while creating package repository in bala cache: " + e.getMessage());
            }
            PrintStream out = System.out;
            out.println("Successfully pulled the package from the custom repository.");
        }
    }

    private boolean resolveDependencies(String orgName, String packageName, String version) {
        CommandUtil.setPrintStream(this.errStream);
        try {
            BuildOptions buildOptions = BuildOptions.builder().setSticky(Boolean.valueOf(this.sticky)).setOffline(Boolean.valueOf(this.offline)).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation).build();
            boolean hasCompilationErrors = CommandUtil.pullDependencyPackages(orgName, packageName, version, buildOptions, this.repositoryName);
            if (hasCompilationErrors) {
                CommandUtil.printError(this.errStream, "compilation contains errors", null, false);
                return false;
            }
        }
        catch (ProjectException e) {
            CommandUtil.printError(this.errStream, "error occurred while resolving dependencies, reason: " + e.getMessage(), null, false);
        }
        return true;
    }

    @Override
    public String getName() {
        return "pull";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("pull"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal pull\n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

