/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.task.CleanTargetDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateExecutableTask;
import io.ballerina.cli.task.DumpBuildTimeTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.task.RunExecutableTask;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.cli.utils.ProjectWatcher;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Compile and run the current package"})
public class RunCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath;
    private boolean exitWhenFinish;
    RunExecutableTask runExecutableTask;
    Project project;
    private static final PathMatcher JAR_EXTENSION_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.jar");
    @CommandLine.Parameters(description={"Program arguments"})
    private final List<String> argList = new ArrayList<String>();
    @CommandLine.Option(names={"--help", "-h", "?"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--offline"}, description={"Builds offline without downloading dependencies and then run."})
    private Boolean offline;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;
    @CommandLine.Option(names={"--watch"}, description={"watch for file changes and automatically re-run the project"})
    private boolean watch;
    @CommandLine.Option(names={"--dump-bir"}, hidden=true)
    private boolean dumpBIR;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable when run is used with a source file or a module."})
    private Boolean observabilityIncluded;
    @CommandLine.Option(names={"--remote-management"}, description={"enable management service in the executable when run is used with a source file or a module."})
    private Boolean remoteManagement;
    @CommandLine.Option(names={"--sticky"}, description={"stick to exact versions locked (if exists)"})
    private Boolean sticky;
    @CommandLine.Option(names={"--dump-graph"}, description={"Print the dependency graph."}, hidden=true)
    private boolean dumpGraph;
    @CommandLine.Option(names={"--dump-raw-graphs"}, description={"Print all intermediate graphs created in the dependency resolution process."}, hidden=true)
    private boolean dumpRawGraphs;
    @CommandLine.Option(names={"--generate-config-schema"}, hidden=true)
    private Boolean configSchemaGen;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--enable-cache"}, description={"enable caches for the compilation"}, hidden=true)
    private Boolean enableCache;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--dump-build-time"}, description={"calculate and dump build time"}, hidden=true)
    private Boolean dumpBuildTime;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    @CommandLine.Option(names={"--locking-mode"}, hidden=true, description={"allow passing the package locking mode."})
    private String lockingMode;
    private static final String runCmd = "bal run [--debug <port>] <executable-jar> \n    bal run [--experimental] [--offline]\n                  [<ballerina-file | package-path>] [-- program-args...]\n ";

    public RunCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.err;
        this.errStream = System.err;
    }

    RunCommand(Path projectPath, PrintStream outStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.exitWhenFinish = exitWhenFinish;
        this.outStream = outStream;
        this.errStream = outStream;
        this.offline = true;
    }

    RunCommand(Path projectPath, PrintStream outStream, boolean exitWhenFinish, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.exitWhenFinish = exitWhenFinish;
        this.outStream = outStream;
        this.errStream = outStream;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.offline = true;
    }

    RunCommand(Path projectPath, PrintStream outStream, boolean exitWhenFinish, Path targetDir) {
        this.projectPath = projectPath;
        this.exitWhenFinish = exitWhenFinish;
        this.outStream = outStream;
        this.errStream = outStream;
        this.targetDir = targetDir;
        this.offline = true;
    }

    @Override
    public void execute() {
        Target target;
        long start = 0L;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("run");
            this.errStream.println(commandUsageInfo);
            return;
        }
        if (this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        String[] args = new String[]{};
        if (!this.argList.isEmpty()) {
            if (!this.argList.get(0).equals("--")) {
                this.projectPath = Path.of(this.argList.get(0), new String[0]);
                if (JAR_EXTENSION_MATCHER.matches(this.projectPath)) {
                    CommandUtil.printError(this.errStream, "unsupported option(s) provided for jar execution", runCmd, true);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                if (this.argList.size() > 1 && !this.argList.get(1).equals("--")) {
                    CommandUtil.printError(this.errStream, "unmatched command argument found: " + this.argList.get(1), runCmd, false);
                    CommandUtil.exitError(this.exitWhenFinish);
                    return;
                }
                if (this.argList.size() > 2 && this.argList.get(1).equals("--")) {
                    args = this.argList.subList(2, this.argList.size()).toArray(new String[0]);
                }
            } else if (this.argList.size() > 1 && this.argList.get(0).equals("--")) {
                args = this.argList.subList(1, this.argList.size()).toArray(new String[0]);
            }
        }
        if (this.watch) {
            try {
                ProjectWatcher projectWatcher = new ProjectWatcher(this, Path.of(this.projectPath.toString(), new String[0]), this.outStream);
                projectWatcher.watch();
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("unable to watch the project:" + e.getMessage());
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), runCmd, false);
                CommandUtil.exitError(this.exitWhenFinish);
            }
            return;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        boolean isSingleFileBuild = false;
        if (FileUtils.hasExtension(this.projectPath)) {
            try {
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
                }
                this.project = SingleFileProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
                }
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), runCmd, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            isSingleFileBuild = true;
        } else {
            try {
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
                }
                this.project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
                }
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), runCmd, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        try {
            if (this.project.kind().equals((Object)ProjectKind.BUILD_PROJECT)) {
                target = new Target(this.project.targetDir());
            } else {
                target = new Target(Files.createTempDirectory("ballerina-cache" + System.nanoTime(), new FileAttribute[0]));
                target.setOutputPath(target.getBinPath());
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("unable to resolve the target path:" + e.getMessage());
        }
        catch (ProjectException e) {
            throw LauncherUtils.createLauncherException("unable to create the executable:" + e.getMessage());
        }
        boolean isPackageModified = ProjectUtils.isProjectUpdated((Project)this.project);
        this.runExecutableTask = new RunExecutableTask(args, this.outStream, this.errStream, target);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetDirTask(isPackageModified, buildOptions.enableCache()), isSingleFileBuild).addTask(new RunBuildToolsTask(this.outStream), isSingleFileBuild).addTask(new ResolveMavenDependenciesTask(this.outStream)).addTask(new CompileTask(this.outStream, this.errStream, false, false, isPackageModified, buildOptions.enableCache())).addTask(new CreateExecutableTask(this.outStream, null, target, true)).addTask(this.runExecutableTask).addTask(new DumpBuildTimeTask(this.outStream), !this.project.buildOptions().dumpBuildTime()).build();
        taskExecutor.executeTasks(this.project);
    }

    @Override
    public String getName() {
        return "run";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("run"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("  bal run [--debug <port>] <executable-jar>\n");
        out.append("  bal run [--offline] [<balfile> | <project-path>]\n[--] [args...] \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    public void unsetWatch() {
        this.watch = false;
    }

    public void killProcess() {
        if (this.runExecutableTask != null) {
            this.runExecutableTask.killProcess();
        }
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setCodeCoverage(Boolean.valueOf(false)).setExperimental(Boolean.valueOf(this.experimentalFlag)).setOffline(this.offline).setSkipTests(Boolean.valueOf(true)).setTestReport(Boolean.valueOf(false)).setObservabilityIncluded(this.observabilityIncluded).setRemoteManagement(this.remoteManagement).setSticky(this.sticky).setDumpGraph(Boolean.valueOf(this.dumpGraph)).setDumpRawGraphs(Boolean.valueOf(this.dumpRawGraphs)).setConfigSchemaGen(this.configSchemaGen).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setDumpBuildTime(this.dumpBuildTime).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation).setLockingMode(this.lockingMode);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.build();
    }

    public boolean containsService() {
        return this.project == null || ProjectUtils.containsDefaultModuleService((Package)this.project.currentPackage());
    }
}

