/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.utils.PrintUtils;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.model.PackageSearchResult;
import org.wso2.ballerinalang.util.RepoUtils;
import picocli.CommandLine;

@CommandLine.Command(name="search", description={"Search Ballerina Central for packages"})
public class SearchCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private final boolean exitWhenFinish;
    @CommandLine.Parameters
    private List<String> argList;
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--debug"}, hidden=true)
    private String debugPort;

    public SearchCommand() {
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    public SearchCommand(PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
    }

    @Override
    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("search");
            this.outStream.println(commandUsageInfo);
            return;
        }
        if (null != this.debugPort) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.argList == null || this.argList.isEmpty()) {
            CommandUtil.printError(this.errStream, "no keyword given", "bal search [<org>|<package>|<text>] ", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        if (this.argList.size() > 1) {
            CommandUtil.printError(this.errStream, "too many arguments", "bal search [<org>|<package>|<text>] ", false);
            CommandUtil.exitError(this.exitWhenFinish);
            return;
        }
        String searchArgs = this.argList.get(0);
        this.searchInCentral(searchArgs);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    @Override
    public String getName() {
        return "search";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("search"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append(" bal search [<org>|<package>|<text>] \n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }

    private void searchInCentral(String query) {
        block5: {
            try {
                Settings settings = RepoUtils.readSettings();
                CentralAPIClient client = new CentralAPIClient(RepoUtils.getRemoteRepoURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), settings.getProxy().username(), settings.getProxy().password(), ProjectUtils.getAccessTokenOfCLI((Settings)settings), settings.getCentral().getConnectTimeout(), settings.getCentral().getReadTimeout(), settings.getCentral().getWriteTimeout(), settings.getCentral().getCallTimeout(), settings.getCentral().getMaxRetries());
                boolean foundSearch = false;
                String supportedPlatform = Arrays.stream(JvmTarget.values()).map(target -> target.code()).collect(Collectors.joining(","));
                PackageSearchResult packageSearchResult = client.searchPackage(query, supportedPlatform, RepoUtils.getBallerinaVersion());
                if (packageSearchResult.getCount() > 0) {
                    PrintUtils.printPackages(packageSearchResult.getPackages(), RepoUtils.getTerminalWidth());
                    foundSearch = true;
                }
                if (!foundSearch) {
                    this.outStream.println("no modules found");
                }
            }
            catch (CentralClientException e) {
                String errorMessage = e.getMessage();
                if (null == errorMessage || errorMessage.trim().isEmpty()) break block5;
                if (errorMessage.contains("\n\tat")) {
                    errorMessage = errorMessage.substring(0, errorMessage.indexOf("\n\tat"));
                }
                CommandUtil.printError(this.errStream, errorMessage, null, false);
                CommandUtil.exitError(this.exitWhenFinish);
            }
        }
    }
}

