/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.TaskExecutor;
import io.ballerina.cli.cmd.CommandUtil;
import io.ballerina.cli.task.CleanTargetBinTestsDirTask;
import io.ballerina.cli.task.CleanTargetCacheDirTask;
import io.ballerina.cli.task.CompileTask;
import io.ballerina.cli.task.CreateTestExecutableTask;
import io.ballerina.cli.task.DumpBuildTimeTask;
import io.ballerina.cli.task.ResolveMavenDependenciesTask;
import io.ballerina.cli.task.RunBuildToolsTask;
import io.ballerina.cli.task.RunNativeImageTestTask;
import io.ballerina.cli.task.RunTestsTask;
import io.ballerina.cli.utils.BuildTime;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.util.ProjectUtils;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="test", description={"Run package tests"})
public class TestCommand
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private Path projectPath;
    private final boolean exitWhenFinish;
    @CommandLine.Option(names={"--offline"}, description={"Run package tests"})
    private Boolean offline;
    @CommandLine.Parameters(description={"Program arguments"})
    private List<String> argList = new ArrayList<String>();
    @CommandLine.Option(names={"--help", "-h"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"--experimental"}, description={"Enable experimental language features."})
    private boolean experimentalFlag;
    @CommandLine.Option(names={"--debug"}, description={"start in remote debugging mode"})
    private String debugPort;
    @CommandLine.Option(names={"--parallel"}, description={"enable parallel execution of tests"}, defaultValue="false")
    private boolean isParallelExecution;
    @CommandLine.Option(names={"--list-groups"}, description={"list the groups available in the tests"})
    private boolean listGroups;
    @CommandLine.Option(names={"--groups"}, description={"test groups to be executed"})
    private String groupList;
    @CommandLine.Option(names={"--disable-groups"}, description={"test groups to be disabled"})
    private String disableGroupList;
    @CommandLine.Option(names={"--test-report"}, description={"enable test report generation"})
    private Boolean testReport;
    @CommandLine.Option(names={"--code-coverage"}, description={"enable code coverage"})
    private Boolean coverage;
    @CommandLine.Option(names={"--coverage-format"}, description={"list of supported coverage report formats"})
    private String coverageFormat;
    @CommandLine.Option(names={"--observability-included"}, description={"package observability in the executable."})
    private Boolean observabilityIncluded;
    @CommandLine.Option(names={"--tests"}, description={"Test functions to be executed"})
    private String testList;
    @CommandLine.Option(names={"--rerun-failed"}, description={"Rerun failed tests."})
    private boolean rerunTests;
    @CommandLine.Option(names={"--includes"}, hidden=true, description={"hidden option for code coverage to include all classes"})
    private String includes;
    @CommandLine.Option(names={"--dump-build-time"}, description={"calculate and dump build time"}, hidden=true)
    private Boolean dumpBuildTime;
    @CommandLine.Option(names={"--sticky"}, description={"stick to exact versions locked (if exists)"})
    private Boolean sticky;
    @CommandLine.Option(names={"--target-dir"}, description={"target directory path"})
    private Path targetDir;
    @CommandLine.Option(names={"--dump-graph"}, description={"Print the dependency graph."}, hidden=true)
    private boolean dumpGraph;
    @CommandLine.Option(names={"--dump-raw-graphs"}, description={"Print all intermediate graphs created in the dependency resolution process."}, hidden=true)
    private boolean dumpRawGraphs;
    @CommandLine.Option(names={"--enable-cache"}, description={"enable caches for the compilation"}, hidden=true)
    private Boolean enableCache;
    @CommandLine.Option(names={"--graalvm"}, description={"enable running test suite against native image"})
    private Boolean nativeImage;
    @CommandLine.Option(names={"--excludes"}, description={"option to exclude source files/folders from code coverage"})
    private String excludes;
    @CommandLine.Option(names={"--disable-syntax-tree-caching"}, hidden=true, description={"disable syntax tree caching for source files"}, defaultValue="false")
    private Boolean disableSyntaxTreeCaching;
    @CommandLine.Option(names={"--graalvm-build-options"}, description={"additional build options for native image generation"})
    private String graalVMBuildOptions;
    @CommandLine.Option(names={"--show-dependency-diagnostics"}, description={"Show the diagnostics generated by the dependencies"})
    private Boolean showDependencyDiagnostics;
    @CommandLine.Option(names={"--cloud"}, description={"Enable cloud artifact generation"})
    private String cloud;
    @CommandLine.Option(names={"--optimize-dependency-compilation"}, hidden=true, description={"experimental memory optimization for large projects"})
    private Boolean optimizeDependencyCompilation;
    @CommandLine.Option(names={"--locking-mode"}, hidden=true, description={"allow passing the package locking mode."})
    private String lockingMode;
    @CommandLine.Option(names={"--min-coverage"}, description={"minimum code coverage percentage to pass the test"})
    private Float minCoverage;
    private static final String testCmd = "bal test [--OPTIONS]\n                   [<ballerina-file> | <package-path>] [(-Ckey=value)...]";

    public TestCommand() {
        this.projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = true;
    }

    TestCommand(Path projectPath, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    TestCommand(Path projectPath, boolean exitWhenFinish, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.outStream = System.out;
        this.errStream = System.err;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.offline = true;
    }

    TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Boolean testReport, Boolean coverage, String coverageFormat, Boolean optimizeDependencyCompilation) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.testReport = testReport;
        this.coverage = coverage;
        this.coverageFormat = coverageFormat;
        this.optimizeDependencyCompilation = optimizeDependencyCompilation;
        this.offline = true;
    }

    TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, Boolean testReport, Path targetDir) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.testReport = testReport;
        this.targetDir = targetDir;
        this.offline = true;
    }

    TestCommand(Path projectPath, PrintStream outStream, PrintStream errStream, boolean exitWhenFinish, boolean nativeImage, String graalVMBuildOptions) {
        this.projectPath = projectPath;
        this.outStream = outStream;
        this.errStream = errStream;
        this.exitWhenFinish = exitWhenFinish;
        this.nativeImage = nativeImage;
        this.offline = true;
        this.graalVMBuildOptions = graalVMBuildOptions;
    }

    @Override
    public void execute() {
        SingleFileProject project;
        long start = 0L;
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo("test");
            this.errStream.println(commandUsageInfo);
            return;
        }
        String[] cliArgs = new String[]{};
        if (!this.argList.isEmpty()) {
            if (!this.argList.get(0).matches("-C[\\w\\W]+=([\\w\\W]+)")) {
                this.projectPath = Path.of(this.argList.get(0), new String[0]);
                if (this.argList.size() > 1) {
                    cliArgs = this.argList.subList(1, this.argList.size()).toArray(new String[0]);
                }
            } else {
                cliArgs = this.argList.toArray(new String[0]);
            }
        }
        if (this.isParallelExecution) {
            this.outStream.println("WARNING: Running tests in parallel is an experimental feature");
        }
        if (FileUtils.hasExtension(this.projectPath)) {
            if (this.coverage != null && this.coverage.booleanValue()) {
                this.outStream.println("Code coverage is not yet supported with single bal files. Ignoring the flag and continuing the test run...");
            }
            this.coverage = false;
            this.testReport = false;
        }
        BuildOptions buildOptions = this.constructBuildOptions();
        boolean isSingleFile = false;
        if (FileUtils.hasExtension(this.projectPath)) {
            try {
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
                }
                project = SingleFileProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
                }
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), testCmd, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            isSingleFile = true;
        } else {
            try {
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().timestamp = start = System.currentTimeMillis();
                }
                project = BuildProject.load((Path)this.projectPath, (BuildOptions)buildOptions);
                if (buildOptions.dumpBuildTime()) {
                    BuildTime.getInstance().projectLoadDuration = System.currentTimeMillis() - start;
                }
            }
            catch (ProjectException e) {
                CommandUtil.printError(this.errStream, e.getMessage(), testCmd, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
        }
        if (this.debugPort != null) {
            System.setProperty("debug", this.debugPort);
        }
        if (this.listGroups && (this.rerunTests || this.coverage != null || this.testReport != null || this.groupList != null || this.disableGroupList != null || this.testList != null)) {
            this.outStream.println("\nWarning: Other flags are skipped when list-groups flag is provided.\n");
        }
        if (project.buildOptions().codeCoverage()) {
            if (this.coverageFormat != null && !this.coverageFormat.equals("xml")) {
                String errMsg = "unsupported coverage report format '" + this.coverageFormat + "' found. Only 'xml' format is supported.";
                CommandUtil.printError(this.errStream, errMsg, null, false);
                CommandUtil.exitError(this.exitWhenFinish);
                return;
            }
            if (this.excludes != null && this.excludes.isEmpty()) {
                this.outStream.println("warning: ignoring --excludes flag since given exclusion list is empty");
            }
        } else {
            if (this.includes != null) {
                this.outStream.println("warning: ignoring --includes flag since code coverage is not enabled");
            }
            if (this.coverageFormat != null) {
                this.outStream.println("warning: ignoring --coverage-format flag since code coverage is not enabled");
            }
            if (this.excludes != null) {
                this.outStream.println("warning: ignoring --excludes flag since code coverage is not enabled");
            }
        }
        if (project.buildOptions().nativeImage() && project.buildOptions().codeCoverage()) {
            this.outStream.println("WARNING: Code coverage generation is not supported with Ballerina native test");
        }
        if (!project.buildOptions().nativeImage() && !project.buildOptions().graalVMBuildOptions().isEmpty()) {
            this.outStream.println("WARNING: Additional GraalVM build options are ignored since graalvm flag is not set");
        }
        if (!project.buildOptions().cloud().isEmpty() && project.buildOptions().codeCoverage()) {
            this.outStream.println("WARNING: Code coverage generation is not supported with Ballerina cloud test");
        }
        if (!project.buildOptions().cloud().isEmpty() && this.rerunTests) {
            this.outStream.println("WARNING: Rerun failed tests is not supported with Ballerina cloud test");
        }
        if (!project.buildOptions().cloud().isEmpty() && project.buildOptions().testReport()) {
            this.outStream.println("WARNING: Test report generation is not supported with Ballerina cloud test");
        }
        TaskExecutor preBuildTaskExecutor = new TaskExecutor.TaskBuilder().addTask(new CleanTargetCacheDirTask(), isSingleFile).addTask(new CleanTargetBinTestsDirTask(), isSingleFile || project.buildOptions().cloud().isEmpty()).addTask(new RunBuildToolsTask(this.outStream), isSingleFile).build();
        preBuildTaskExecutor.executeTasks((Project)project);
        Iterable originalModules = project.currentPackage().modules();
        HashMap<String, Module> moduleMap = new HashMap<String, Module>();
        for (Module originalModule : originalModules) {
            moduleMap.put(originalModule.moduleName().toString(), originalModule);
        }
        boolean isPackageModified = ProjectUtils.isProjectUpdated((Project)project);
        TaskExecutor taskExecutor = new TaskExecutor.TaskBuilder().addTask(new ResolveMavenDependenciesTask(this.outStream)).addTask(new CompileTask(this.outStream, this.errStream, false, false, isPackageModified, buildOptions.enableCache())).addTask(new CreateTestExecutableTask(this.outStream, this.groupList, this.disableGroupList, this.testList, this.listGroups, cliArgs, this.isParallelExecution), project.buildOptions().cloud().isEmpty()).addTask(new RunTestsTask(this.outStream, this.errStream, this.rerunTests, this.groupList, this.disableGroupList, this.testList, this.includes, this.coverageFormat, moduleMap, this.listGroups, this.excludes, cliArgs, this.isParallelExecution, this.minCoverage), project.buildOptions().nativeImage() || !project.buildOptions().cloud().isEmpty()).addTask(new RunNativeImageTestTask(this.outStream, this.rerunTests, this.groupList, this.disableGroupList, this.testList, this.includes, this.coverageFormat, moduleMap, this.listGroups, this.isParallelExecution), !project.buildOptions().nativeImage() || !project.buildOptions().cloud().isEmpty()).addTask(new DumpBuildTimeTask(this.outStream), !project.buildOptions().dumpBuildTime()).build();
        taskExecutor.executeTasks((Project)project);
        if (this.exitWhenFinish) {
            Runtime.getRuntime().exit(0);
        }
    }

    private BuildOptions constructBuildOptions() {
        BuildOptions.BuildOptionsBuilder buildOptionsBuilder = BuildOptions.builder();
        buildOptionsBuilder.setCodeCoverage(this.coverage).setExperimental(Boolean.valueOf(this.experimentalFlag)).setOffline(this.offline).setSkipTests(Boolean.valueOf(false)).setTestReport(this.testReport).setObservabilityIncluded(this.observabilityIncluded).setDumpBuildTime(this.dumpBuildTime).setSticky(this.sticky).setCloud(this.cloud).setDumpGraph(Boolean.valueOf(this.dumpGraph)).setDumpRawGraphs(Boolean.valueOf(this.dumpRawGraphs)).setNativeImage(this.nativeImage).setEnableCache(this.enableCache).disableSyntaxTreeCaching(this.disableSyntaxTreeCaching).setGraalVMBuildOptions(this.graalVMBuildOptions).setShowDependencyDiagnostics(this.showDependencyDiagnostics).setOptimizeDependencyCompilation(this.optimizeDependencyCompilation).setLockingMode(this.lockingMode);
        if (this.targetDir != null) {
            buildOptionsBuilder.targetDir(this.targetDir.toString());
        }
        return buildOptionsBuilder.build();
    }

    @Override
    public String getName() {
        return "test";
    }

    @Override
    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo("test"));
    }

    @Override
    public void printUsage(StringBuilder out) {
        out.append("bal test [--OPTIONS]\n                   [<ballerina-file> | <package-path>] [(-Ckey=value)...]\n");
    }

    @Override
    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

