/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.task;

import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.cli.launcher.RuntimePanicException;
import io.ballerina.cli.task.Task;
import io.ballerina.cli.utils.DebugUtils;
import io.ballerina.cli.utils.FileUtils;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.internal.model.Target;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;

public class RunProfilerTask
implements Task {
    private final PrintStream err;
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String CURRENT_DIR_KEY = "current.dir";
    private static final Path TARGET_OUTPUT_PATH = Path.of(System.getProperty("user.dir"), new String[0]);

    public RunProfilerTask(PrintStream errStream) {
        this.err = errStream;
    }

    private void initiateProfiler(Project project) {
        String profilerSource = Path.of(System.getProperty("ballerina.home"), "bre", "lib", "ballerina-profiler-1.0.jar").toString();
        Path sourcePath = Path.of(profilerSource, new String[0]);
        Path targetPath = this.getTargetProfilerPath(project);
        StandardCopyOption copyOption = StandardCopyOption.REPLACE_EXISTING;
        String javaOpts = System.getenv().get(JAVA_OPTS);
        try {
            Files.copy(sourcePath, targetPath, copyOption);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(System.getProperty("java.command"));
            if (javaOpts != null) {
                commands.add(javaOpts.trim());
            }
            commands.add("-jar");
            if (DebugUtils.isInDebugMode()) {
                commands.add(DebugUtils.getDebugArgs(this.err));
            }
            commands.add("Profiler.jar");
            commands.add("--file");
            commands.add(this.getTargetFilePath(project));
            if (DebugUtils.isInProfileDebugMode()) {
                commands.add("--profiler-debug");
                commands.add(DebugUtils.getProfileDebugArg(this.err));
            }
            ProcessBuilder pb = new ProcessBuilder(commands).inheritIO();
            if (javaOpts != null) {
                pb.environment().put(JAVA_OPTS, javaOpts.trim());
            }
            pb.environment().put("ballerina.home", System.getProperty("ballerina.home"));
            pb.environment().put(CURRENT_DIR_KEY, System.getProperty("user.dir"));
            pb.environment().put("java.command", System.getProperty("java.command"));
            pb.directory(new File(this.getProfilerPath(project).toUri()));
            Process process = pb.start();
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                throw new RuntimePanicException(exitValue);
            }
        }
        catch (IOException | InterruptedException e) {
            throw LauncherUtils.createLauncherException("error occurred while running the profiler ", e);
        }
        finally {
            try {
                Files.deleteIfExists(targetPath);
            }
            catch (IOException e) {
                this.err.println("error occurred while deleting the profiler.jar file");
            }
        }
    }

    @Override
    public void execute(Project project) {
        this.initiateProfiler(project);
    }

    private Path getTargetProfilerPath(Project project) {
        return this.getProfilerPath(project).resolve("Profiler.jar");
    }

    private Path getProfilerPath(Project project) {
        try {
            Target target = new Target(this.getTargetPath(project));
            return target.getProfilerPath();
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("error while creating profiler directory: ", e);
        }
    }

    private Path getTargetPath(Project project) {
        if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            return TARGET_OUTPUT_PATH;
        }
        return project.targetDir();
    }

    private String getTargetFilePath(Project project) {
        if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            return Path.of(TARGET_OUTPUT_PATH.resolve(FileUtils.getFileNameWithoutExtension(project.sourceRoot()) + ".jar").toUri()).toString();
        }
        return Path.of(project.targetDir().resolve("bin").resolve(String.valueOf(project.currentPackage().packageName()) + ".jar").toUri()).toString();
    }
}

