/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import io.ballerina.toml.api.Toml;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getFileNameWithoutExtension(Path filePath) {
        Path fileName = filePath.getFileName();
        if (null != fileName) {
            int index = FileUtils.indexOfExtension(fileName.toString());
            return index == -1 ? fileName.toString() : fileName.toString().substring(0, index);
        }
        return null;
    }

    public static String getExtension(Path filePath) {
        Path fileName = filePath.getFileName();
        if (null == fileName) {
            return "";
        }
        Optional<String> extension = Optional.of(fileName.toString()).filter(f -> f.contains(".")).map(f -> f.substring(fileName.toString().lastIndexOf(".") + 1));
        return extension.orElse("");
    }

    public static boolean hasExtension(Path filePath) {
        if (filePath.toFile().isDirectory()) {
            return false;
        }
        Path fileName = filePath.getFileName();
        if (null != fileName) {
            int index = FileUtils.indexOfExtension(fileName.toString());
            return index != -1;
        }
        return false;
    }

    private static int indexOfExtension(String filename) {
        if (filename == null) {
            return -1;
        }
        int extensionPos = filename.lastIndexOf(46);
        int lastSeparator = FileUtils.indexOfLastSeparator(filename);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static int indexOfLastSeparator(String filename) {
        if (filename == null) {
            return -1;
        }
        int lastUnixPos = filename.lastIndexOf(47);
        int lastWindowsPos = filename.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String readSchema(String toolName, ClassLoader classLoader) throws IOException {
        String schemaFilePath = toolName + "-options-schema.json";
        InputStream inputStream = classLoader.getResourceAsStream(schemaFilePath);
        if (inputStream == null) {
            throw new FileNotFoundException("Schema file for tool options inputStream not found: " + schemaFilePath);
        }
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(inputStreamReader);){
            String content;
            while ((content = br.readLine()) != null) {
                if (!sb.isEmpty()) {
                    sb.append('\n');
                }
                sb.append(content);
            }
        }
        return sb.toString();
    }

    public static void validateToml(Toml optionsToml, String toolName, ClassLoader classLoader) throws IOException {
        Schema schema = Schema.from((String)FileUtils.readSchema(toolName, classLoader));
        TomlValidator tomlValidator = new TomlValidator(schema);
        tomlValidator.validate(optionsToml);
    }
}

