/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.cli.utils;

import com.google.gson.Gson;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleDescriptor;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.ModuleName;
import io.ballerina.projects.Package;
import io.ballerina.projects.PlatformLibrary;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.ResolvedPackageDependency;
import io.ballerina.projects.internal.model.Target;
import io.ballerina.projects.util.ProjectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.test.runtime.entity.CoverageReport;
import org.ballerinalang.test.runtime.entity.ModuleCoverage;
import org.ballerinalang.test.runtime.entity.ModuleStatus;
import org.ballerinalang.test.runtime.entity.TestReport;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.test.runtime.util.CodeCoverageUtils;
import org.ballerinalang.testerina.core.TestProcessor;

public final class TestUtils {
    private TestUtils() {
    }

    public static void generateCoverage(Project project, TestReport testReport, JBallerinaBackend jBallerinaBackend, String includesInCoverage, String coverageReportFormat, Map<String, Module> coverageModules, Set<String> exclusionClassList) throws IOException {
        if (!project.buildOptions().codeCoverage()) {
            return;
        }
        if (testReport == null) {
            return;
        }
        Map<String, ModuleCoverage> moduleCoverageMap = TestUtils.initializeCoverageMap(project);
        ArrayList packageSourceCoverageList = new ArrayList();
        ArrayList packageNativeClassCoverageList = new ArrayList();
        ArrayList packageBalClassCoverageList = new ArrayList();
        ArrayList packageExecData = new ArrayList();
        ArrayList packageSessionInfo = new ArrayList();
        for (ModuleId moduleId : project.currentPackage().moduleIds()) {
            Module module = project.currentPackage().module(moduleId);
            CoverageReport coverageReport = new CoverageReport(module, moduleCoverageMap, packageNativeClassCoverageList, packageBalClassCoverageList, packageSourceCoverageList, packageExecData, packageSessionInfo);
            coverageReport.generateReport(jBallerinaBackend, includesInCoverage, coverageReportFormat, coverageModules.get(module.moduleName().toString()), exclusionClassList);
        }
        for (Map.Entry entry : moduleCoverageMap.entrySet()) {
            String moduleName = (String)entry.getKey();
            ModuleCoverage moduleCoverage = (ModuleCoverage)entry.getValue();
            testReport.addCoverage(moduleName, moduleCoverage);
        }
        if (CodeCoverageUtils.isRequestedReportFormat((String)coverageReportFormat, (String)"xml")) {
            CodeCoverageUtils.createXMLReport((Project)project, packageExecData, packageNativeClassCoverageList, packageBalClassCoverageList, packageSourceCoverageList, packageSessionInfo);
        }
    }

    private static Map<String, ModuleCoverage> initializeCoverageMap(Project project) {
        HashMap<String, ModuleCoverage> moduleCoverageMap = new HashMap<String, ModuleCoverage>();
        for (ModuleId moduleId : project.currentPackage().moduleIds()) {
            Module module = project.currentPackage().module(moduleId);
            moduleCoverageMap.put(module.moduleName().toString(), new ModuleCoverage());
        }
        return moduleCoverageMap;
    }

    public static void generateTesterinaReports(Project project, TestReport testReport, PrintStream out, Target target) throws IOException {
        block33: {
            if (!project.buildOptions().testReport() && !project.buildOptions().codeCoverage()) {
                return;
            }
            if (testReport.getModuleStatus().size() <= 0) {
                return;
            }
            out.println();
            out.println("Generating Test Report");
            Path reportDir = target.getReportPath();
            Object projectName = project.kind() == ProjectKind.SINGLE_FILE_PROJECT ? ProjectUtils.getJarFileName((Module)project.currentPackage().getDefaultModule()) + ".bal" : project.currentPackage().packageName().toString();
            testReport.setProjectName((String)projectName);
            testReport.finalizeTestResults(project.buildOptions().codeCoverage());
            Gson gson = new Gson();
            String json = gson.toJson((Object)testReport);
            File jsonFile = new File(reportDir.resolve("test_results.json").toString());
            try (FileOutputStream fileOutputStream = new FileOutputStream(jsonFile);
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
                out.println("\t" + String.valueOf(jsonFile.toPath()) + "\n");
            }
            if (project.buildOptions().testReport()) {
                Path reportZipPath = TestUtils.getReportToolsPath();
                if (Files.exists(reportZipPath, new LinkOption[0])) {
                    String content;
                    try {
                        try (FileInputStream fileInputStream = new FileInputStream(reportZipPath.toFile());){
                            CodeCoverageUtils.unzipReportResources((InputStream)fileInputStream, (File)reportDir.toFile());
                        }
                        content = Files.readString(reportDir.resolve("index.html"));
                        content = content.replace("__data__", json);
                    }
                    catch (IOException e) {
                        throw LauncherUtils.createLauncherException("error occurred while preparing test report: " + String.valueOf(e));
                    }
                    File htmlFile = new File(reportDir.resolve("index.html").toString());
                    try (FileOutputStream fileOutputStream = new FileOutputStream(htmlFile);
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                        writer.write(new String(content.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
                        out.println("\tView the test report at: file://" + String.valueOf(Path.of(htmlFile.getPath(), new String[0]).toAbsolutePath().normalize()));
                        break block33;
                    }
                }
                String reportToolsPath = "<ballerina.home>" + File.separator + "lib" + File.separator + "tools" + File.separator + "coverage" + File.separator + "report.zip";
                out.println("warning: Could not find the required HTML report tools for code coverage at " + reportToolsPath);
            }
        }
    }

    public static Path getReportToolsPath() {
        return Path.of(System.getProperty("ballerina.home"), new String[0]).resolve("lib").resolve("tools").resolve("coverage").resolve("report.zip");
    }

    public static ModuleStatus loadModuleStatusFromFile(Path statusJsonPath) throws IOException {
        File statusJsonFile = new File(statusJsonPath.toUri());
        if (!statusJsonFile.isFile()) {
            return null;
        }
        Gson gson = new Gson();
        BufferedReader bufferedReader = Files.newBufferedReader(statusJsonPath, StandardCharsets.UTF_8);
        return (ModuleStatus)gson.fromJson((Reader)bufferedReader, ModuleStatus.class);
    }

    public static void writeToTestSuiteJson(Map<String, TestSuite> testSuiteMap, Path testsCachePath) {
        if (!Files.exists(testsCachePath, new LinkOption[0])) {
            try {
                Files.createDirectories(testsCachePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("couldn't create test cache directories : " + String.valueOf(e));
            }
        }
        Path jsonFilePath = TestUtils.getJsonFilePath(testsCachePath);
        File jsonFile = new File(jsonFilePath.toString());
        try (FileOutputStream fileOutputStream = new FileOutputStream(jsonFile);){
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                Gson gson = new Gson();
                String json = gson.toJson(testSuiteMap);
                writer.write(new String(json.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("couldn't write data to test suite file : " + String.valueOf(e));
            }
        }
        catch (IOException e) {
            throw LauncherUtils.createLauncherException("couldn't write data to test suite file : " + String.valueOf(e));
        }
    }

    public static boolean createTestSuitesForProject(Project project, Target target, TestProcessor testProcessor, Map<String, TestSuite> testSuiteMap, List<String> moduleNamesList, List<String> mockClassNames, boolean isRerunTestExecution, boolean report, boolean coverage) {
        boolean hasTests = false;
        for (ModuleDescriptor moduleDescriptor : project.currentPackage().moduleDependencyGraph().toTopologicallySortedList()) {
            Module module = project.currentPackage().module(moduleDescriptor.name());
            ModuleName moduleName = module.moduleName();
            TestSuite suite = testProcessor.testSuite(module).orElse(null);
            if (suite == null) continue;
            hasTests = true;
            if (!isRerunTestExecution) {
                TestUtils.clearFailedTestsJson(target.path());
            }
            if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                Optional<Path> sourceRootFileName = Optional.ofNullable(project.sourceRoot().getFileName());
                if (sourceRootFileName.isPresent()) {
                    suite.setSourceFileName(sourceRootFileName.get().toString());
                } else {
                    throw new IllegalStateException("Source root file name is not present");
                }
            }
            suite.setReportRequired(report || coverage);
            String resolvedModuleName = TestUtils.getResolvedModuleName(module, moduleName);
            testSuiteMap.put(resolvedModuleName, suite);
            moduleNamesList.add(resolvedModuleName);
            TestUtils.addMockClasses(suite, mockClassNames);
        }
        return hasTests;
    }

    public static Path getJsonFilePath(Path testsCachePath) {
        return Path.of(testsCachePath.toString(), "test_suit.json");
    }

    public static String getJsonFilePathInFatJar(String separator) {
        return "cache" + separator + "tests_cache" + separator + "test_suit.json";
    }

    public static void clearFailedTestsJson(Path targetPath) {
        Path rerunTestJsonPath = Path.of(targetPath.toString(), "rerun_test.json");
        if (Files.exists(rerunTestJsonPath, new LinkOption[0])) {
            try {
                Files.delete(rerunTestJsonPath);
            }
            catch (IOException e) {
                throw LauncherUtils.createLauncherException("error while clearing failed tests : ", e);
            }
        }
    }

    public static void cleanTempCache(Project project, Path cachesRoot) {
        if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            ProjectUtils.deleteDirectory((Path)cachesRoot);
        }
    }

    public static String getJacocoAgentJarPath() {
        return Path.of(System.getProperty("ballerina.home"), new String[0]).resolve("bre").resolve("lib").resolve("jacocoagent.jar").toString();
    }

    public static List<String> getInitialCmdArgs(String javaCommand, String userDir) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        if (javaCommand == null) {
            cmdArgs.add(System.getProperty("java.command"));
        } else {
            cmdArgs.add(javaCommand);
        }
        cmdArgs.add("-XX:+HeapDumpOnOutOfMemoryError");
        if (userDir == null) {
            cmdArgs.add("-XX:HeapDumpPath=" + System.getProperty("user.dir"));
        } else {
            cmdArgs.add("-XX:HeapDumpPath=" + userDir);
        }
        return cmdArgs;
    }

    public static void appendRequiredArgs(List<String> cmdArgs, String target, String jacocoAgentJarPath, String testSuiteJsonPath, boolean report, boolean coverage, String groupList, String disableGroupList, String singleExecTests, boolean isRerunTestExecution, boolean listGroups, List<String> cliArgs, boolean isFatJarExecution, boolean isParallelExecution) {
        cmdArgs.add(Boolean.toString(isFatJarExecution));
        cmdArgs.add(testSuiteJsonPath);
        cmdArgs.add(target);
        cmdArgs.add(jacocoAgentJarPath);
        cmdArgs.add(Boolean.toString(report));
        cmdArgs.add(Boolean.toString(coverage));
        cmdArgs.add(groupList != null ? groupList : "");
        cmdArgs.add(disableGroupList != null ? disableGroupList : "");
        cmdArgs.add(singleExecTests != null ? singleExecTests : "");
        cmdArgs.add(Boolean.toString(isRerunTestExecution));
        cmdArgs.add(Boolean.toString(listGroups));
        cmdArgs.add(Boolean.toString(isParallelExecution));
        cmdArgs.addAll(cliArgs);
    }

    public static String getResolvedModuleName(Module module, ModuleName moduleName) {
        return module.isDefaultModule() ? moduleName.toString() : module.moduleName().moduleNamePart();
    }

    public static void addMockClasses(TestSuite suite, List<String> mockClassNames) {
        Map mockFunctionMap = suite.getMockFunctionNamesMap();
        for (Map.Entry entry : mockFunctionMap.entrySet()) {
            String key = (String)entry.getKey();
            String functionToMockClassName = TestUtils.getFunctionToMockClassName(key);
            mockClassNames.add(functionToMockClassName);
        }
    }

    private static String getFunctionToMockClassName(String id) {
        String functionToMockClassName = !id.contains("~") ? id.substring(0, id.indexOf("#")) : (!id.contains("#") ? id.substring(0, id.indexOf("~")) : (id.indexOf("#") < id.indexOf("~") ? id.substring(0, id.indexOf("#")) : id.substring(0, id.indexOf("~"))));
        return functionToMockClassName;
    }

    public static String getClassPath(JBallerinaBackend jBallerinaBackend, Package currentPackage) {
        JarResolver jarResolver = jBallerinaBackend.jarResolver();
        HashSet<Path> jars = new HashSet<Path>(TestUtils.getModuleJarPaths(jBallerinaBackend, currentPackage));
        List<Path> dependencies = TestUtils.getTestDependencyPaths(currentPackage, jarResolver).stream().filter(dependency -> !jars.contains(dependency)).toList();
        StringJoiner classPath = TestUtils.joinClassPaths(dependencies);
        return classPath.toString();
    }

    public static StringJoiner joinClassPaths(List<Path> dependencies) {
        StringJoiner classPath = new StringJoiner(File.pathSeparator);
        dependencies.stream().map(Path::toString).forEach(classPath::add);
        return classPath;
    }

    public static List<Path> getTestDependencyPaths(Package currentPackage, JarResolver jarResolver) {
        ArrayList<Path> dependencies = new ArrayList<Path>();
        for (ModuleId moduleId : currentPackage.moduleIds()) {
            Module module = currentPackage.module(moduleId);
            if (module.testDocumentIds().isEmpty() && !module.project().kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT)) continue;
            for (JarLibrary jarLibs : jarResolver.getJarFilePathsRequiredForTestExecution(module.moduleName())) {
                dependencies.add(jarLibs.path());
            }
        }
        return dependencies.stream().distinct().toList();
    }

    public static List<Path> getModuleJarPaths(JBallerinaBackend jBallerinaBackend, Package currentPackage) {
        ArrayList<Path> moduleJarPaths = new ArrayList<Path>();
        for (ModuleId moduleId : currentPackage.moduleIds()) {
            Module module = currentPackage.module(moduleId);
            moduleJarPaths.addAll(TestUtils.getModuleJarPathsForModule(currentPackage, jBallerinaBackend, module));
        }
        for (ResolvedPackageDependency resolvedPackageDependency : currentPackage.getResolution().allDependencies()) {
            Package pkg = resolvedPackageDependency.packageInstance();
            for (ModuleId moduleId : pkg.moduleIds()) {
                Module module = pkg.module(moduleId);
                moduleJarPaths.add(jBallerinaBackend.codeGeneratedLibrary(pkg.packageId(), module.moduleName()).path());
            }
        }
        return moduleJarPaths.stream().distinct().toList();
    }

    private static PlatformLibrary getCodeGeneratedTestLibrary(JBallerinaBackend jBallerinaBackend, Package currentPackage, Module module) {
        return jBallerinaBackend.codeGeneratedTestLibrary(currentPackage.packageId(), module.moduleName());
    }

    private static PlatformLibrary getPlatformLibrary(JBallerinaBackend jBallerinaBackend, Package currentPackage, Module module) {
        return jBallerinaBackend.codeGeneratedLibrary(currentPackage.packageId(), module.moduleName());
    }

    public static List<Path> getModuleJarPathsForModule(Package currentPackage, JBallerinaBackend jBallerinaBackend, Module module) {
        ArrayList<Path> moduleJarPaths = new ArrayList<Path>();
        PlatformLibrary generatedJarLibrary = TestUtils.getPlatformLibrary(jBallerinaBackend, currentPackage, module);
        moduleJarPaths.add(generatedJarLibrary.path());
        if (!module.testDocumentIds().isEmpty()) {
            PlatformLibrary codeGeneratedTestLibrary = TestUtils.getCodeGeneratedTestLibrary(jBallerinaBackend, currentPackage, module);
            moduleJarPaths.add(codeGeneratedTestLibrary.path());
        }
        return moduleJarPaths;
    }
}

