/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Strand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class Executor {
    private Executor() {
    }

    public static Object executeFunction(Strand strand, ClassLoader classLoader, String className, String methodName, Object ... paramValues) {
        try {
            Class<?> clazz = classLoader.loadClass(className);
            int paramCount = paramValues.length + 1;
            Object[] jvmArgs = new Object[paramCount];
            jvmArgs[0] = strand;
            int j = 1;
            for (int i = 0; i < paramValues.length; ++i) {
                jvmArgs[j++] = paramValues[i];
            }
            Method method = Executor.getMethod(methodName, clazz);
            try {
                return method.invoke(null, jvmArgs);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw ErrorCreator.createError((BString)StringUtils.fromString((String)(methodName + " function invocation failed: " + e.getMessage())));
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("invocation failed: " + e.getMessage())));
        }
    }

    private static Method getMethod(String functionName, Class<?> funcClass) throws NoSuchMethodException {
        Method declaredMethod = Arrays.stream(funcClass.getDeclaredMethods()).filter(method -> functionName.equals(method.getName())).findAny().orElse(null);
        if (declaredMethod != null) {
            return declaredMethod;
        }
        throw new NoSuchMethodException(functionName + " is not found");
    }
}

