/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.csvdata.compiler;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.lib.data.csvdata.compiler.CsvDataDiagnosticCodes;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CsvDataTypeValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private SemanticModel semanticModel;
    private final HashMap<Location, DiagnosticInfo> allDiagnosticInfo = new HashMap();
    Location currentLocation;
    private String modulePrefix = "csv";

    public void perform(SyntaxNodeAnalysisContext ctx) {
        this.semanticModel = ctx.semanticModel();
        List diagnostics = this.semanticModel.diagnostics();
        boolean erroneousCompilation = diagnostics.stream().anyMatch(d -> d.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR));
        if (erroneousCompilation) {
            this.reset();
            return;
        }
        ModulePartNode rootNode = (ModulePartNode)ctx.node();
        this.updateModulePrefix(rootNode);
        for (ModuleMemberDeclarationNode member : rootNode.members()) {
            switch (member.kind()) {
                case FUNCTION_DEFINITION: {
                    this.processFunctionDefinitionNode((FunctionDefinitionNode)member, ctx);
                    break;
                }
                case MODULE_VAR_DECL: {
                    this.processModuleVariableDeclarationNode((ModuleVariableDeclarationNode)member, ctx);
                    break;
                }
                case TYPE_DEFINITION: {
                    this.processTypeDefinitionNode((TypeDefinitionNode)member, ctx);
                }
            }
        }
        this.reset();
    }

    private void reset() {
        this.semanticModel = null;
        this.allDiagnosticInfo.clear();
        this.currentLocation = null;
        this.modulePrefix = "csv";
    }

    private void updateModulePrefix(ModulePartNode rootNode) {
        for (ImportDeclarationNode importDeclarationNode : rootNode.imports()) {
            this.semanticModel.symbol((Node)importDeclarationNode).filter(moduleSymbol -> moduleSymbol.kind() == SymbolKind.MODULE).filter(moduleSymbol -> this.isCsvDataImport((ModuleSymbol)moduleSymbol)).ifPresent(moduleSymbol -> {
                this.modulePrefix = ((ModuleSymbol)moduleSymbol).id().modulePrefix();
            });
        }
    }

    private void processFunctionDefinitionNode(FunctionDefinitionNode functionDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        ChildNodeList childNodeList = functionDefinitionNode.functionBody().children();
        for (Node node : childNodeList) {
            if (node.kind() == SyntaxKind.LOCAL_VAR_DECL) {
                this.processLocalVarDeclNode((VariableDeclarationNode)node, ctx);
                continue;
            }
            if (node.kind() != SyntaxKind.ASSIGNMENT_STATEMENT) continue;
            this.processAssignmentStmtNode((AssignmentStatementNode)node, ctx);
        }
    }

    private void processAssignmentStmtNode(AssignmentStatementNode assignmentStatementNode, SyntaxNodeAnalysisContext ctx) {
        ExpressionNode expressionNode = assignmentStatementNode.expression();
        if (!this.isParseFunctionOfStringSource(expressionNode)) {
            return;
        }
        this.currentLocation = assignmentStatementNode.location();
        this.semanticModel.symbol(assignmentStatementNode.varRef()).map(symbol -> ((VariableSymbol)symbol).typeDescriptor()).ifPresent(typeSymbol -> this.validateFunctionParameterTypes(expressionNode, (TypeSymbol)typeSymbol, this.currentLocation, ctx));
    }

    private void processLocalVarDeclNode(VariableDeclarationNode variableDeclarationNode, SyntaxNodeAnalysisContext ctx) {
        Optional initializer = variableDeclarationNode.initializer();
        if (initializer.isEmpty()) {
            return;
        }
        this.currentLocation = variableDeclarationNode.typedBindingPattern().typeDescriptor().location();
        Optional symbol = this.semanticModel.symbol((Node)variableDeclarationNode.typedBindingPattern());
        if (symbol.isEmpty()) {
            return;
        }
        TypeSymbol typeSymbol = ((VariableSymbol)symbol.get()).typeDescriptor();
        ExpressionNode expressionNode = (ExpressionNode)initializer.get();
        if (!this.isParseFunctionOfStringSource(expressionNode)) {
            this.checkTypeAndDetectDuplicateFields(typeSymbol, ctx);
            return;
        }
        this.validateExpectedType(typeSymbol, this.currentLocation, ctx);
        this.validateFunctionParameterTypes(expressionNode, typeSymbol, (Location)expressionNode.location(), ctx);
    }

    private void checkTypeAndDetectDuplicateFields(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext ctx) {
        switch (typeSymbol.typeKind()) {
            case RECORD: {
                this.detectDuplicateFields((RecordTypeSymbol)typeSymbol, ctx);
                break;
            }
            case ARRAY: {
                this.checkTypeAndDetectDuplicateFields(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor(), ctx);
                break;
            }
            case TUPLE: {
                for (TypeSymbol memberType : ((TupleTypeSymbol)typeSymbol).memberTypeDescriptors()) {
                    this.checkTypeAndDetectDuplicateFields(memberType, ctx);
                }
                break;
            }
            case UNION: {
                for (TypeSymbol memberType : ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors()) {
                    this.checkTypeAndDetectDuplicateFields(memberType, ctx);
                }
                break;
            }
            case TYPE_REFERENCE: {
                this.checkTypeAndDetectDuplicateFields(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), ctx);
                break;
            }
            case INTERSECTION: {
                this.checkTypeAndDetectDuplicateFields(CsvDataTypeValidator.getRawType(typeSymbol), ctx);
            }
        }
    }

    private FunctionCallExpressionNode getFunctionCallExpressionNodeIfPresent(ExpressionNode expressionNode) {
        return switch (expressionNode.kind()) {
            case SyntaxKind.CHECK_EXPRESSION -> this.getFunctionCallExpressionNodeIfPresent(((CheckExpressionNode)expressionNode).expression());
            case SyntaxKind.FUNCTION_CALL -> (FunctionCallExpressionNode)expressionNode;
            default -> null;
        };
    }

    private Optional<String> getFunctionName(FunctionCallExpressionNode node) {
        NameReferenceNode nameReferenceNode = node.functionName();
        if (nameReferenceNode.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return Optional.empty();
        }
        QualifiedNameReferenceNode qualifiedNameReferenceNode = (QualifiedNameReferenceNode)nameReferenceNode;
        String prefix = qualifiedNameReferenceNode.modulePrefix().text();
        if (!prefix.equals(this.modulePrefix)) {
            return Optional.empty();
        }
        return Optional.of(qualifiedNameReferenceNode.identifier().text());
    }

    private boolean isParseFunctionOfStringSource(ExpressionNode expressionNode) {
        FunctionCallExpressionNode node = this.getFunctionCallExpressionNodeIfPresent(expressionNode);
        if (node == null) {
            return false;
        }
        Optional<String> functionName = this.getFunctionName(node);
        return functionName.map(fn -> fn.contains("parseString") || fn.contains("parseBytes") || fn.contains("parseStream") || fn.contains("transform") || fn.contains("parseList")).orElse(false);
    }

    private void validateFunctionParameterTypes(ExpressionNode expressionNode, TypeSymbol expType, Location currentLocation, SyntaxNodeAnalysisContext ctx) {
        FunctionCallExpressionNode node = this.getFunctionCallExpressionNodeIfPresent(expressionNode);
        if (node == null) {
            return;
        }
        Optional<String> functionName = this.getFunctionName(node);
        SeparatedNodeList args = node.arguments();
        functionName.ifPresent(fn -> this.validateFunctionParameterTypesWithExpType(expType, currentLocation, ctx, (String)fn, (SeparatedNodeList<FunctionArgumentNode>)args));
    }

    private void validateFunctionParameterTypesWithExpType(TypeSymbol expType, Location currentLocation, SyntaxNodeAnalysisContext ctx, String functionName, SeparatedNodeList<FunctionArgumentNode> args) {
        switch (expType.typeKind()) {
            case ARRAY: {
                this.validateFunctionParameterTypesWithArrayType((ArrayTypeSymbol)expType, currentLocation, ctx, functionName, args);
                break;
            }
            case TYPE_REFERENCE: {
                this.validateFunctionParameterTypesWithExpType(((TypeReferenceTypeSymbol)expType).typeDescriptor(), currentLocation, ctx, functionName, args);
                break;
            }
            case INTERSECTION: {
                this.validateFunctionParameterTypesWithExpType(CsvDataTypeValidator.getRawType(expType), currentLocation, ctx, functionName, args);
                break;
            }
            case UNION: {
                TypeSymbol nonErrorTypeSymbol;
                List memberTypes = ((UnionTypeSymbol)expType).memberTypeDescriptors();
                if (memberTypes.size() != 2 || !this.isUnionContainsError(memberTypes) || (nonErrorTypeSymbol = this.ignoreErrorTypeFromUnionTypeSymbolAndReturn(memberTypes)) == null) break;
                this.validateFunctionParameterTypesWithExpType(nonErrorTypeSymbol, currentLocation, ctx, functionName, args);
            }
        }
    }

    private boolean isUnionContainsError(List<TypeSymbol> memberTypes) {
        for (TypeSymbol memberSymbol : memberTypes) {
            if (memberSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                memberSymbol = ((TypeReferenceTypeSymbol)memberSymbol).typeDescriptor();
            }
            if (memberSymbol.typeKind() != TypeDescKind.ERROR) continue;
            return true;
        }
        return false;
    }

    private TypeSymbol ignoreErrorTypeFromUnionTypeSymbolAndReturn(List<TypeSymbol> memberTypes) {
        for (TypeSymbol memberSymbol : memberTypes) {
            if (memberSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                memberSymbol = ((TypeReferenceTypeSymbol)memberSymbol).typeDescriptor();
            }
            if (memberSymbol.typeKind() == TypeDescKind.ERROR) continue;
            return memberSymbol;
        }
        return null;
    }

    private void validateFunctionParameterTypesWithArrayType(ArrayTypeSymbol expType, Location currentLocation, SyntaxNodeAnalysisContext ctx, String functionName, SeparatedNodeList<FunctionArgumentNode> args) {
        TypeSymbol memberTypeSymbol = expType.memberTypeDescriptor();
        if (memberTypeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            memberTypeSymbol = ((TypeReferenceTypeSymbol)memberTypeSymbol).typeDescriptor();
        }
        switch (memberTypeSymbol.typeKind()) {
            case RECORD: 
            case MAP: {
                this.validateFunctionParameterTypesWithOptions(currentLocation, ctx, functionName, args, true);
                break;
            }
            case ARRAY: 
            case TUPLE: {
                this.validateFunctionParameterTypesWithOptions(currentLocation, ctx, functionName, args, false);
            }
        }
    }

    private void validateFunctionParameterTypesWithOptions(Location currentLocation, SyntaxNodeAnalysisContext ctx, String functionName, SeparatedNodeList<FunctionArgumentNode> args, boolean isRecord) {
        String header = null;
        String headerRows = null;
        String customHeaders = null;
        String customHeadersIfHeaderAbsent = null;
        String outputWithHeaders = null;
        String headerOrder = null;
        boolean isCustomHeaderPresent = false;
        for (FunctionArgumentNode arg : args) {
            ExpressionNode expression;
            int mappingConstructorExprNodeCount = 0;
            if (arg instanceof PositionalArgumentNode) {
                PositionalArgumentNode positionalArgumentNode = (PositionalArgumentNode)arg;
                expression = positionalArgumentNode.expression();
            } else {
                if (!(arg instanceof NamedArgumentNode)) continue;
                NamedArgumentNode namedArgumentNode = (NamedArgumentNode)arg;
                expression = namedArgumentNode.expression();
            }
            if (!(expression instanceof MappingConstructorExpressionNode)) continue;
            MappingConstructorExpressionNode mappingConstructorExpressionNode = (MappingConstructorExpressionNode)expression;
            this.checkAndAssertMappingConstructorArguments(mappingConstructorExprNodeCount);
            SeparatedNodeList fields = mappingConstructorExpressionNode.fields();
            for (MappingFieldNode field : fields) {
                String fieldName;
                SpecificFieldNode specificFieldNode;
                Node node;
                if (!(field instanceof SpecificFieldNode) || !((node = (specificFieldNode = (SpecificFieldNode)field).fieldName()) instanceof IdentifierToken)) continue;
                IdentifierToken identifierToken = (IdentifierToken)node;
                switch (fieldName = identifierToken.text()) {
                    case "header": {
                        header = this.getTheValueOfTheUserConfigOption(specificFieldNode);
                        break;
                    }
                    case "customHeadersIfHeadersAbsent": {
                        customHeadersIfHeaderAbsent = this.getTheValueOfTheUserConfigOption(specificFieldNode);
                        break;
                    }
                    case "headerRows": {
                        headerRows = this.getTheValueOfTheUserConfigOption(specificFieldNode);
                        break;
                    }
                    case "customHeaders": {
                        customHeaders = this.getTheValueOfTheUserConfigOption(specificFieldNode);
                        isCustomHeaderPresent = true;
                        break;
                    }
                    case "headerOrder": {
                        if (!isRecord) break;
                        headerOrder = this.getTheValueOfTheUserConfigOption(specificFieldNode);
                        break;
                    }
                    case "outputWithHeaders": {
                        if (!isRecord) break;
                        outputWithHeaders = this.getTheValueOfTheUserConfigOption(specificFieldNode);
                    }
                }
            }
        }
        this.throwErrorsIfIgnoredFieldFoundForOutputs(header, customHeadersIfHeaderAbsent, headerRows, customHeaders, isCustomHeaderPresent, headerOrder, outputWithHeaders, ctx, currentLocation, functionName, isRecord);
    }

    private void checkAndAssertMappingConstructorArguments(int mappingConstructorExprNodeCount) {
        if (mappingConstructorExprNodeCount > 1) assert (false) : "MappingConstructorExpressionNode count in the function arguments should be less than or equal to 1";
    }

    private void throwErrorsIfIgnoredFieldFoundForOutputs(String header, String customHeadersIfHeaderAbsent, String headerRows, String customHeaders, boolean isCustomHeaderPresent, String headerOrder, String outputWithHeaders, SyntaxNodeAnalysisContext ctx, Location currentLocation, String functionName, boolean isRecord) {
        switch (functionName) {
            case "parseString": {
                if (header == null || header.equals("()") || header.equals("null") || customHeadersIfHeaderAbsent == null || customHeadersIfHeaderAbsent.equals("()") || customHeadersIfHeaderAbsent.equals("null")) break;
                this.reportDiagnosticInfo(ctx, Optional.ofNullable(currentLocation), CsvDataDiagnosticCodes.IGNORE_CUSTOM_HEADERS_PARAMETER_WHEN_HEADER_PRESENT);
                break;
            }
            case "parseList": {
                if (headerRows == null || headerRows.equals("0") || headerRows.equals("1") || isCustomHeaderPresent && (customHeaders == null || !customHeaders.equals("()") && !customHeaders.equals("null"))) break;
                this.reportDiagnosticInfo(ctx, Optional.ofNullable(currentLocation), CsvDataDiagnosticCodes.CUSTOM_HEADERS_SHOULD_BE_PROVIDED);
                break;
            }
            case "transform": {
                if (!isRecord || headerOrder == null || headerOrder.equals("()") || headerOrder.equals("null")) break;
                this.reportDiagnosticInfo(ctx, Optional.ofNullable(currentLocation), CsvDataDiagnosticCodes.IGNORE_HEADERS_ORDER_FOR_RECORD_ARRAY);
            }
        }
        if (isRecord && outputWithHeaders != null) {
            this.reportDiagnosticInfo(ctx, Optional.ofNullable(currentLocation), CsvDataDiagnosticCodes.IGNORE_OUTPUT_HEADERS_FOR_RECORD_ARRAY);
        }
    }

    private String getTheValueOfTheUserConfigOption(SpecificFieldNode specificFieldNode) {
        return specificFieldNode.valueExpr().map(expNode -> {
            if (expNode instanceof BasicLiteralNode) {
                BasicLiteralNode basicLiteralNode = (BasicLiteralNode)expNode;
                return basicLiteralNode.literalToken().text();
            }
            if (expNode instanceof ListConstructorExpressionNode) {
                ListConstructorExpressionNode listConstructorExpressionNode = (ListConstructorExpressionNode)expNode;
                return listConstructorExpressionNode.expressions().toString();
            }
            if (expNode instanceof NilLiteralNode) {
                return "()";
            }
            return null;
        }).orElse(null);
    }

    private void validateExpectedType(TypeSymbol typeSymbol, Location currentLocation, SyntaxNodeAnalysisContext ctx) {
        switch (typeSymbol.typeKind()) {
            case UNION: {
                this.validateUnionType((UnionTypeSymbol)typeSymbol, currentLocation, ctx);
                break;
            }
            case ARRAY: {
                this.validateArrayType((ArrayTypeSymbol)typeSymbol, currentLocation, ctx);
                break;
            }
            case TUPLE: {
                this.validateTupleType(currentLocation, ctx);
                break;
            }
            case TYPE_REFERENCE: {
                this.validateExpectedType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), currentLocation, ctx);
                break;
            }
            case INTERSECTION: {
                this.validateExpectedType(CsvDataTypeValidator.getRawType(typeSymbol), currentLocation, ctx);
            }
        }
    }

    private void validateTupleType(Location currentLocation, SyntaxNodeAnalysisContext ctx) {
        this.reportDiagnosticInfo(ctx, Optional.ofNullable(currentLocation), CsvDataDiagnosticCodes.UNSUPPORTED_TYPE);
    }

    private void validateArrayType(ArrayTypeSymbol typeSymbol, Location currentLocation, SyntaxNodeAnalysisContext ctx) {
        if (!this.isSupportedArrayMemberType(ctx, currentLocation, typeSymbol.memberTypeDescriptor())) {
            this.reportDiagnosticInfo(ctx, Optional.ofNullable(currentLocation), CsvDataDiagnosticCodes.UNSUPPORTED_TYPE);
        }
    }

    private void validateUnionType(UnionTypeSymbol unionTypeSymbol, Location currentLocation, SyntaxNodeAnalysisContext ctx) {
        List memberTypeSymbols = unionTypeSymbol.memberTypeDescriptors();
        for (TypeSymbol memberTypeSymbol : memberTypeSymbols) {
            this.validateExpectedType(memberTypeSymbol, currentLocation, ctx);
        }
    }

    private boolean isSupportedArrayMemberType(SyntaxNodeAnalysisContext ctx, Location currentLocation, TypeSymbol typeSymbol) {
        TypeDescKind kind;
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            typeSymbol = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
        }
        if (typeSymbol.typeKind() == TypeDescKind.INTERSECTION) {
            typeSymbol = CsvDataTypeValidator.getRawType(typeSymbol);
        }
        if ((kind = typeSymbol.typeKind()) == TypeDescKind.TYPE_REFERENCE) {
            kind = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor().typeKind();
        }
        switch (kind) {
            case ARRAY: 
            case UNION: 
            case INTERSECTION: 
            case MAP: {
                return true;
            }
            case RECORD: {
                this.validateRecordFields(ctx, currentLocation, typeSymbol);
                break;
            }
            case TUPLE: {
                this.validateTupleMembers(ctx, currentLocation, typeSymbol);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void validateTupleMembers(SyntaxNodeAnalysisContext ctx, Location currentLocation, TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            typeSymbol = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
        }
        TupleTypeSymbol tupleTypeSymbol = (TupleTypeSymbol)typeSymbol;
        tupleTypeSymbol.memberTypeDescriptors().forEach(symbol -> this.validateNestedTypeSymbols(ctx, currentLocation, (TypeSymbol)symbol, false));
        tupleTypeSymbol.restTypeDescriptor().ifPresent(restSym -> this.validateNestedTypeSymbols(ctx, currentLocation, (TypeSymbol)restSym, false));
    }

    private void validateRecordFields(SyntaxNodeAnalysisContext ctx, Location currentLocation, TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            typeSymbol = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
        }
        RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
        recordTypeSymbol.typeInclusions().forEach(symbol -> this.validateNestedTypeSymbols(ctx, currentLocation, (TypeSymbol)symbol, true));
        recordTypeSymbol.fieldDescriptors().values().forEach(field -> this.validateNestedTypeSymbols(ctx, currentLocation, field.typeDescriptor(), true));
        recordTypeSymbol.restTypeDescriptor().ifPresent(restSym -> this.validateNestedTypeSymbols(ctx, currentLocation, (TypeSymbol)restSym, true));
    }

    private void validateNestedTypeSymbols(SyntaxNodeAnalysisContext ctx, Location location, TypeSymbol typeSymbol, boolean isField) {
        TypeDescKind kind = typeSymbol.typeKind();
        if (kind == TypeDescKind.TYPE_REFERENCE) {
            kind = ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor().typeKind();
        }
        switch (kind) {
            case RECORD: 
            case ARRAY: 
            case TUPLE: 
            case TYPE_REFERENCE: 
            case MAP: 
            case OBJECT: 
            case ERROR: 
            case FUNCTION: 
            case STREAM: 
            case FUTURE: 
            case TYPEDESC: 
            case XML: 
            case XML_ELEMENT: 
            case XML_PROCESSING_INSTRUCTION: 
            case XML_COMMENT: 
            case XML_TEXT: 
            case HANDLE: 
            case TABLE: 
            case NEVER: 
            case REGEXP: {
                this.reportDiagnosticInfo(ctx, Optional.ofNullable(location), isField ? CsvDataDiagnosticCodes.UNSUPPORTED_FIELD_TYPE : CsvDataDiagnosticCodes.UNSUPPORTED_TUPLE_MEMBER_TYPE);
            }
        }
    }

    public static TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION) {
            return CsvDataTypeValidator.getRawType(((IntersectionTypeSymbol)typeDescriptor).effectiveTypeDescriptor());
        }
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)typeDescriptor;
            TypeSymbol refType = typeRef.typeDescriptor();
            return switch (refType.typeKind()) {
                case TypeDescKind.TYPE_REFERENCE, TypeDescKind.INTERSECTION -> CsvDataTypeValidator.getRawType(refType);
                default -> refType;
            };
        }
        return typeDescriptor;
    }

    private void reportDiagnosticInfo(SyntaxNodeAnalysisContext ctx, Optional<Location> location, CsvDataDiagnosticCodes diagnosticsCodes) {
        Location pos = location.orElseGet(() -> this.currentLocation);
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticsCodes.getCode(), diagnosticsCodes.getMessage(), diagnosticsCodes.getSeverity());
        if (pos == null || Objects.equals(this.allDiagnosticInfo.get(pos), diagnosticInfo)) {
            return;
        }
        this.allDiagnosticInfo.put(pos, diagnosticInfo);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)pos, (Object[])new Object[0]));
    }

    private void processModuleVariableDeclarationNode(ModuleVariableDeclarationNode moduleVariableDeclarationNode, SyntaxNodeAnalysisContext ctx) {
        Optional initializer = moduleVariableDeclarationNode.initializer();
        this.currentLocation = moduleVariableDeclarationNode.typedBindingPattern().typeDescriptor().location();
        if (initializer.isEmpty()) {
            return;
        }
        ExpressionNode expressionNode = (ExpressionNode)initializer.get();
        if (!this.isParseFunctionOfStringSource(expressionNode)) {
            return;
        }
        Optional symbol = this.semanticModel.symbol((Node)moduleVariableDeclarationNode.typedBindingPattern());
        symbol.map(s -> (VariableSymbol)s).map(VariableSymbol::typeDescriptor).ifPresent(s -> {
            this.validateExpectedType((TypeSymbol)s, this.currentLocation, ctx);
            this.validateFunctionParameterTypes(expressionNode, (TypeSymbol)s, (Location)expressionNode.location(), ctx);
        });
    }

    private void processTypeDefinitionNode(TypeDefinitionNode typeDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        Node typeDescriptor = typeDefinitionNode.typeDescriptor();
        this.currentLocation = typeDefinitionNode.typeDescriptor().location();
        if (typeDescriptor.kind() != SyntaxKind.RECORD_TYPE_DESC) {
            return;
        }
        this.validateRecordTypeDefinition(typeDefinitionNode, ctx);
    }

    private void validateRecordTypeDefinition(TypeDefinitionNode typeDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        this.semanticModel.symbol((Node)typeDefinitionNode).map(symbol -> (TypeDefinitionSymbol)symbol).ifPresent(typeDefinitionSymbol -> this.detectDuplicateFields((RecordTypeSymbol)typeDefinitionSymbol.typeDescriptor(), ctx));
    }

    private void detectDuplicateFields(RecordTypeSymbol recordTypeSymbol, SyntaxNodeAnalysisContext ctx) {
        HashSet<String> fieldMembers = new HashSet<String>();
        for (Map.Entry entry : recordTypeSymbol.fieldDescriptors().entrySet()) {
            RecordFieldSymbol fieldSymbol = (RecordFieldSymbol)entry.getValue();
            String name = this.getNameFromAnnotation((String)entry.getKey(), fieldSymbol.annotAttachments());
            if (fieldMembers.add(name)) continue;
            this.reportDiagnosticInfo(ctx, fieldSymbol.getLocation(), CsvDataDiagnosticCodes.DUPLICATE_FIELD);
            return;
        }
    }

    private String getNameFromAnnotation(String fieldName, List<AnnotationAttachmentSymbol> annotationAttachments) {
        for (AnnotationAttachmentSymbol annotAttSymbol : annotationAttachments) {
            String value;
            Optional nameAnnot;
            AnnotationSymbol annotation = annotAttSymbol.typeDescriptor();
            if (!this.getAnnotModuleName(annotation).contains("csv") || (nameAnnot = annotation.getName()).isEmpty() || !(value = (String)nameAnnot.get()).equals("Name")) continue;
            return ((LinkedHashMap)((ConstantValue)annotAttSymbol.attachmentValue().orElseThrow()).value()).get("value").toString();
        }
        return fieldName;
    }

    private String getAnnotModuleName(AnnotationSymbol annotation) {
        return annotation.getModule().flatMap(ms -> ms.getName()).orElse("");
    }

    private boolean isCsvDataImport(ModuleSymbol moduleSymbol) {
        ModuleID moduleId = moduleSymbol.id();
        return "ballerina".equals(moduleId.orgName()) && "data.csv".equals(moduleId.moduleName());
    }
}

