/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator;

import graphql.schema.GraphQLSchema;
import io.ballerina.graphql.generator.utils.GenerationType;

public abstract class GraphqlProject {
    private String name;
    private String schema;
    private String outputPath;
    private GraphQLSchema graphQLSchema;

    public GraphqlProject(String name, String schema, String outputPath) {
        this.name = name;
        this.schema = schema;
        this.outputPath = outputPath;
    }

    public GraphqlProject(String name, String schema) {
        this.name = name;
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    public String getFileName() {
        String[] splits = this.schema.split("\\\\|/");
        return splits[splits.length - 1].split("\\.")[0];
    }

    public void setGraphQLSchema(GraphQLSchema graphQLSchema) {
        this.graphQLSchema = graphQLSchema;
    }

    public abstract GenerationType getGenerationType();
}

