/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client;

import io.ballerina.graphql.generator.client.exception.IntospectionException;
import io.ballerina.graphql.generator.client.pojo.Default;
import io.ballerina.graphql.generator.client.pojo.Endpoints;
import io.ballerina.graphql.generator.client.pojo.Extension;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.json.JSONObject;

public class Introspector {
    private static Introspector introspector = null;

    public static Introspector getInstance() {
        if (introspector == null) {
            introspector = new Introspector();
        }
        return introspector;
    }

    public Map<String, Object> getIntrospectionResult(String schema, Extension extensions) throws IntospectionException {
        try {
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpRequest httpRequest = extensions != null ? this.createHttpRequest(schema, extensions) : this.createHttpRequest(schema);
            HttpResponse<String> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() == 200) {
                JSONObject introspectionResult = new JSONObject(response.body());
                if (introspectionResult.has("errors") || !introspectionResult.has("data")) {
                    throw new IntospectionException("Failed to retrieve SDL. Please provide a valid GraphQL endpoint with relevant headers or a local SDL file path.");
                }
                return ((JSONObject)introspectionResult.get("data")).toMap();
            }
            throw new IntospectionException("Failed to retrieve SDL. Please provide a valid GraphQL endpoint with relevant headers or a local SDL file path.");
        }
        catch (IOException | InterruptedException e) {
            throw new IntospectionException("Failed to retrieve SDL. Please provide a valid GraphQL endpoint with relevant headers or a local SDL file path." + (String)(e.getMessage() != null ? "\n" + e.getMessage() : ""));
        }
    }

    private HttpRequest createHttpRequest(String endpoint, Extension extensions) {
        Default defaultName;
        Map<String, String> headers = null;
        Endpoints endpoints = extensions.getEndpoints();
        if (endpoints != null && (defaultName = endpoints.getDefaultName()) != null) {
            headers = defaultName.getHeaders();
        }
        String graphqlPayload = this.getRequestPayload();
        HttpRequest request = headers != null ? this.addHeaders(HttpRequest.newBuilder().uri(URI.create(endpoint)).headers("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(graphqlPayload, StandardCharsets.UTF_8)), headers).build() : HttpRequest.newBuilder().uri(URI.create(endpoint)).headers("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(graphqlPayload, StandardCharsets.UTF_8)).build();
        return request;
    }

    private HttpRequest createHttpRequest(String endpoint) {
        String graphqlPayload = this.getRequestPayload();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(endpoint)).headers("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(graphqlPayload, StandardCharsets.UTF_8)).build();
        return request;
    }

    private String getRequestPayload() {
        JSONObject graphqlJsonPayload = new JSONObject();
        graphqlJsonPayload.put("query", (Object)"    query IntrospectionQuery {\n      __schema {\n        queryType { name }\n        mutationType { name }\n        subscriptionType { name }\n        types {\n          ...FullType\n        }\n        directives {\n          name\n          description\n          locations\n          args {\n            ...InputValue\n          }\n        }\n      }\n    }\n  \n    fragment FullType on __Type {\n      kind\n      name\n      description\n      fields(includeDeprecated: true) {\n        name\n        description\n        args {\n          ...InputValue\n        }\n        type {\n          ...TypeRef\n        }\n        isDeprecated\n        deprecationReason\n      }\n      inputFields {\n        ...InputValue\n      }\n      interfaces {\n        ...TypeRef\n      }\n      enumValues(includeDeprecated: true) {\n        name\n        description\n        isDeprecated\n        deprecationReason\n      }\n      possibleTypes {\n        ...TypeRef\n      }\n    }\n  \n    fragment InputValue on __InputValue {\n      name\n      description\n      type { ...TypeRef }\n      defaultValue\n    }\n  \n    fragment TypeRef on __Type {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n          ofType {\n            kind\n            name\n            ofType {\n              kind\n              name\n              ofType {\n                kind\n                name\n                ofType {\n                  kind\n                  name\n                  ofType {\n                    kind\n                    name\n                  }\n                }\n              }\n            }\n          }\n        }\n      }\n    }\n");
        return graphqlJsonPayload.toString();
    }

    private HttpRequest.Builder addHeaders(HttpRequest.Builder builder, Map<String, String> headers) {
        for (Map.Entry<String, String> e : headers.entrySet()) {
            builder.header(e.getKey(), e.getValue());
        }
        return builder;
    }
}

