/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.ballerina;

import io.ballerina.graphql.generator.CodeGeneratorConstants;
import io.ballerina.graphql.generator.client.generator.model.AuthConfig;
import io.ballerina.graphql.generator.client.pojo.Extension;
import java.util.Map;

public class AuthConfigGenerator {
    private static AuthConfigGenerator authConfigGenerator = null;

    public static AuthConfigGenerator getInstance() {
        if (authConfigGenerator == null) {
            authConfigGenerator = new AuthConfigGenerator();
        }
        return authConfigGenerator;
    }

    public void populateAuthConfigTypes(Extension extensions, AuthConfig authConfig) {
        if (extensions != null && extensions.getEndpoints() != null && extensions.getEndpoints().getDefaultName() != null && extensions.getEndpoints().getDefaultName().getHeaders().size() != 0) {
            Map<String, String> headers = extensions.getEndpoints().getDefaultName().getHeaders();
            for (String headerName : headers.keySet()) {
                if (headerName.equals("Authorization")) {
                    if (headers.get(headerName).startsWith("Basic")) {
                        authConfig.addAuthConfigType(CodeGeneratorConstants.AuthConfigType.BASIC);
                        continue;
                    }
                    if (headers.get(headerName).startsWith("Bearer")) {
                        authConfig.addAuthConfigType(CodeGeneratorConstants.AuthConfigType.BEARER);
                        continue;
                    }
                    authConfig.addAuthConfigType(CodeGeneratorConstants.AuthConfigType.API_KEY);
                    continue;
                }
                authConfig.addAuthConfigType(CodeGeneratorConstants.AuthConfigType.API_KEY);
            }
        }
    }

    public void populateApiHeaders(Extension extensions, AuthConfig authConfig) {
        if (extensions != null && extensions.getEndpoints() != null && extensions.getEndpoints().getDefaultName() != null && extensions.getEndpoints().getDefaultName().getHeaders().size() != 0) {
            Map<String, String> headers = extensions.getEndpoints().getDefaultName().getHeaders();
            for (String headerName : headers.keySet()) {
                if (headerName.equals("Authorization")) {
                    if (headers.get(headerName).startsWith("Basic") || headers.get(headerName).startsWith("Bearer")) continue;
                    authConfig.addApiHeader(headerName);
                    continue;
                }
                authConfig.addApiHeader(headerName);
            }
        }
    }
}

