/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.ballerina;

import graphql.language.Document;
import graphql.schema.GraphQLSchema;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeReferenceTypeDescNode;
import io.ballerina.graphql.generator.client.Utils;
import io.ballerina.graphql.generator.client.exception.ClientGenerationException;
import io.ballerina.graphql.generator.client.generator.ballerina.FunctionBodyGenerator;
import io.ballerina.graphql.generator.client.generator.ballerina.FunctionSignatureGenerator;
import io.ballerina.graphql.generator.client.generator.graphql.QueryReader;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedOperationDefinition;
import io.ballerina.graphql.generator.client.generator.model.AuthConfig;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import io.ballerina.graphql.generator.utils.GeneratorContext;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class ClientGenerator {
    private static ClientGenerator clientGenerator = null;

    public static ClientGenerator getInstance() {
        if (clientGenerator == null) {
            clientGenerator = new ClientGenerator();
        }
        return clientGenerator;
    }

    public String generateSrc(List<String> queryDocuments, GraphQLSchema graphQLSchema, AuthConfig authConfig, GeneratorContext generatorContext) throws ClientGenerationException {
        try {
            return Formatter.format((SyntaxTree)this.generateSyntaxTree(queryDocuments, graphQLSchema, authConfig, generatorContext)).toString();
        }
        catch (IOException | FormatterException e) {
            throw new ClientGenerationException(e.getMessage());
        }
    }

    private SyntaxTree generateSyntaxTree(List<String> queryDocuments, GraphQLSchema graphQLSchema, AuthConfig authConfig, GeneratorContext generatorContext) throws IOException {
        NodeList<ImportDeclarationNode> imports = this.generateImports();
        NodeList<ModuleMemberDeclarationNode> members = this.generateMembers(queryDocuments, graphQLSchema, authConfig, generatorContext);
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, members, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private NodeList<ImportDeclarationNode> generateImports() {
        ArrayList<ImportDeclarationNode> imports = new ArrayList<ImportDeclarationNode>();
        ImportDeclarationNode importForGraphql = CodeGeneratorUtils.getImportDeclarationNode("ballerina", "graphql");
        imports.add(importForGraphql);
        return AbstractNodeFactory.createNodeList(imports);
    }

    private NodeList<ModuleMemberDeclarationNode> generateMembers(List<String> queryDocuments, GraphQLSchema graphQLSchema, AuthConfig authConfig, GeneratorContext generatorContext) throws IOException {
        ArrayList<ClassDefinitionNode> members = new ArrayList<ClassDefinitionNode>();
        ClassDefinitionNode classDefinitionNode = this.generateClientClass(queryDocuments, graphQLSchema, authConfig, generatorContext);
        members.add(classDefinitionNode);
        return AbstractNodeFactory.createNodeList(members);
    }

    private ClassDefinitionNode generateClientClass(List<String> queryDocuments, GraphQLSchema graphQLSchema, AuthConfig authConfig, GeneratorContext generatorContext) throws IOException {
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        NodeList classTypeQualifiers = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLIENT_KEYWORD)});
        IdentifierToken className = AbstractNodeFactory.createIdentifierToken((String)CodeGeneratorUtils.getClientClassName(generatorContext));
        ArrayList<Object> members = new ArrayList<Object>();
        members.addAll(this.generateClassInstanceVariables(authConfig));
        members.add(this.generateInitFunction(authConfig));
        members.addAll(this.generateRemoteFunctions(queryDocuments, graphQLSchema, authConfig));
        return NodeFactory.createClassDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (NodeList)classTypeQualifiers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLASS_KEYWORD), (Token)className, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList(members), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private List<ObjectFieldNode> generateClassInstanceVariables(AuthConfig authConfig) {
        ArrayList<ObjectFieldNode> objectFields = new ArrayList<ObjectFieldNode>();
        objectFields.add(this.generateGraphqlClientField());
        if (authConfig.isApiKeysConfig()) {
            objectFields.add(this.generateApiKeysConfigField());
        }
        return objectFields;
    }

    private FunctionDefinitionNode generateInitFunction(AuthConfig authConfig) {
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"init");
        FunctionSignatureNode functionSignatureNode = FunctionSignatureGenerator.getInstance().generateInitFunctionSignature(authConfig);
        FunctionBodyNode functionBodyNode = FunctionBodyGenerator.getInstance().generateInitFunctionBody(authConfig);
        return NodeFactory.createFunctionDefinitionNode(null, (MetadataNode)metadataNode, (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private List<FunctionDefinitionNode> generateRemoteFunctions(List<String> queryDocuments, GraphQLSchema graphQLSchema, AuthConfig authConfig) throws IOException {
        ArrayList<FunctionDefinitionNode> functionDefinitionNodeList = new ArrayList<FunctionDefinitionNode>();
        for (String document : queryDocuments) {
            Document queryDocument = Utils.getGraphQLQueryDocument(document);
            QueryReader queryReader = new QueryReader(queryDocument);
            for (ExtendedOperationDefinition queryDefinition : queryReader.getExtendedOperationDefinitions()) {
                FunctionDefinitionNode functionDefinitionNode = this.generateRemoteFunction(queryDefinition, graphQLSchema, authConfig);
                functionDefinitionNodeList.add(functionDefinitionNode);
            }
        }
        return functionDefinitionNodeList;
    }

    private FunctionDefinitionNode generateRemoteFunction(ExtendedOperationDefinition queryDefinition, GraphQLSchema graphQLSchema, AuthConfig authConfig) {
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.REMOTE_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)queryDefinition.getName());
        FunctionSignatureNode functionSignatureNode = FunctionSignatureGenerator.getInstance().generateRemoteFunctionSignature(queryDefinition, graphQLSchema);
        FunctionBodyNode functionBodyNode = FunctionBodyGenerator.getInstance().generateRemoteFunctionBody(queryDefinition, graphQLSchema, authConfig);
        return NodeFactory.createFunctionDefinitionNode(null, (MetadataNode)metadataNode, (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private ObjectFieldNode generateGraphqlClientField() {
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        Token finalKeywordToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FINAL_KEYWORD);
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{finalKeywordToken});
        QualifiedNameReferenceNode typeName = NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphql"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Client"));
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)"graphqlClient");
        return NodeFactory.createObjectFieldNode((MetadataNode)metadataNode, null, (NodeList)qualifierList, (Node)typeName, (Token)fieldName, null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private ObjectFieldNode generateApiKeysConfigField() {
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FINAL_KEYWORD)});
        TypeReferenceTypeDescNode readOnlyNode = NodeFactory.createTypeReferenceTypeDescNode((NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.READONLY_KEYWORD)));
        SimpleNameReferenceNode apiKeysConfigNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
        IntersectionTypeDescriptorNode typeName = NodeFactory.createIntersectionTypeDescriptorNode((Node)readOnlyNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BITWISE_AND_TOKEN), (Node)apiKeysConfigNode);
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)"apiKeysConfig");
        return NodeFactory.createObjectFieldNode((MetadataNode)metadataNode, null, (NodeList)qualifierList, (Node)typeName, (Token)fieldName, null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }
}

