/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.ballerina;

import graphql.schema.GraphQLSchema;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.graphql.generator.client.exception.ClientTypesGenerationException;
import io.ballerina.graphql.generator.client.generator.ballerina.TypesGenerator;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class ClientTypesGenerator
extends TypesGenerator {
    public static ClientTypesGenerator clientTypesGenerator = null;

    public static ClientTypesGenerator getInstance() {
        if (clientTypesGenerator == null) {
            clientTypesGenerator = new ClientTypesGenerator();
        }
        return clientTypesGenerator;
    }

    public String generateSrc(GraphQLSchema schema, List<String> documents) throws ClientTypesGenerationException {
        try {
            String generatedSyntaxTree = Formatter.format((SyntaxTree)this.generateSyntaxTree(schema, documents)).toString();
            return Formatter.format((String)generatedSyntaxTree);
        }
        catch (IOException | FormatterException e) {
            throw new ClientTypesGenerationException(e.getMessage());
        }
    }

    public SyntaxTree generateSyntaxTree(GraphQLSchema schema, List<String> documents) throws IOException {
        LinkedList<TypeDefinitionNode> typeDefinitionNodeList = new LinkedList<TypeDefinitionNode>();
        NodeList importsList = AbstractNodeFactory.createEmptyNodeList();
        this.addInputRecords(schema, typeDefinitionNodeList);
        this.addQueryResponseRecords(schema, documents, typeDefinitionNodeList);
        NodeList members = AbstractNodeFactory.createNodeList((Node[])((ModuleMemberDeclarationNode[])typeDefinitionNodeList.toArray(new TypeDefinitionNode[typeDefinitionNodeList.size()])));
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode((NodeList)importsList, (NodeList)members, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }
}

