/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.ballerina;

import graphql.schema.GraphQLSchema;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedOperationDefinition;
import io.ballerina.graphql.generator.client.generator.model.AuthConfig;
import io.ballerina.graphql.generator.client.generator.model.FieldType;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FunctionSignatureGenerator {
    private static FunctionSignatureGenerator functionSignatureGenerator = null;

    public static FunctionSignatureGenerator getInstance() {
        if (functionSignatureGenerator == null) {
            functionSignatureGenerator = new FunctionSignatureGenerator();
        }
        return functionSignatureGenerator;
    }

    public FunctionSignatureNode generateInitFunctionSignature(AuthConfig authConfig) {
        SeparatedNodeList parameterList = AbstractNodeFactory.createSeparatedNodeList(this.generateInitFunctionParams(authConfig));
        OptionalTypeDescriptorNode returnType = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createIdentifierToken((String)"graphql:ClientError"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)returnType);
        return NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameterList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }

    public FunctionSignatureNode generateRemoteFunctionSignature(ExtendedOperationDefinition queryDefinition, GraphQLSchema graphQLSchema) {
        SeparatedNodeList parameterList = AbstractNodeFactory.createSeparatedNodeList(this.generateRemoteFunctionParams(queryDefinition.getVariableDefinitionsMap(graphQLSchema)));
        BuiltinSimpleNameReferenceNode returnType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)CodeGeneratorUtils.getRemoteFunctionSignatureReturnTypeName(queryDefinition.getName())));
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)returnType);
        return NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)parameterList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }

    private List<Node> generateInitFunctionParams(AuthConfig authConfig) {
        ArrayList<Node> parameters = new ArrayList<Node>();
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode httpClientConfigTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"ConnectionConfig"));
        IdentifierToken httpClientConfigParamName = AbstractNodeFactory.createIdentifierToken((String)"config");
        IdentifierToken equalToken = AbstractNodeFactory.createIdentifierToken((String)"=");
        BasicLiteralNode emptyExpression = NodeFactory.createBasicLiteralNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"{}"));
        DefaultableParameterNode defaultConnectionConfig = NodeFactory.createDefaultableParameterNode((NodeList)annotationNodes, (Node)httpClientConfigTypeName, (Token)httpClientConfigParamName, (Token)equalToken, (Node)emptyExpression);
        Node serviceURLNode = this.generateServiceURLNode();
        if (authConfig.isApiKeysConfig() && authConfig.isClientConfig()) {
            parameters.add(this.generateClientConfigNode());
            parameters.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            parameters.add(this.generateApiKeysConfigNode());
            parameters.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            parameters.add(serviceURLNode);
        } else if (authConfig.isApiKeysConfig() && !authConfig.isClientConfig()) {
            parameters.add(this.generateApiKeysConfigNode());
            parameters.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            parameters.add(serviceURLNode);
            parameters.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            parameters.add((Node)defaultConnectionConfig);
        } else if (authConfig.isClientConfig() && !authConfig.isApiKeysConfig()) {
            parameters.add(this.generateClientConfigNode());
            parameters.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            parameters.add(serviceURLNode);
        } else {
            parameters.add(serviceURLNode);
            parameters.add((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            parameters.add((Node)defaultConnectionConfig);
        }
        return parameters;
    }

    private Node generateServiceURLNode() {
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode serviceURLTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"string"));
        IdentifierToken serviceURLParamName = AbstractNodeFactory.createIdentifierToken((String)"serviceUrl");
        RequiredParameterNode serviceURLNode = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)serviceURLTypeName, (Token)serviceURLParamName);
        return serviceURLNode;
    }

    private Node generateClientConfigNode() {
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode serviceURLTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"ConnectionConfig"));
        IdentifierToken serviceURLParamName = AbstractNodeFactory.createIdentifierToken((String)"config");
        RequiredParameterNode clientConfigNode = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)serviceURLTypeName, (Token)serviceURLParamName);
        return clientConfigNode;
    }

    private Node generateApiKeysConfigNode() {
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode serviceURLTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
        IdentifierToken serviceURLParamName = AbstractNodeFactory.createIdentifierToken((String)"apiKeysConfig");
        RequiredParameterNode apiKeyConfigNode = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)serviceURLTypeName, (Token)serviceURLParamName);
        return apiKeyConfigNode;
    }

    private List<Node> generateRemoteFunctionParams(Map<String, FieldType> variableDefinitionsMap) {
        ArrayList<Node> parameters = new ArrayList<Node>();
        ArrayList<Object> requiredParameters = new ArrayList<Object>();
        ArrayList<Object> optionalParameters = new ArrayList<Object>();
        for (String variableName : variableDefinitionsMap.keySet()) {
            if (variableDefinitionsMap.get(variableName).getFieldTypeAsString().endsWith("?")) {
                BuiltinSimpleNameReferenceNode optionalFieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)variableDefinitionsMap.get(variableName).getFieldTypeAsString()));
                IdentifierToken optionalFieldParamName = AbstractNodeFactory.createIdentifierToken((String)CodeGeneratorUtils.escapeIdentifier(variableName));
                IdentifierToken equalToken = AbstractNodeFactory.createIdentifierToken((String)"=");
                BasicLiteralNode nullableExpression = NodeFactory.createBasicLiteralNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"()"));
                DefaultableParameterNode optionalFieldNode = NodeFactory.createDefaultableParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)optionalFieldTypeName, (Token)optionalFieldParamName, (Token)equalToken, (Node)nullableExpression);
                optionalParameters.add(optionalFieldNode);
                optionalParameters.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                continue;
            }
            BuiltinSimpleNameReferenceNode requiredFieldTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)variableDefinitionsMap.get(variableName).getFieldTypeAsString()));
            IdentifierToken requiredFieldParamName = AbstractNodeFactory.createIdentifierToken((String)CodeGeneratorUtils.escapeIdentifier(variableName));
            RequiredParameterNode requiredFieldNode = NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)requiredFieldTypeName, (Token)requiredFieldParamName);
            requiredParameters.add(requiredFieldNode);
            requiredParameters.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        parameters.addAll(requiredParameters);
        parameters.addAll(optionalParameters);
        if (parameters.size() >= 1) {
            parameters.remove(parameters.size() - 1);
        }
        return parameters;
    }
}

