/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.graphql;

import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import io.ballerina.graphql.generator.client.generator.graphql.Utils;
import io.ballerina.graphql.generator.client.generator.model.FieldType;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpecReader {
    public static List<String> getInputObjectTypeNames(GraphQLSchema graphQLSchema) {
        ArrayList<String> inputObjectTypeNames = new ArrayList<String>();
        for (GraphQLNamedType graphQLNamedType : graphQLSchema.getAllTypesAsList()) {
            if (!(graphQLNamedType instanceof GraphQLInputObjectType)) continue;
            inputObjectTypeNames.add(graphQLNamedType.getName());
        }
        return inputObjectTypeNames;
    }

    public static Map<String, FieldType> getInputTypeFieldsMap(GraphQLSchema graphQLSchema, String inputObjectTypeName) {
        GraphQLInputObjectType inputObjectType;
        HashMap<String, FieldType> inputTypeFieldsMap = new HashMap<String, FieldType>();
        if (graphQLSchema.getType(inputObjectTypeName) instanceof GraphQLInputObjectType && (inputObjectType = (GraphQLInputObjectType)graphQLSchema.getType(inputObjectTypeName)) != null) {
            for (GraphQLInputObjectField field : inputObjectType.getFields()) {
                inputTypeFieldsMap.put(CodeGeneratorUtils.escapeIdentifier(field.getName()), Utils.getFieldType(graphQLSchema, field.getDefinition().getType()));
            }
        }
        return inputTypeFieldsMap;
    }

    public static List<String> getObjectTypeNames(GraphQLSchema graphQLSchema) {
        ArrayList<String> objectTypeNames = new ArrayList<String>();
        for (GraphQLNamedType graphQLNamedType : graphQLSchema.getAllTypesAsList()) {
            if (!(graphQLNamedType instanceof GraphQLObjectType) || graphQLNamedType.getName().startsWith("__")) continue;
            objectTypeNames.add(graphQLNamedType.getName());
        }
        return objectTypeNames;
    }

    public static Map<String, FieldType> getObjectTypeFieldsMap(GraphQLSchema graphQLSchema, String objectTypeName) {
        GraphQLObjectType objectType;
        HashMap<String, FieldType> objectTypeFieldsMap = new HashMap<String, FieldType>();
        if (graphQLSchema.getType(objectTypeName) instanceof GraphQLObjectType && (objectType = (GraphQLObjectType)graphQLSchema.getType(objectTypeName)) != null) {
            for (GraphQLFieldDefinition field : objectType.getFields()) {
                objectTypeFieldsMap.put(CodeGeneratorUtils.escapeIdentifier(field.getName()), Utils.getFieldType(graphQLSchema, field.getDefinition().getType()));
            }
        }
        return objectTypeFieldsMap;
    }

    public static List<String> getCustomScalarTypeNames(GraphQLSchema graphQLSchema) {
        ArrayList<String> scalarTypeNames = new ArrayList<String>();
        for (GraphQLNamedType graphQLNamedType : graphQLSchema.getAllTypesAsList()) {
            if (!(graphQLNamedType instanceof GraphQLScalarType) || graphQLNamedType.getName().startsWith("__") || Utils.isPrimitiveScalarType(graphQLNamedType.getName()).booleanValue()) continue;
            scalarTypeNames.add(graphQLNamedType.getName());
        }
        return scalarTypeNames;
    }

    public static List<String> getEnumTypeNames(GraphQLSchema graphQLSchema) {
        ArrayList<String> enumTypeNames = new ArrayList<String>();
        for (GraphQLNamedType graphQLNamedType : graphQLSchema.getAllTypesAsList()) {
            if (!(graphQLNamedType instanceof GraphQLEnumType) || graphQLNamedType.getName().startsWith("__")) continue;
            enumTypeNames.add(graphQLNamedType.getName());
        }
        return enumTypeNames;
    }
}

