/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.service.generator;

import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.DistinctTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.LiteralValueToken;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.graphql.generator.client.generator.ballerina.TypesGenerator;
import io.ballerina.graphql.generator.service.diagnostic.ServiceDiagnosticMessages;
import io.ballerina.graphql.generator.service.exception.ServiceGenerationException;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class ServiceTypesGenerator
extends TypesGenerator {
    private String fileName;
    private boolean useRecordsForObjects;
    private HashMap<GraphQLObjectType, Boolean> canRecordFromObject;
    private List<MethodDeclarationNode> serviceMethodDeclarations;
    private List<ModuleMemberDeclarationNode> moduleMembers = new LinkedList<ModuleMemberDeclarationNode>();
    private List<ModuleMemberDeclarationNode> inputObjectTypesModuleMembers = new ArrayList<ModuleMemberDeclarationNode>();
    private List<ModuleMemberDeclarationNode> interfaceTypesModuleMembers = new ArrayList<ModuleMemberDeclarationNode>();
    private List<ModuleMemberDeclarationNode> enumTypesModuleMembers = new ArrayList<ModuleMemberDeclarationNode>();
    private List<ModuleMemberDeclarationNode> unionTypesModuleMembers = new ArrayList<ModuleMemberDeclarationNode>();
    private List<ModuleMemberDeclarationNode> objectTypesModuleMembers = new ArrayList<ModuleMemberDeclarationNode>();

    public void setUseRecordsForObjects(boolean useRecordsForObjects) {
        this.useRecordsForObjects = useRecordsForObjects;
    }

    public String generateSrc(GraphQLSchema schema) throws ServiceGenerationException {
        try {
            String generatedSyntaxTree = Formatter.format((SyntaxTree)this.generateSyntaxTree(schema)).toString();
            return Formatter.format((String)generatedSyntaxTree);
        }
        catch (FormatterException e) {
            throw new ServiceGenerationException(ServiceDiagnosticMessages.GRAPHQL_SERVICE_GEN_102, null, e.getMessage());
        }
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public List<MethodDeclarationNode> getServiceMethodDeclarations() {
        return this.serviceMethodDeclarations;
    }

    private void setServiceMethodDeclarations(List<MethodDeclarationNode> serviceMethodDeclarations) {
        this.serviceMethodDeclarations = serviceMethodDeclarations;
    }

    public SyntaxTree generateSyntaxTree(GraphQLSchema schema) throws ServiceGenerationException {
        NodeList<ImportDeclarationNode> imports = CodeGeneratorUtils.generateImports();
        this.addServiceType(schema);
        this.addTypeDefinitions(schema);
        NodeList moduleMemberNodes = AbstractNodeFactory.createNodeList(this.moduleMembers);
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(imports, (NodeList)moduleMemberNodes, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private void addTypeDefinitions(GraphQLSchema schema) throws ServiceGenerationException {
        this.canRecordFromObject = new LinkedHashMap<GraphQLObjectType, Boolean>();
        for (Map.Entry typeEntry : schema.getTypeMap().entrySet()) {
            String key = (String)typeEntry.getKey();
            GraphQLNamedType type = (GraphQLNamedType)typeEntry.getValue();
            if (type instanceof GraphQLInputObjectType) {
                GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)type;
                this.inputObjectTypesModuleMembers.add(this.generateRecordType(inputObjectType));
                continue;
            }
            if (key.startsWith("__")) continue;
            if (type instanceof GraphQLInterfaceType) {
                GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)type;
                this.interfaceTypesModuleMembers.add(this.generateInterfaceType(interfaceType));
                continue;
            }
            if (type instanceof GraphQLEnumType) {
                GraphQLEnumType enumType = (GraphQLEnumType)type;
                this.enumTypesModuleMembers.add(this.generateEnumType(enumType));
                continue;
            }
            if (type instanceof GraphQLUnionType) {
                GraphQLUnionType unionType = (GraphQLUnionType)type;
                this.addUnionSubObjectTypesToMap(unionType);
                this.unionTypesModuleMembers.add(this.generateUnionType(unionType));
                continue;
            }
            if (!(type instanceof GraphQLObjectType)) continue;
            GraphQLObjectType objectType = (GraphQLObjectType)type;
            this.addObjectTypeToMap(objectType, key);
        }
        this.populateObjectTypesModuleMembers();
        this.moduleMembers.addAll(this.inputObjectTypesModuleMembers);
        this.moduleMembers.addAll(this.interfaceTypesModuleMembers);
        this.moduleMembers.addAll(this.enumTypesModuleMembers);
        this.moduleMembers.addAll(this.unionTypesModuleMembers);
        this.moduleMembers.addAll(this.objectTypesModuleMembers);
    }

    private void populateObjectTypesModuleMembers() throws ServiceGenerationException {
        for (Map.Entry<GraphQLObjectType, Boolean> canRecordFromObjectItem : this.canRecordFromObject.entrySet()) {
            GraphQLObjectType nextObjectType = canRecordFromObjectItem.getKey();
            Boolean isPossible = canRecordFromObjectItem.getValue();
            if (isPossible.booleanValue() && this.useRecordsForObjects) {
                this.objectTypesModuleMembers.add(this.generateRecordType(nextObjectType));
                continue;
            }
            this.objectTypesModuleMembers.add((ModuleMemberDeclarationNode)this.generateServiceClassType(nextObjectType));
        }
    }

    private void addObjectTypeToMap(GraphQLObjectType objectType, String key) {
        if (!("Query".equals(key) || "Mutation".equals(key) || "Subscription".equals(key))) {
            this.canRecordFromObject.putIfAbsent(objectType, true);
            if (this.hasFieldsWithInputs(objectType) || objectType.getInterfaces().size() > 0) {
                this.canRecordFromObject.replace(objectType, false);
            }
        }
    }

    private void addUnionSubObjectTypesToMap(GraphQLUnionType unionType) throws ServiceGenerationException {
        for (GraphQLNamedOutputType subType : unionType.getTypes()) {
            if (subType instanceof GraphQLObjectType) {
                GraphQLObjectType subObjectType = (GraphQLObjectType)subType;
                this.canRecordFromObject.put(subObjectType, false);
                continue;
            }
            throw new ServiceGenerationException(ServiceDiagnosticMessages.GRAPHQL_SERVICE_GEN_102, null, String.format("Union type can only have object types as members. But found: \"%s\" with different type.", subType.getName()));
        }
    }

    private ModuleMemberDeclarationNode generateInterfaceType(GraphQLInterfaceType interfaceType) throws ServiceGenerationException {
        ObjectTypeDescriptorNode interfaceObjectType = NodeFactory.createObjectTypeDescriptorNode((NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SERVICE_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OBJECT_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), this.generateInterfaceTypeDescriptorMembers(interfaceType.getInterfaces(), interfaceType.getFields()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        DistinctTypeDescriptorNode distinctInterfaceObjectType = NodeFactory.createDistinctTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DISTINCT_KEYWORD), (TypeDescriptorNode)interfaceObjectType);
        return NodeFactory.createTypeDefinitionNode((MetadataNode)this.generateMetadataForDescription(interfaceType.getDescription(), false), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)interfaceType.getName()), (Node)distinctInterfaceObjectType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private NodeList<Node> generateInterfaceTypeDescriptorMembers(List<GraphQLNamedOutputType> interfaces, List<GraphQLFieldDefinition> fields) throws ServiceGenerationException {
        LinkedList<Object> members = new LinkedList<Object>();
        List<GraphQLNamedOutputType> filteredInterfaces = this.getInterfacesToBeWritten(interfaces);
        List<GraphQLFieldDefinition> filteredFields = this.getFieldsToBeWritten(fields, filteredInterfaces);
        for (GraphQLNamedOutputType filteredInterface : filteredInterfaces) {
            TypeReferenceNode filteredInterfaceReference = NodeFactory.createTypeReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)filteredInterface.getName())), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            members.add(filteredInterfaceReference);
        }
        for (GraphQLFieldDefinition field : filteredFields) {
            NodeList resourceQualifier = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RESOURCE_KEYWORD)});
            NodeList fieldName = AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)field.getDefinition().getName())});
            FunctionSignatureNode methodSignatureNode = NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), this.generateMethodSignatureParams(field.getArguments()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)this.generateMethodSignatureReturnType(field.getType()));
            MethodDeclarationNode methodDeclaration = NodeFactory.createMethodDeclarationNode((SyntaxKind)SyntaxKind.METHOD_DECLARATION, (MetadataNode)this.generateMetadata(field.getDescription(), field.getArguments(), field.isDeprecated(), field.getDeprecationReason(), false), (NodeList)resourceQualifier, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"get"), (NodeList)fieldName, (FunctionSignatureNode)methodSignatureNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            members.add(methodDeclaration);
        }
        return AbstractNodeFactory.createNodeList(members);
    }

    private List<GraphQLFieldDefinition> getFieldsToBeWritten(List<GraphQLFieldDefinition> allFields, List<GraphQLNamedOutputType> filteredInterfaces) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (GraphQLFieldDefinition field : allFields) {
            fieldNames.add(field.getName());
        }
        for (GraphQLNamedOutputType interfaceType : filteredInterfaces) {
            if (!(interfaceType instanceof GraphQLInterfaceType)) continue;
            GraphQLInterfaceType graphQLInterfaceType = (GraphQLInterfaceType)interfaceType;
            for (GraphQLFieldDefinition field : graphQLInterfaceType.getFields()) {
                if (!fieldNames.contains(field.getName())) continue;
                fieldNames.remove(field.getName());
            }
        }
        ArrayList<GraphQLFieldDefinition> filteredFields = new ArrayList<GraphQLFieldDefinition>();
        for (GraphQLFieldDefinition field : allFields) {
            if (!fieldNames.contains(field.getName())) continue;
            filteredFields.add(field);
        }
        return filteredFields;
    }

    private List<GraphQLNamedOutputType> getInterfacesToBeWritten(List<GraphQLNamedOutputType> interfaceTypes) {
        HashSet<String> interfaceTypeNames = new HashSet<String>();
        for (GraphQLNamedOutputType interfaceType : interfaceTypes) {
            interfaceTypeNames.add(interfaceType.getName());
        }
        for (GraphQLNamedOutputType interfaceType : interfaceTypes) {
            if (!(interfaceType instanceof GraphQLInterfaceType)) continue;
            GraphQLInterfaceType graphQLInterfaceType = (GraphQLInterfaceType)interfaceType;
            for (GraphQLNamedOutputType subInterface : graphQLInterfaceType.getInterfaces()) {
                if (!interfaceTypeNames.contains(subInterface.getName())) continue;
                interfaceTypeNames.remove(subInterface.getName());
            }
        }
        ArrayList<GraphQLNamedOutputType> filteredInterfaces = new ArrayList<GraphQLNamedOutputType>();
        for (GraphQLNamedOutputType interfaceType : interfaceTypes) {
            if (!interfaceTypeNames.contains(interfaceType.getName())) continue;
            filteredInterfaces.add(interfaceType);
        }
        return filteredInterfaces;
    }

    private ModuleMemberDeclarationNode generateUnionType(GraphQLUnionType unionType) {
        TypeDescriptorNode unionTypeDescriptorNode = this.generateUnionTypeDescriptorNode(unionType.getTypes());
        return NodeFactory.createTypeDefinitionNode((MetadataNode)this.generateMetadataForDescription(unionType.getDescription()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)unionType.getName()), (Node)unionTypeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private TypeDescriptorNode generateUnionTypeDescriptorNode(List<GraphQLNamedOutputType> types) {
        if (types.size() == 1) {
            String typeName = types.get(0).getName();
            return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)typeName));
        }
        List<GraphQLNamedOutputType> typesSubList = types.subList(0, types.size() - 1);
        String lastTypeName = types.get(types.size() - 1).getName();
        return NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)this.generateUnionTypeDescriptorNode(typesSubList), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)lastTypeName)));
    }

    private ModuleMemberDeclarationNode generateEnumType(GraphQLEnumType enumType) {
        ArrayList<Object> enumMembers = new ArrayList<Object>();
        List enumValues = enumType.getValues();
        for (int valueIdx = 0; valueIdx < enumValues.size(); ++valueIdx) {
            GraphQLEnumValueDefinition enumValue = (GraphQLEnumValueDefinition)enumValues.get(valueIdx);
            EnumMemberNode enumMember = NodeFactory.createEnumMemberNode((MetadataNode)this.generateMetadata(enumValue.getDescription(), null, enumValue.isDeprecated(), enumValue.getDeprecationReason(), false), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)enumValue.getName()), null, null);
            enumMembers.add(enumMember);
            if (valueIdx == enumValues.size() - 1) continue;
            enumMembers.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createEndOfLineMinutiae((String)"\n")})));
        }
        SeparatedNodeList enumMemberNodes = AbstractNodeFactory.createSeparatedNodeList(enumMembers);
        return NodeFactory.createEnumDeclarationNode((MetadataNode)this.generateMetadataForDescription(enumType.getDescription()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ENUM_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)enumType.getName()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)enumMemberNodes, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private ModuleMemberDeclarationNode generateRecordType(GraphQLInputObjectType type) throws ServiceGenerationException {
        List typeFields = type.getFields();
        NodeList<Node> recordTypeFields = this.generateRecordTypeFieldsForGraphQLInputObjectFields(typeFields);
        RecordTypeDescriptorNode recordType = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), recordTypeFields, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)this.generateMetadataForDescription(type.getDescription()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)type.getName()), (Node)recordType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private ModuleMemberDeclarationNode generateRecordType(GraphQLObjectType type) throws ServiceGenerationException {
        List typeFields = type.getFields();
        NodeList<Node> recordTypeFields = this.generateRecordTypeFieldsForGraphQLFieldDefinitions(typeFields);
        RecordTypeDescriptorNode recordType = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), recordTypeFields, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)this.generateMetadataForDescription(type.getDescription()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)type.getName()), (Node)recordType, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private NodeList<Node> generateRecordTypeFieldsForGraphQLInputObjectFields(List<GraphQLInputObjectField> inputTypeFields) throws ServiceGenerationException {
        ArrayList<Object> fields = new ArrayList<Object>();
        for (GraphQLInputObjectField field : inputTypeFields) {
            MetadataNode metadataNode = this.getMetadataNode(this.getUnwrappedType((GraphQLType)field.getType()), field.getDescription(), field.isDeprecated(), field.getDeprecationReason());
            if (field.hasSetDefaultValue()) {
                Object value = field.getInputFieldDefaultValue().getValue();
                ExpressionNode generatedDefaultValue = this.generateArgDefaultValue(value);
                fields.add(NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)this.generateTypeDescriptor((GraphQLType)field.getType()), (Token)AbstractNodeFactory.createIdentifierToken((String)field.getName()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)generatedDefaultValue, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
                continue;
            }
            fields.add(NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)this.generateTypeDescriptor((GraphQLType)field.getType()), (Token)AbstractNodeFactory.createIdentifierToken((String)field.getName()), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
        }
        return AbstractNodeFactory.createNodeList(fields);
    }

    private NodeList<Node> generateRecordTypeFieldsForGraphQLFieldDefinitions(List<GraphQLFieldDefinition> typeInputFields) throws ServiceGenerationException {
        ArrayList<RecordFieldNode> fields = new ArrayList<RecordFieldNode>();
        for (GraphQLFieldDefinition field : typeInputFields) {
            fields.add(NodeFactory.createRecordFieldNode((MetadataNode)this.getMetadataNode(this.getUnwrappedType((GraphQLType)field.getType()), field.getDescription(), field.isDeprecated(), field.getDeprecationReason()), null, (Node)this.generateTypeDescriptor((GraphQLType)field.getType()), (Token)AbstractNodeFactory.createIdentifierToken((String)field.getName()), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
        }
        return AbstractNodeFactory.createNodeList(fields);
    }

    private boolean hasFieldsWithInputs(GraphQLObjectType type) {
        List fields = type.getFields();
        for (GraphQLFieldDefinition field : fields) {
            if (field.getArguments().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private ClassDefinitionNode generateServiceClassType(GraphQLObjectType type) throws ServiceGenerationException {
        NodeList qualifierDistinctService = AbstractNodeFactory.createNodeList(new ArrayList<Token>(List.of(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DISTINCT_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SERVICE_KEYWORD))));
        ArrayList<Object> serviceClassTypeMembersList = new ArrayList<Object>();
        for (GraphQLNamedOutputType typeInterface : this.getInterfacesToBeWritten(type.getInterfaces())) {
            serviceClassTypeMembersList.add(NodeFactory.createTypeReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)typeInterface.getName())), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
        }
        for (Node fieldMember : this.generateServiceClassTypeMembers(type.getFields())) {
            serviceClassTypeMembersList.add(fieldMember);
        }
        NodeList serviceClassTypeMembers = AbstractNodeFactory.createNodeList(serviceClassTypeMembersList);
        return NodeFactory.createClassDefinitionNode((MetadataNode)this.generateMetadataForDescription(type.getDescription(), false), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (NodeList)qualifierDistinctService, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLASS_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)type.getName()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)serviceClassTypeMembers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private MetadataNode generateMetadataForDescription(String description) {
        return this.generateMetadataForDescription(description, false);
    }

    private MetadataNode generateMetadataForDescription(String description, boolean addAdditionalNewLine) {
        if (description != null) {
            List<Node> documentationLines = this.generateMarkdownDocumentationLines(description, addAdditionalNewLine);
            return NodeFactory.createMetadataNode((Node)NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(documentationLines)), (NodeList)AbstractNodeFactory.createEmptyNodeList());
        }
        return null;
    }

    private NodeList<Node> generateServiceClassTypeMembers(List<GraphQLFieldDefinition> fields) throws ServiceGenerationException {
        ArrayList<FunctionDefinitionNode> members = new ArrayList<FunctionDefinitionNode>();
        for (int fieldIdx = 0; fieldIdx < fields.size(); ++fieldIdx) {
            GraphQLFieldDefinition field = fields.get(fieldIdx);
            boolean addAdditionalNewLine = true;
            if (fieldIdx == 0) {
                addAdditionalNewLine = false;
            }
            FunctionDefinitionNode functionDefinition = this.generateServiceClassTypeMember(field, addAdditionalNewLine);
            members.add(functionDefinition);
        }
        return AbstractNodeFactory.createNodeList(members);
    }

    private FunctionDefinitionNode generateServiceClassTypeMember(GraphQLFieldDefinition fieldDefinition, boolean addAdditionalNewLine) throws ServiceGenerationException {
        MinutiaeList resourceLeadingMinutiaeList = AbstractNodeFactory.createEmptyMinutiaeList();
        if (addAdditionalNewLine) {
            resourceLeadingMinutiaeList = resourceLeadingMinutiaeList.add(AbstractNodeFactory.createCommentMinutiae((String)"\n"));
        }
        NodeList qualifierResource = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RESOURCE_KEYWORD, (MinutiaeList)resourceLeadingMinutiaeList, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList())});
        NodeList fieldName = AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)fieldDefinition.getName())});
        FunctionSignatureNode functionSignature = NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), this.generateMethodSignatureParams(fieldDefinition.getArguments()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)this.generateMethodSignatureReturnType(fieldDefinition.getType()));
        MinutiaeList functionBodyTraillingMinutiaeList = AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createEndOfLineMinutiae((String)"\n")});
        FunctionBodyBlockNode functionBody = NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)functionBodyTraillingMinutiaeList), null);
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION, (MetadataNode)this.generateMetadata(fieldDefinition.getDescription(), fieldDefinition.getArguments(), fieldDefinition.isDeprecated(), fieldDefinition.getDeprecationReason(), addAdditionalNewLine), (NodeList)qualifierResource, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"get"), (NodeList)fieldName, (FunctionSignatureNode)functionSignature, (FunctionBodyNode)functionBody);
    }

    private void addServiceType(GraphQLSchema schema) throws ServiceGenerationException {
        ObjectTypeDescriptorNode serviceObject = NodeFactory.createObjectTypeDescriptorNode((NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SERVICE_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OBJECT_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), this.generateServiceObjectMembers(schema), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        TypeDefinitionNode serviceObjectDefinition = NodeFactory.createTypeDefinitionNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)this.fileName), (Node)serviceObject, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        this.moduleMembers.add((ModuleMemberDeclarationNode)serviceObjectDefinition);
    }

    private NodeList<Node> generateServiceObjectMembers(GraphQLSchema schema) throws ServiceGenerationException {
        ArrayList<Object> members = new ArrayList<Object>();
        QualifiedNameReferenceNode graphqlServiceName = NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphql"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Service"));
        TypeReferenceNode graphqlService = NodeFactory.createTypeReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)graphqlServiceName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        members.add(graphqlService);
        List<MethodDeclarationNode> serviceMethodDeclarations = this.generateServiceMethodDeclarations(schema.getQueryType(), schema.getMutationType(), schema.getSubscriptionType());
        this.setServiceMethodDeclarations(serviceMethodDeclarations);
        members.addAll(serviceMethodDeclarations);
        return AbstractNodeFactory.createNodeList(members);
    }

    private List<MethodDeclarationNode> generateServiceMethodDeclarations(GraphQLObjectType queryType, GraphQLObjectType mutationType, GraphQLObjectType subscriptionType) throws ServiceGenerationException {
        ArrayList<MethodDeclarationNode> methodDeclarations = new ArrayList<MethodDeclarationNode>();
        this.handleQueryTypeMethodDeclarations(queryType, methodDeclarations);
        this.handleMutationTypeMethodDeclarations(mutationType, methodDeclarations);
        this.handleSubscriptionTypeMethodDeclarations(subscriptionType, methodDeclarations);
        return methodDeclarations;
    }

    private void handleSubscriptionTypeMethodDeclarations(GraphQLObjectType subscriptionType, List<MethodDeclarationNode> methodDeclarations) throws ServiceGenerationException {
        if (subscriptionType != null) {
            for (GraphQLFieldDefinition fieldDefinition : subscriptionType.getFieldDefinitions()) {
                FunctionSignatureNode methodSignatureNode = NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), this.generateMethodSignatureParams(fieldDefinition.getArguments()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)this.generateMethodSignatureReturnType(fieldDefinition.getType(), true));
                MetadataNode metadata = this.generateMetadata(fieldDefinition.getDescription(), fieldDefinition.getArguments(), fieldDefinition.isDeprecated(), fieldDefinition.getDeprecationReason(), false);
                MethodDeclarationNode methodDeclaration = NodeFactory.createMethodDeclarationNode((SyntaxKind)SyntaxKind.RESOURCE_ACCESSOR_DECLARATION, (MetadataNode)metadata, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RESOURCE_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"subscribe"), (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)fieldDefinition.getDefinition().getName())}), (FunctionSignatureNode)methodSignatureNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                methodDeclarations.add(methodDeclaration);
            }
        }
    }

    private void handleMutationTypeMethodDeclarations(GraphQLObjectType mutationType, List<MethodDeclarationNode> methodDeclarations) throws ServiceGenerationException {
        if (mutationType != null) {
            for (GraphQLFieldDefinition fieldDefinition : mutationType.getFieldDefinitions()) {
                FunctionSignatureNode methodSignatureNode = NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), this.generateMethodSignatureParams(fieldDefinition.getArguments()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)this.generateMethodSignatureReturnType(fieldDefinition.getType(), false));
                MetadataNode metadata = this.generateMetadata(fieldDefinition.getDescription(), fieldDefinition.getArguments(), fieldDefinition.isDeprecated(), fieldDefinition.getDeprecationReason(), false);
                MethodDeclarationNode methodDeclaration = NodeFactory.createMethodDeclarationNode((SyntaxKind)SyntaxKind.METHOD_DECLARATION, (MetadataNode)metadata, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.REMOTE_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)""), (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)fieldDefinition.getName())}), (FunctionSignatureNode)methodSignatureNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                methodDeclarations.add(methodDeclaration);
            }
        }
    }

    private void handleQueryTypeMethodDeclarations(GraphQLObjectType queryType, List<MethodDeclarationNode> methodDeclarations) throws ServiceGenerationException {
        for (GraphQLFieldDefinition field : queryType.getFieldDefinitions()) {
            FunctionSignatureNode methodSignature = NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), this.generateMethodSignatureParams(field.getArguments()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)this.generateMethodSignatureReturnType(field.getType(), false));
            MetadataNode metadata = this.generateMetadata(field.getDescription(), field.getArguments(), field.isDeprecated(), field.getDeprecationReason(), false);
            MethodDeclarationNode methodDeclaration = NodeFactory.createMethodDeclarationNode((SyntaxKind)SyntaxKind.RESOURCE_ACCESSOR_DECLARATION, (MetadataNode)metadata, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RESOURCE_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"get"), (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)field.getName())}), (FunctionSignatureNode)methodSignature, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            methodDeclarations.add(methodDeclaration);
        }
    }

    private MetadataNode generateMetadata(String description, List<GraphQLArgument> arguments, boolean isDeprecated, String deprecationReason, boolean addNewLineInFront) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        ArrayList<Object> markdownDocumentationLines = new ArrayList();
        if (description != null) {
            markdownDocumentationLines = new ArrayList<Node>(this.generateMarkdownDocumentationLines(description, addNewLineInFront));
            addNewLineInFront = false;
        }
        if (arguments != null) {
            for (GraphQLArgument argument : arguments) {
                markdownDocumentationLines.addAll(this.generateMarkdownParameterDocumentationLines(argument, addNewLineInFront));
                addNewLineInFront = false;
            }
        }
        if (isDeprecated) {
            AnnotationNode annotation = NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"deprecated")), null);
            annotations.add(annotation);
            markdownDocumentationLines.addAll(this.generateMarkdownDocumentationLinesForDeprecated(deprecationReason, addNewLineInFront));
            addNewLineInFront = false;
        }
        if (markdownDocumentationLines.isEmpty() && annotations.isEmpty()) {
            return null;
        }
        return NodeFactory.createMetadataNode((Node)NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(markdownDocumentationLines)), (NodeList)AbstractNodeFactory.createNodeList(annotations));
    }

    private List<Node> generateMarkdownDocumentationLinesForDeprecated(String deprecationReason, boolean addNewLineInFront) {
        ArrayList<Node> markdownDocumentationLines = new ArrayList<Node>();
        MinutiaeList leadingMinutiaeList = AbstractNodeFactory.createEmptyMinutiaeList();
        if (addNewLineInFront) {
            leadingMinutiaeList = leadingMinutiaeList.add(AbstractNodeFactory.createCommentMinutiae((String)"\n"));
            addNewLineInFront = false;
        }
        markdownDocumentationLines.add((Node)NodeFactory.createMarkdownDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_DEPRECATION_DOCUMENTATION_LINE, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)leadingMinutiaeList, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()), (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DEPRECATION_LITERAL, (String)"# Deprecated", (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createEndOfLineMinutiae((String)"\n")}))})));
        markdownDocumentationLines.addAll(this.generateMarkdownDocumentationLines(deprecationReason, false));
        return markdownDocumentationLines;
    }

    private List<Node> generateMarkdownParameterDocumentationLines(GraphQLArgument argument, boolean addNewLineInFront) {
        ArrayList<Node> markdownDocumentationLines = new ArrayList<Node>();
        if (argument.getDescription() != null) {
            String[] lines = argument.getDescription().split("\n");
            for (int lineIdx = 0; lineIdx < lines.length; ++lineIdx) {
                String line = lines[lineIdx];
                if (lineIdx == 0) {
                    markdownDocumentationLines.add((Node)this.generateMarkdownParameterDocumentationLine(line, argument.getName(), addNewLineInFront));
                    addNewLineInFront = false;
                    continue;
                }
                markdownDocumentationLines.add((Node)this.generateMarkdownDocumentationLine(line, addNewLineInFront));
            }
        }
        return markdownDocumentationLines;
    }

    private MarkdownParameterDocumentationLineNode generateMarkdownParameterDocumentationLine(String descriptionLine, String argumentName, boolean addNewLineInFront) {
        MinutiaeList leadingMinutiaeList = AbstractNodeFactory.createEmptyMinutiaeList();
        if (addNewLineInFront) {
            leadingMinutiaeList = leadingMinutiaeList.add(AbstractNodeFactory.createCommentMinutiae((String)"\n"));
        }
        LiteralValueToken parameterName = AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.PARAMETER_NAME, (String)argumentName, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createWhitespaceMinutiae((String)" ")}));
        NodeList parameterDescription = AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DOCUMENTATION_DESCRIPTION, (String)descriptionLine, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createEndOfLineMinutiae((String)"\n")}))});
        return NodeFactory.createMarkdownParameterDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_PARAMETER_DOCUMENTATION_LINE, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)leadingMinutiaeList, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PLUS_TOKEN), (Token)parameterName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.MINUS_TOKEN), (NodeList)parameterDescription);
    }

    private List<Node> generateMarkdownDocumentationLines(String description, boolean addNewLineInFront) {
        ArrayList<Node> markdownDocumentationLines = new ArrayList<Node>();
        if (description != null) {
            String[] lines;
            for (String line : lines = description.split("\n")) {
                MarkdownDocumentationLineNode markdownDocumentationLine = this.generateMarkdownDocumentationLine(line, addNewLineInFront);
                markdownDocumentationLines.add((Node)markdownDocumentationLine);
                addNewLineInFront = false;
            }
        }
        return markdownDocumentationLines;
    }

    private MarkdownDocumentationLineNode generateMarkdownDocumentationLine(String descriptionLine, boolean addNewLineInFront) {
        MinutiaeList leadingMinutiaeList = AbstractNodeFactory.createEmptyMinutiaeList();
        if (addNewLineInFront) {
            leadingMinutiaeList = leadingMinutiaeList.add(AbstractNodeFactory.createCommentMinutiae((String)"\n"));
        }
        return NodeFactory.createMarkdownDocumentationLineNode((SyntaxKind)SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)leadingMinutiaeList, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()), (NodeList)AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DOCUMENTATION_DESCRIPTION, (String)descriptionLine, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createEndOfLineMinutiae((String)"\n")}))}));
    }

    private ReturnTypeDescriptorNode generateMethodSignatureReturnType(GraphQLOutputType type, boolean isStream) throws ServiceGenerationException {
        TypeDescriptorNode typeDescriptor = this.generateTypeDescriptor((GraphQLType)type);
        if (isStream) {
            StreamTypeDescriptorNode streamTypeDescriptor = NodeFactory.createStreamTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STREAM_KEYWORD), (Node)NodeFactory.createStreamTypeParamsNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.LT_TOKEN), (Node)typeDescriptor, null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.GT_TOKEN)));
            return NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), this.getAnnotationNodeList((GraphQLType)type), (Node)streamTypeDescriptor);
        }
        return NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), this.getAnnotationNodeList((GraphQLType)type), (Node)typeDescriptor);
    }

    private ReturnTypeDescriptorNode generateMethodSignatureReturnType(GraphQLOutputType type) throws ServiceGenerationException {
        return this.generateMethodSignatureReturnType(type, false);
    }

    private SeparatedNodeList<ParameterNode> generateMethodSignatureParams(List<GraphQLArgument> arguments) throws ServiceGenerationException {
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<DefaultableParameterNode> defaultParams = new ArrayList<DefaultableParameterNode>();
        ArrayList<RequiredParameterNode> requiredParams = new ArrayList<RequiredParameterNode>();
        for (GraphQLArgument argument : arguments) {
            TypeDescriptorNode argumentType = this.generateTypeDescriptor((GraphQLType)argument.getType());
            if (argument.hasSetDefaultValue()) {
                Object value = argument.getArgumentDefaultValue().getValue();
                ExpressionNode generatedDefaultValue = this.generateArgDefaultValue(value);
                DefaultableParameterNode defaultableParameterNode = NodeFactory.createDefaultableParameterNode(this.getAnnotationNodeList((GraphQLType)argument.getType()), (Node)argumentType, (Token)AbstractNodeFactory.createIdentifierToken((String)argument.getName()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)generatedDefaultValue);
                defaultParams.add(defaultableParameterNode);
                continue;
            }
            RequiredParameterNode requiredParameterNode = NodeFactory.createRequiredParameterNode(this.getAnnotationNodeList((GraphQLType)argument.getType()), (Node)argumentType, (Token)AbstractNodeFactory.createIdentifierToken((String)argument.getName()));
            requiredParams.add(requiredParameterNode);
        }
        for (int requiredParamIdx = 0; requiredParamIdx < requiredParams.size(); ++requiredParamIdx) {
            RequiredParameterNode requireParam = (RequiredParameterNode)requiredParams.get(requiredParamIdx);
            params.add(requireParam);
            if (requiredParamIdx == requiredParams.size() - 1) continue;
            params.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        for (int defaultParamIdx = 0; defaultParamIdx < defaultParams.size(); ++defaultParamIdx) {
            DefaultableParameterNode defaultParam = (DefaultableParameterNode)defaultParams.get(defaultParamIdx);
            if (defaultParamIdx != 0 || requiredParams.size() != 0) {
                params.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
            params.add(defaultParam);
        }
        return AbstractNodeFactory.createSeparatedNodeList(params);
    }

    private ExpressionNode generateArgDefaultValue(Object value) throws ServiceGenerationException {
        if (value instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)value;
            return NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.NUMERIC_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN, (String)floatValue.getValue().toString(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        }
        if (value instanceof IntValue) {
            IntValue intValue = (IntValue)value;
            return NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.NUMERIC_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, (String)intValue.getValue().toString(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)String.format("\"%s\"", stringValue.getValue()), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        }
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            return NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.BOOLEAN_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)(booleanValue.isValue() ? SyntaxKind.TRUE_KEYWORD : SyntaxKind.FALSE_KEYWORD), (String)(booleanValue.isValue() ? "true" : "false"), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        }
        if (value instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)value;
            return NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)enumValue.getName()));
        }
        if (value instanceof ObjectValue) {
            ObjectValue objectValue = (ObjectValue)value;
            List objectFields = objectValue.getObjectFields();
            ArrayList<Object> mappedNodeFields = new ArrayList<Object>();
            for (int objectFiledIdx = 0; objectFiledIdx < objectFields.size(); ++objectFiledIdx) {
                ObjectField objectField = (ObjectField)objectFields.get(objectFiledIdx);
                SpecificFieldNode specificField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)objectField.getName()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)this.generateArgDefaultValue(objectField.getValue()));
                mappedNodeFields.add(specificField);
                if (objectFiledIdx == objectFields.size() - 1) continue;
                mappedNodeFields.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
            return NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(mappedNodeFields), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        }
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            List arrayElements = arrayValue.getValues();
            ArrayList<Object> arrayElementExpressions = new ArrayList<Object>();
            for (int elementIdx = 0; elementIdx < arrayElements.size(); ++elementIdx) {
                Value arrayElementValue = (Value)arrayElements.get(elementIdx);
                arrayElementExpressions.add(this.generateArgDefaultValue(arrayElementValue));
                if (elementIdx == arrayElements.size() - 1) continue;
                arrayElementExpressions.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
            return NodeFactory.createListConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(arrayElementExpressions), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        }
        throw new ServiceGenerationException(ServiceDiagnosticMessages.GRAPHQL_SERVICE_GEN_102, null, String.format("Type \"%s\" is an unsupported default argument value type.", value.getClass().getName()));
    }

    private TypeDescriptorNode generateTypeDescriptor(GraphQLType type, boolean nonNull) throws ServiceGenerationException {
        if (type instanceof GraphQLScalarType) {
            GraphQLScalarType scalarType = (GraphQLScalarType)type;
            Object scalarName = "Upload".equals(scalarType.getName()) ? NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphql"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Upload")) : NodeFactory.createBuiltinSimpleNameReferenceNode((SyntaxKind)this.getTypeDescFor(scalarType.getName()), (Token)AbstractNodeFactory.createToken((SyntaxKind)this.getTypeKeywordFor(scalarType.getName())));
            if (nonNull) {
                return scalarName;
            }
            return NodeFactory.createOptionalTypeDescriptorNode((Node)scalarName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        if (type instanceof GraphQLObjectType) {
            GraphQLObjectType objectType = (GraphQLObjectType)type;
            SimpleNameReferenceNode objectName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)objectType.getName()));
            if (nonNull) {
                return objectName;
            }
            return NodeFactory.createOptionalTypeDescriptorNode((Node)objectName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        if (type instanceof GraphQLInputObjectType) {
            GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)type;
            SimpleNameReferenceNode inputObjectName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)inputObjectType.getName()));
            if (nonNull) {
                return inputObjectName;
            }
            return NodeFactory.createOptionalTypeDescriptorNode((Node)inputObjectName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        if (type instanceof GraphQLEnumType) {
            GraphQLEnumType enumType = (GraphQLEnumType)type;
            SimpleNameReferenceNode enumName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)enumType.getName()));
            if (nonNull) {
                return enumName;
            }
            return NodeFactory.createOptionalTypeDescriptorNode((Node)enumName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        if (type instanceof GraphQLInterfaceType) {
            GraphQLInterfaceType interfaceType = (GraphQLInterfaceType)type;
            SimpleNameReferenceNode interfaceName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)interfaceType.getName()));
            if (nonNull) {
                return interfaceName;
            }
            return NodeFactory.createOptionalTypeDescriptorNode((Node)interfaceName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        if (type instanceof GraphQLUnionType) {
            GraphQLUnionType unionType = (GraphQLUnionType)type;
            SimpleNameReferenceNode unionName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)unionType.getName()));
            if (nonNull) {
                return unionName;
            }
            return NodeFactory.createOptionalTypeDescriptorNode((Node)unionName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        if (type instanceof GraphQLNonNull) {
            GraphQLNonNull nonNullType = (GraphQLNonNull)type;
            return this.generateTypeDescriptor(nonNullType.getWrappedType(), true);
        }
        if (type instanceof GraphQLList) {
            GraphQLList listType = (GraphQLList)type;
            ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
            TypeDescriptorNode wrappedType = this.generateTypeDescriptor(listType.getWrappedType());
            ArrayTypeDescriptorNode arrayTypeNode = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)wrappedType, (NodeList)AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimension}));
            if (nonNull) {
                return arrayTypeNode;
            }
            return NodeFactory.createOptionalTypeDescriptorNode((Node)arrayTypeNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        throw new ServiceGenerationException(ServiceDiagnosticMessages.GRAPHQL_SERVICE_GEN_102, null, String.format("Type \"%s\" is not supported.", type.getClass().getName()));
    }

    private TypeDescriptorNode generateTypeDescriptor(GraphQLType argumentType) throws ServiceGenerationException {
        return this.generateTypeDescriptor(argumentType, false);
    }

    private SyntaxKind getTypeKeywordFor(String typeName) throws ServiceGenerationException {
        if ("String".equals(typeName)) {
            return SyntaxKind.STRING_KEYWORD;
        }
        if ("Int".equals(typeName)) {
            return SyntaxKind.INT_KEYWORD;
        }
        if ("Float".equals(typeName)) {
            return SyntaxKind.FLOAT_KEYWORD;
        }
        if ("Boolean".equals(typeName)) {
            return SyntaxKind.BOOLEAN_KEYWORD;
        }
        if ("ID".equals(typeName)) {
            return SyntaxKind.STRING_KEYWORD;
        }
        throw new ServiceGenerationException(ServiceDiagnosticMessages.GRAPHQL_SERVICE_GEN_102, null, String.format("Should be a scalar type but found \"%s\".", typeName));
    }

    private SyntaxKind getTypeDescFor(String typeName) throws ServiceGenerationException {
        if ("String".equals(typeName)) {
            return SyntaxKind.STRING_TYPE_DESC;
        }
        if ("Int".equals(typeName)) {
            return SyntaxKind.INT_TYPE_DESC;
        }
        if ("Float".equals(typeName)) {
            return SyntaxKind.FLOAT_TYPE_DESC;
        }
        if ("Boolean".equals(typeName)) {
            return SyntaxKind.BOOLEAN_TYPE_DESC;
        }
        if ("ID".equals(typeName)) {
            return SyntaxKind.STRING_TYPE_DESC;
        }
        throw new ServiceGenerationException(ServiceDiagnosticMessages.GRAPHQL_SERVICE_GEN_102, null, String.format("Should be a scalar type but found \"%s\".", typeName));
    }

    private MetadataNode getMetadataNode(GraphQLType fieldType, String description, boolean deprecated, String deprecationReason) {
        if (fieldType instanceof GraphQLScalarType && ((GraphQLScalarType)fieldType).getName().equals("ID")) {
            return NodeFactory.createMetadataNode((Node)NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(this.generateMarkdownDocumentationLines(description, false))), (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphql"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"ID")), null)}));
        }
        return this.generateMetadata(description, null, deprecated, deprecationReason, false);
    }

    private GraphQLType getUnwrappedType(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLNonNull) {
            return this.getUnwrappedType(((GraphQLNonNull)graphQLType).getWrappedType());
        }
        if (graphQLType instanceof GraphQLList) {
            return this.getUnwrappedType(((GraphQLList)graphQLType).getWrappedType());
        }
        return graphQLType;
    }

    private NodeList<AnnotationNode> getAnnotationNodeList(GraphQLType graphQLType) {
        GraphQLType unWrappedType = this.getUnwrappedType(graphQLType);
        if (unWrappedType instanceof GraphQLScalarType && ((GraphQLScalarType)unWrappedType).getName().equals("ID")) {
            return AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphql"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"ID")), null)});
        }
        return AbstractNodeFactory.createEmptyNodeList();
    }
}

