/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.jsondata.json;

import io.ballerina.lib.data.jsondata.io.BallerinaByteBlockInputStream;
import io.ballerina.lib.data.jsondata.json.JsonCreator;
import io.ballerina.lib.data.jsondata.json.JsonParser;
import io.ballerina.lib.data.jsondata.json.JsonTraverse;
import io.ballerina.lib.data.jsondata.utils.DataReader;
import io.ballerina.lib.data.jsondata.utils.DataUtils;
import io.ballerina.lib.data.jsondata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.jsondata.utils.DiagnosticLog;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Native {
    public static Object parseAsType(Object json, BMap<BString, Object> options, BTypedesc typed) {
        try {
            return JsonTraverse.traverse(json, options, typed);
        }
        catch (BError e) {
            return e;
        }
    }

    public static Object parseString(BString json, BMap<BString, Object> options, BTypedesc typed) {
        try {
            return JsonParser.parse((Reader)new StringReader(json.getValue()), options, typed);
        }
        catch (BError e) {
            return e;
        }
    }

    public static Object parseBytes(BArray json, BMap<BString, Object> options, BTypedesc typed) {
        try {
            byte[] bytes = json.getBytes();
            return JsonParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(bytes)), options, typed);
        }
        catch (BError e) {
            return e;
        }
    }

    public static Object parseStream(Environment env, BStream json, BMap<BString, Object> options, BTypedesc typed) {
        BObject iteratorObj = json.getIteratorObj();
        return env.yieldAndRun(() -> {
            BallerinaByteBlockInputStream byteBlockSteam = new BallerinaByteBlockInputStream(env, iteratorObj, DataReader.resolveNextMethod(iteratorObj), DataReader.resolveCloseMethod(iteratorObj));
            Object result = JsonParser.parse((Reader)new InputStreamReader(byteBlockSteam), options, typed);
            if (byteBlockSteam.getError() != null) {
                return byteBlockSteam.getError();
            }
            return result;
        });
    }

    public static Object toJson(Object value) {
        return Native.toJson(value, new HashSet<Object>());
    }

    public static Object toJson(Object value, Set<Object> visitedValues) {
        if (Native.isSimpleBasicTypeOrString(value)) {
            return value;
        }
        if (!visitedValues.add(value)) {
            throw DiagnosticLog.error(DiagnosticErrorCode.CYCLIC_REFERENCE, new Object[0]);
        }
        if (value instanceof BArray) {
            BArray listValue = (BArray)value;
            int length = (int)listValue.getLength();
            Object[] convertedValues = new Object[length];
            for (int i = 0; i < length; ++i) {
                Object memValue = listValue.get((long)i);
                convertedValues[i] = Native.toJson(memValue, visitedValues);
                visitedValues.remove(memValue);
            }
            return ValueCreator.createArrayValue((Object[])convertedValues, (ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
        }
        if (value instanceof BMap) {
            BMap mapValue = (BMap)value;
            BMap jsonObject = ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_JSON));
            for (BString entryKey : (BString[])mapValue.getKeys()) {
                Object entryValue = mapValue.get((Object)entryKey);
                jsonObject.put((Object)Native.getNameAnnotation((BMap<BString, Object>)mapValue, entryKey), Native.toJson(entryValue, visitedValues));
                visitedValues.remove(entryValue);
            }
            return jsonObject;
        }
        if (value instanceof BTable) {
            BTable tableValue = (BTable)value;
            int length = tableValue.size();
            Object[] convertedValues = new Object[length];
            int index = 0;
            for (Object tableMember : tableValue.values()) {
                convertedValues[index++] = Native.toJson(tableMember, visitedValues);
                visitedValues.remove(tableMember);
            }
            return ValueCreator.createArrayValue((Object[])convertedValues, (ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
        }
        return JsonUtils.convertToJson((Object)value);
    }

    private static boolean isSimpleBasicTypeOrString(Object value) {
        return value == null || TypeUtils.getType((Object)value).getTag() < 7;
    }

    private static BString getNameAnnotation(BMap<BString, Object> value, BString key) {
        Type type = value.getType();
        if (!(type instanceof RecordType)) {
            return key;
        }
        RecordType recordType = (RecordType)type;
        BMap annotations = recordType.getAnnotations();
        for (BString keyV : (BString[])annotations.getKeys()) {
            String fieldName;
            String keyStr = keyV.toString();
            if (!keyStr.contains("$field$.") || !(fieldName = DataUtils.unescapeIdentifier(keyStr.split("\\$field\\$\\.")[1])).equals(key.getValue())) continue;
            Map fieldAnnotation = (Map)annotations.get((Object)keyV);
            String modifiedName = JsonCreator.getModifiedName(fieldAnnotation, fieldName);
            return StringUtils.fromString((String)modifiedName);
        }
        return key;
    }
}

