/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators.interfaces;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.Constants;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public interface DateValidator {
    default public void validate(Map.Entry<BString, Object> constraint, LocalDate date, boolean isMemberValue, List<ConstraintErrorInfo> failedConstraints, String path) {
        if (constraint.getKey().getValue().equals("option")) {
            Object constraintValue = constraint.getValue();
            String message = null;
            if (constraintValue instanceof BMap) {
                message = ((BMap)constraintValue).getStringValue(Constants.MESSAGE).getValue();
                constraintValue = ((BMap)constraintValue).get((Object)Constants.VALUE);
            }
            switch (constraintValue.toString()) {
                case "PAST": {
                    if (DateValidator.validateIsPastDate(date)) break;
                    failedConstraints.add(new ConstraintErrorInfo(path, message, "pastDate", isMemberValue));
                    break;
                }
                case "PAST_OR_PRESENT": {
                    if (DateValidator.validateIsPastOrPresentDate(date)) break;
                    failedConstraints.add(new ConstraintErrorInfo(path, message, "pastOrPresentDate", isMemberValue));
                    break;
                }
                case "FUTURE": {
                    if (DateValidator.validateIsFutureDate(date)) break;
                    failedConstraints.add(new ConstraintErrorInfo(path, message, "futureDate", isMemberValue));
                    break;
                }
                case "FUTURE_OR_PRESENT": {
                    if (DateValidator.validateIsFutureOrPresentDate(date)) break;
                    failedConstraints.add(new ConstraintErrorInfo(path, message, "futureOrPresentDate", isMemberValue));
                    break;
                }
            }
        }
    }

    public static boolean validateIsPastDate(LocalDate date) {
        return date.isBefore(LocalDate.now());
    }

    public static boolean validateIsPastOrPresentDate(LocalDate date) {
        return date.isBefore(LocalDate.now()) || date.isEqual(LocalDate.now());
    }

    public static boolean validateIsFutureDate(LocalDate date) {
        return date.isAfter(LocalDate.now());
    }

    public static boolean validateIsFutureOrPresentDate(LocalDate date) {
        return date.isAfter(LocalDate.now()) || date.isEqual(LocalDate.now());
    }
}

