/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.semver.checker.cmd;

import io.ballerina.cli.BLauncherCmd;
import io.ballerina.cli.launcher.LauncherUtils;
import io.ballerina.projects.ProjectException;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.semver.checker.SemverChecker;
import io.ballerina.semver.checker.exception.SemverToolException;
import java.io.PrintStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import picocli.CommandLine;

@CommandLine.Command(name="semver", description={"Show SemVer compatibility and local package changes against published packages in Ballerina Central"})
public class SemverCmd
implements BLauncherCmd {
    private final PrintStream outStream;
    private final PrintStream errStream;
    private static final String CMD_NAME = "semver";
    @CommandLine.Parameters(arity="0..1")
    private final Path projectPath = Path.of(System.getProperty("user.dir"), new String[0]);
    @CommandLine.Option(names={"-h", "--help"}, hidden=true)
    private boolean helpFlag;
    @CommandLine.Option(names={"-c", "--compare-version"}, description={"released version number which the current changes should be compared against (If not provided, the tool is expected to resolve the most compatible version available in the central)."})
    private String prevVersion;
    @CommandLine.Option(names={"-d", "--show-diff"}, description={"show the full list of changes between the compared versions"})
    private boolean showDiff;

    public SemverCmd() {
        this.outStream = System.out;
        this.errStream = System.err;
    }

    public void execute() {
        if (this.helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)CMD_NAME);
            this.outStream.println(commandUsageInfo);
            return;
        }
        try {
            SemanticVersion semanticVersion = null;
            if (this.prevVersion != null) {
                try {
                    semanticVersion = SemanticVersion.from((String)this.prevVersion);
                }
                catch (ProjectException e) {
                    throw new SemverToolException("invalid version '" + this.prevVersion + "' provided: ", (Throwable)e);
                }
                catch (Exception e) {
                    throw new SemverToolException("unhandled exception occurred while parsing the provided version '" + this.prevVersion + "'", (Throwable)e);
                }
            }
            SemverChecker semverChecker = new SemverChecker(this.projectPath, semanticVersion, this.outStream, this.errStream);
            if (this.showDiff) {
                this.outStream.println(semverChecker.getDiffSummary());
            } else {
                this.outStream.println(semverChecker.getVersionSuggestionSummary());
            }
        }
        catch (InvalidPathException e) {
            throw LauncherUtils.createLauncherException((String)"invalid project path provided for the semver tool: ", (Throwable)e);
        }
        catch (SemverToolException e) {
            throw LauncherUtils.createLauncherException((String)e.getMessage());
        }
        catch (Throwable t) {
            throw LauncherUtils.createLauncherException((String)"semver checker execution failed due to an unhandled exception: ", (Throwable)t);
        }
    }

    public String getName() {
        return CMD_NAME;
    }

    public void printLongDesc(StringBuilder out) {
        out.append(BLauncherCmd.getCommandUsageInfo((String)CMD_NAME));
    }

    public void printUsage(StringBuilder out) {
    }

    public void setParentCmdParser(CommandLine parentCmdParser) {
    }
}

