/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task;

import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websub.WebSubDiagnosticCodes;
import io.ballerina.stdlib.websub.task.AnalyserUtils;
import io.ballerina.stdlib.websub.task.validator.ServiceDeclarationValidator;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Optional;

public class ServiceAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final ServiceDeclarationValidator validator = ServiceDeclarationValidator.getInstance();

    public void perform(SyntaxNodeAnalysisContext context) {
        ServiceDeclarationSymbol serviceDeclarationSymbol;
        boolean erroneousCompilation = context.semanticModel().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (erroneousCompilation) {
            return;
        }
        ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)context.node();
        Optional serviceDeclarationOpt = context.semanticModel().symbol((Node)serviceNode);
        if (serviceDeclarationOpt.isPresent() && AnalyserUtils.isWebSubService(serviceDeclarationSymbol = (ServiceDeclarationSymbol)serviceDeclarationOpt.get())) {
            this.invokeCodeActions(context, serviceNode);
            this.validator.validate(context, serviceNode, serviceDeclarationSymbol);
        }
    }

    private void invokeCodeActions(SyntaxNodeAnalysisContext context, ServiceDeclarationNode serviceNode) {
        if (serviceNode.members().isEmpty()) {
            WebSubDiagnosticCodes codeActionDiagnostic = WebSubDiagnosticCodes.WEBSUB_202;
            AnalyserUtils.updateContext(context, codeActionDiagnostic, serviceNode.location(), new Object[0]);
        }
    }
}

