/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.stdlib.websub.task.service.path.ServicePathContext;
import io.ballerina.stdlib.websub.task.service.path.ServicePathContextHandler;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class ServiceMetaInfoUpdaterTask
implements ModifierTask<SourceModifierContext> {
    public void modify(SourceModifierContext context) {
        SyntaxTree updatedSyntaxTree;
        ModulePartNode newModulePart;
        NodeList<ModuleMemberDeclarationNode> newMembers;
        ModulePartNode rootNode;
        Document currentDoc;
        List<ServicePathContext.ServicePathInformation> servicePathDetails;
        Optional<ServicePathContext> servicePathContextOpt;
        SemanticModel semanticModel;
        Module currentModule;
        boolean erroneousCompilation = context.compilation().diagnosticResult().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (erroneousCompilation) {
            return;
        }
        for (ModuleId modId : context.currentPackage().moduleIds()) {
            currentModule = context.currentPackage().module(modId);
            semanticModel = context.compilation().getSemanticModel(modId);
            for (DocumentId docId : currentModule.documentIds()) {
                servicePathContextOpt = ServicePathContextHandler.getContextHandler().retrieveContext(modId, docId);
                if (servicePathContextOpt.isEmpty() || (servicePathDetails = servicePathContextOpt.get().getServicePathDetails()).isEmpty()) continue;
                currentDoc = currentModule.document(docId);
                rootNode = (ModulePartNode)currentDoc.syntaxTree().rootNode();
                newMembers = this.updateMemberNodes((NodeList<ModuleMemberDeclarationNode>)rootNode.members(), servicePathDetails, semanticModel);
                newModulePart = rootNode.modify(rootNode.imports(), newMembers, rootNode.eofToken());
                updatedSyntaxTree = currentDoc.syntaxTree().modifyWith((Node)newModulePart);
                context.modifySourceFile(updatedSyntaxTree.textDocument(), docId);
            }
        }
        for (ModuleId modId : context.currentPackage().moduleIds()) {
            currentModule = context.currentPackage().module(modId);
            semanticModel = context.compilation().getSemanticModel(modId);
            for (DocumentId docId : currentModule.testDocumentIds()) {
                servicePathContextOpt = ServicePathContextHandler.getContextHandler().retrieveContext(modId, docId);
                if (servicePathContextOpt.isEmpty() || (servicePathDetails = servicePathContextOpt.get().getServicePathDetails()).isEmpty()) continue;
                currentDoc = currentModule.document(docId);
                rootNode = (ModulePartNode)currentDoc.syntaxTree().rootNode();
                newMembers = this.updateMemberNodes((NodeList<ModuleMemberDeclarationNode>)rootNode.members(), servicePathDetails, semanticModel);
                newModulePart = rootNode.modify(rootNode.imports(), newMembers, rootNode.eofToken());
                updatedSyntaxTree = currentDoc.syntaxTree().modifyWith((Node)newModulePart);
                context.modifyTestSourceFile(updatedSyntaxTree.textDocument(), docId);
            }
        }
    }

    private NodeList<ModuleMemberDeclarationNode> updateMemberNodes(NodeList<ModuleMemberDeclarationNode> oldMembers, List<ServicePathContext.ServicePathInformation> sd, SemanticModel semanticModel) {
        LinkedList<Object> updatedMembers = new LinkedList<Object>();
        for (ModuleMemberDeclarationNode memberNode : oldMembers) {
            if (memberNode.kind() != SyntaxKind.SERVICE_DECLARATION) {
                updatedMembers.add(memberNode);
                continue;
            }
            ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)memberNode;
            Optional servicePathInfoOpt = semanticModel.symbol((Node)serviceNode).flatMap(symbol -> sd.stream().filter(service -> service.getServiceId() == symbol.hashCode()).findFirst());
            if (servicePathInfoOpt.isEmpty()) {
                updatedMembers.add(memberNode);
                continue;
            }
            ServicePathContext.ServicePathInformation servicePathInfo = (ServicePathContext.ServicePathInformation)servicePathInfoOpt.get();
            Optional metadata = serviceNode.metadata();
            if (!metadata.isPresent()) continue;
            MetadataNode metadataNode = (MetadataNode)metadata.get();
            MetadataNode.MetadataNodeModifier modifier = metadataNode.modify();
            NodeList<AnnotationNode> updatedAnnotations = this.updateAnnotations((NodeList<AnnotationNode>)metadataNode.annotations(), servicePathInfo.getServicePath());
            modifier.withAnnotations(updatedAnnotations);
            MetadataNode updatedMetadataNode = modifier.apply();
            ServiceDeclarationNode.ServiceDeclarationNodeModifier serviceDecModifier = serviceNode.modify();
            serviceDecModifier.withMetadata(updatedMetadataNode);
            ServiceDeclarationNode updatedServiceDecNode = serviceDecModifier.apply();
            updatedMembers.add(updatedServiceDecNode);
        }
        return AbstractNodeFactory.createNodeList(updatedMembers);
    }

    private NodeList<AnnotationNode> updateAnnotations(NodeList<AnnotationNode> currentAnnotations, String servicePath) {
        NodeList updatedAnnotations = NodeFactory.createNodeList((Node[])new AnnotationNode[0]);
        for (AnnotationNode annotation : currentAnnotations) {
            if (this.isSubscriberServiceConfig(annotation)) {
                SeparatedNodeList<MappingFieldNode> updatedFields = this.getUpdatedFields(annotation, servicePath);
                MappingConstructorExpressionNode annotationValue = NodeFactory.createMappingConstructorExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), updatedFields, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
                annotation = annotation.modify().withAnnotValue(annotationValue).apply();
            }
            updatedAnnotations = updatedAnnotations.add((Node)annotation);
        }
        return updatedAnnotations;
    }

    private SeparatedNodeList<MappingFieldNode> getUpdatedFields(AnnotationNode annotation, String servicePath) {
        Optional annotationValueOpt = annotation.annotValue();
        if (annotationValueOpt.isEmpty()) {
            return NodeFactory.createSeparatedNodeList((Node[])new Node[]{ServiceMetaInfoUpdaterTask.createServicePathField(servicePath)});
        }
        ArrayList<Object> fields = new ArrayList<Object>();
        MappingConstructorExpressionNode annotationValue = (MappingConstructorExpressionNode)annotationValueOpt.get();
        SeparatedNodeList existingFields = annotationValue.fields();
        Token separator = NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN);
        for (MappingFieldNode field : existingFields) {
            fields.add(field);
            fields.add(separator);
        }
        fields.add(ServiceMetaInfoUpdaterTask.createServicePathField(servicePath));
        return NodeFactory.createSeparatedNodeList(fields);
    }

    private static SpecificFieldNode createServicePathField(String value) {
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)"servicePath");
        Token colonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        String encodedValue = Base64.getEncoder().encodeToString(value.getBytes(Charset.defaultCharset()));
        ExpressionNode expressionNode = NodeParser.parseExpression((String)String.format("base64 `%s`.cloneReadOnly()", encodedValue));
        return NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colonToken, (ExpressionNode)expressionNode);
    }

    private boolean isSubscriberServiceConfig(AnnotationNode annotationNode) {
        QualifiedNameReferenceNode referenceNode = (QualifiedNameReferenceNode)annotationNode.annotReference();
        if (!"websub".equals(referenceNode.modulePrefix().text())) {
            return false;
        }
        return "SubscriberServiceConfig".equals(referenceNode.identifier().text());
    }
}

