/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task.service.path;

import io.ballerina.projects.DocumentId;
import io.ballerina.projects.ModuleId;
import io.ballerina.stdlib.websub.task.service.path.ServicePathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ServicePathContextHandler {
    private static ServicePathContextHandler contextHandlerInstance;
    private final List<ServicePathContext> contexts = new ArrayList<ServicePathContext>();

    private ServicePathContextHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServicePathContextHandler getContextHandler() {
        Class<ServicePathContextHandler> clazz = ServicePathContextHandler.class;
        synchronized (ServicePathContextHandler.class) {
            if (Objects.isNull(contextHandlerInstance)) {
                contextHandlerInstance = new ServicePathContextHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return contextHandlerInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addContext(ServicePathContext context) {
        List<ServicePathContext> list = this.contexts;
        synchronized (list) {
            this.contexts.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServicePathContext(ModuleId moduleId, DocumentId documentId, ServicePathContext.ServicePathInformation servicePathInformation) {
        Optional<ServicePathContext> contextOpt = this.retrieveContext(moduleId, documentId);
        if (contextOpt.isPresent()) {
            ServicePathContext context;
            ServicePathContext servicePathContext = context = contextOpt.get();
            synchronized (servicePathContext) {
                context.updateServicePathDetails(servicePathInformation);
            }
            return;
        }
        ServicePathContext context = new ServicePathContext(moduleId, documentId);
        context.updateServicePathDetails(servicePathInformation);
        this.addContext(context);
    }

    public Optional<ServicePathContext> retrieveContext(ModuleId moduleId, DocumentId documentId) {
        return this.contexts.stream().filter(ctx -> this.equals((ServicePathContext)ctx, moduleId, documentId)).findFirst();
    }

    private boolean equals(ServicePathContext context, ModuleId moduleId, DocumentId documentId) {
        int hashCodeForCurrentContext = Objects.hash(context.getModuleId(), context.getDocumentId());
        return hashCodeForCurrentContext == Objects.hash(moduleId, documentId);
    }
}

