/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.json.jaxb;

import java.lang.reflect.Method;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;

public class JsonXMLRootProvider {
    protected String getNamespaceURI(XmlType xmlType, XmlSchema xmlSchema) {
        if ("##default".equals(xmlType.namespace())) {
            return xmlSchema == null ? "" : xmlSchema.namespace();
        }
        return xmlType.namespace();
    }

    protected String getNamespaceURI(XmlRootElement xmlRootElement, XmlSchema xmlSchema) {
        if ("##default".equals(xmlRootElement.namespace())) {
            return xmlSchema == null ? "" : xmlSchema.namespace();
        }
        return xmlRootElement.namespace();
    }

    protected String getNamespaceURI(XmlElementDecl xmlElementDecl, XmlSchema xmlSchema) {
        if ("##default".equals(xmlElementDecl.namespace())) {
            return xmlSchema == null ? "" : xmlSchema.namespace();
        }
        return xmlElementDecl.namespace();
    }

    protected String getPrefix(String namespaceURI, XmlSchema xmlSchema) {
        if (xmlSchema != null) {
            for (XmlNs xmlns : xmlSchema.xmlns()) {
                if (!xmlns.namespaceURI().equals(namespaceURI)) continue;
                return xmlns.prefix();
            }
        }
        return "";
    }

    protected QName getXmlRootElementName(Class<?> type) {
        XmlRootElement xmlRootElement = type.getAnnotation(XmlRootElement.class);
        if (xmlRootElement == null) {
            return null;
        }
        String localName = "##default".equals(xmlRootElement.name()) ? Character.toLowerCase(type.getSimpleName().charAt(0)) + type.getSimpleName().substring(1) : xmlRootElement.name();
        XmlSchema xmlSchema = type.getPackage().getAnnotation(XmlSchema.class);
        String namespaceURI = this.getNamespaceURI(xmlRootElement, xmlSchema);
        return new QName(namespaceURI, localName, this.getPrefix(namespaceURI, xmlSchema));
    }

    protected QName getXmlTypeName(Class<?> type) {
        Method method = this.getXmlElementDeclMethod(type);
        if (method == null) {
            return null;
        }
        XmlElementDecl xmlElementDecl = method.getAnnotation(XmlElementDecl.class);
        if (xmlElementDecl == null) {
            return null;
        }
        XmlSchema xmlSchema = type.getPackage().getAnnotation(XmlSchema.class);
        String namespaceURI = this.getNamespaceURI(xmlElementDecl, xmlSchema);
        return new QName(namespaceURI, xmlElementDecl.name(), this.getPrefix(namespaceURI, xmlSchema));
    }

    protected Method getXmlElementDeclMethod(Class<?> type) {
        XmlType xmlType = type.getAnnotation(XmlType.class);
        if (xmlType == null) {
            return null;
        }
        Class<?> factoryClass = xmlType.factoryClass();
        if (factoryClass == XmlType.DEFAULT.class) {
            String defaultObjectFactoryName = type.getPackage().getName() + ".ObjectFactory";
            try {
                factoryClass = Thread.currentThread().getContextClassLoader().loadClass(defaultObjectFactoryName);
            }
            catch (Exception e) {
                factoryClass = type;
            }
        }
        if (factoryClass.getAnnotation(XmlRegistry.class) == null) {
            return null;
        }
        XmlSchema xmlSchema = type.getPackage().getAnnotation(XmlSchema.class);
        String namespaceURI = this.getNamespaceURI(xmlType, xmlSchema);
        for (Method method : factoryClass.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            XmlElementDecl xmlElementDecl = method.getAnnotation(XmlElementDecl.class);
            if (xmlElementDecl == null || !namespaceURI.equals(this.getNamespaceURI(xmlElementDecl, xmlSchema)) || method.getReturnType() != JAXBElement.class || (parameterTypes = method.getParameterTypes()).length != 1 || parameterTypes[0] != type) continue;
            return method;
        }
        return null;
    }

    public QName getName(Class<?> type) {
        if (type.getAnnotation(XmlRootElement.class) != null) {
            return this.getXmlRootElementName(type);
        }
        if (type.getAnnotation(XmlType.class) != null) {
            return this.getXmlTypeName(type);
        }
        return null;
    }

    public JAXBElement<?> createElement(Class<?> type, Object value) throws JAXBException {
        Method method;
        if (type.getAnnotation(XmlRootElement.class) != null) {
            QName name = this.getXmlRootElementName(type);
            if (name != null) {
                JAXBElement genericElement = new JAXBElement(name, type, value);
                return genericElement;
            }
        } else if (type.getAnnotation(XmlType.class) != null && (method = this.getXmlElementDeclMethod(type)) != null) {
            try {
                return (JAXBElement)method.invoke(method.getDeclaringClass().newInstance(), value);
            }
            catch (Exception e) {
                throw new JAXBException("Cannot create JAXBElement", (Throwable)e);
            }
        }
        return null;
    }
}

