/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.formatter;

import io.ballerina.syntaxapicallsgen.SyntaxApiCallsGenException;
import io.ballerina.syntaxapicallsgen.formatter.NoFormatter;
import io.ballerina.syntaxapicallsgen.formatter.SegmentFormatter;
import io.ballerina.syntaxapicallsgen.segment.NodeFactorySegment;
import io.ballerina.syntaxapicallsgen.segment.Segment;
import io.ballerina.syntaxapicallsgen.segment.factories.SegmentFactory;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class VariableFormatter
extends SegmentFormatter {
    private static final String SEMICOLON_CHAR = ";";
    private static final String SPACE_CHAR = " ";
    private static final String EQ_CHAR = " = ";
    private static final String MINUTIAE_LIST_DEF = "MinutiaeList trailingMinutiae, leadingMinutiae;\n\n";
    private static final String LEADING_MINUTIAE = "leadingMinutiae";
    private static final String TRAILING_MINUTIAE = "trailingMinutiae";
    private static final String TOKEN_SUFFIX = "Token";
    private final SegmentFormatter formatter = new NoFormatter();
    private HashMap<String, Integer> variableCount;

    VariableFormatter() {
    }

    @Override
    public String format(Segment segment) {
        if (segment instanceof NodeFactorySegment) {
            NodeFactorySegment nodeFactorySegment = (NodeFactorySegment)segment;
            this.variableCount = new HashMap();
            return MINUTIAE_LIST_DEF + String.valueOf(this.processNode(nodeFactorySegment));
        }
        throw new SyntaxApiCallsGenException("Expected a valid node segment but fount parsed segment of " + String.valueOf(segment));
    }

    private NamedContent processToken(NodeFactorySegment token) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayDeque params = new ArrayDeque();
        token.forEach(params::push);
        NamedContent namedContent = new NamedContent(token.getType(), this.variableCount);
        NodeFactorySegment factorySegment = SegmentFactory.createNodeFactorySegment(token.getMethodName());
        boolean minutiaeNodesPresent = false;
        if (params.size() >= 2) {
            Iterator paramIterator = params.iterator();
            Segment lastSegment1 = (Segment)paramIterator.next();
            Segment lastSegment2 = (Segment)paramIterator.next();
            if (lastSegment1 instanceof NodeFactorySegment && lastSegment2 instanceof NodeFactorySegment && ((NodeFactorySegment)lastSegment1).isMinutiae() && ((NodeFactorySegment)lastSegment2).isMinutiae()) {
                String trailingMinutiae = this.formatter.format((Segment)params.pop());
                String leadingMinutiae = this.formatter.format((Segment)params.pop());
                stringBuilder.append(LEADING_MINUTIAE).append(EQ_CHAR).append(leadingMinutiae).append(SEMICOLON_CHAR).append(System.lineSeparator());
                stringBuilder.append(TRAILING_MINUTIAE).append(EQ_CHAR).append(trailingMinutiae).append(SEMICOLON_CHAR).append(System.lineSeparator());
                minutiaeNodesPresent = true;
            }
        }
        while (!params.isEmpty()) {
            factorySegment.addParameter((Segment)params.removeLast());
        }
        if (minutiaeNodesPresent) {
            factorySegment.addParameter(SegmentFactory.createCodeSegment(LEADING_MINUTIAE));
            factorySegment.addParameter(SegmentFactory.createCodeSegment(TRAILING_MINUTIAE));
        }
        stringBuilder.append(token.getType()).append(SPACE_CHAR).append(namedContent.name).append(EQ_CHAR).append(factorySegment).append(SEMICOLON_CHAR).append(System.lineSeparator()).append(System.lineSeparator());
        namedContent.content = stringBuilder.toString();
        return namedContent;
    }

    private NamedContent processNode(NodeFactorySegment segment) {
        if (segment.getMethodName().endsWith(TOKEN_SUFFIX)) {
            return this.processToken(segment);
        }
        StringBuilder stringBuilder = new StringBuilder();
        NodeFactorySegment factorySegment = segment.createCopy();
        for (Segment child : segment) {
            if (child instanceof NodeFactorySegment) {
                NodeFactorySegment childFactoryCall = (NodeFactorySegment)child;
                NamedContent namedContent = this.processNode(childFactoryCall);
                stringBuilder.append(namedContent.content);
                factorySegment.addParameter(SegmentFactory.createCodeSegment(namedContent.name));
                continue;
            }
            factorySegment.addParameter(child);
        }
        NamedContent namedContent = new NamedContent(segment.getType(), this.variableCount);
        stringBuilder.append(factorySegment.getType()).append(factorySegment.getGenericType()).append(SPACE_CHAR).append(namedContent.name).append(EQ_CHAR).append(factorySegment).append(SEMICOLON_CHAR).append(System.lineSeparator()).append(System.lineSeparator());
        namedContent.content = stringBuilder.toString();
        return namedContent;
    }

    private static class NamedContent {
        final String name;
        String content;

        NamedContent(String type, Map<String, Integer> variableCount) {
            String varGenericName = type.substring(0, 1).toLowerCase(Locale.getDefault()) + type.substring(1);
            int varGenericCount = variableCount.getOrDefault(varGenericName, 0);
            this.name = varGenericName + (varGenericCount == 0 ? "" : String.valueOf(varGenericCount));
            variableCount.put(varGenericName, varGenericCount + 1);
        }

        public String toString() {
            return this.content;
        }
    }
}

