/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.parser;

import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.syntaxapicallsgen.parser.StatementParser;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;

public class ExpressionParser
extends StatementParser {
    private static final String QUOTE = ";";

    public ExpressionParser(long timeoutMs) {
        super(timeoutMs);
    }

    @Override
    public Node parse(String source) {
        source = ((String)source).endsWith(QUOTE) ? source : (String)source + QUOTE;
        String sourceCode = String.format("function main(){return %s}", source);
        TextDocument document = TextDocuments.from((String)sourceCode);
        SyntaxTree tree = this.getSyntaxTree(document);
        ModulePartNode node = (ModulePartNode)tree.rootNode();
        NodeList moduleDclns = node.members();
        this.assertIf(!moduleDclns.isEmpty(), "not a valid expression: expected at least one member");
        ModuleMemberDeclarationNode moduleDeclaration = (ModuleMemberDeclarationNode)moduleDclns.get(0);
        FunctionDefinitionNode mainFunction = (FunctionDefinitionNode)moduleDeclaration;
        FunctionBodyBlockNode mainFunctionBody = (FunctionBodyBlockNode)mainFunction.functionBody();
        this.assertIf(!mainFunctionBody.statements().isEmpty(), "not a valid expression: could not find any statements");
        StatementNode statementNode = (StatementNode)mainFunctionBody.statements().get(0);
        this.assertIf(statementNode instanceof ReturnStatementNode, "not a valid expression: expected a return statement");
        assert (statementNode instanceof ReturnStatementNode);
        ReturnStatementNode returnStatement = (ReturnStatementNode)statementNode;
        this.assertIf(returnStatement.expression().isPresent(), "not a valid expression: expected an expression on return");
        return (Node)returnStatement.expression().get();
    }
}

