/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.segment.factories;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.syntaxapicallsgen.SyntaxApiCallsGenException;
import io.ballerina.syntaxapicallsgen.config.SyntaxApiCallsGenConfig;
import io.ballerina.syntaxapicallsgen.segment.Segment;
import io.ballerina.syntaxapicallsgen.segment.factories.NonTerminalSegmentFactory;
import io.ballerina.syntaxapicallsgen.segment.factories.SegmentFactory;
import io.ballerina.syntaxapicallsgen.segment.factories.TokenSegmentFactory;
import io.ballerina.syntaxapicallsgen.segment.factories.cache.ChildNamesCache;
import io.ballerina.syntaxapicallsgen.segment.factories.cache.NodeFactoryMethodCache;

public class NodeSegmentFactory {
    private final NonTerminalSegmentFactory nonTerminalSegmentFactory;
    private final TokenSegmentFactory tokenSegmentFactory;

    private NodeSegmentFactory(ChildNamesCache childNamesCache, NodeFactoryMethodCache methodCache, boolean ignoreMinutiae) {
        this.nonTerminalSegmentFactory = new NonTerminalSegmentFactory(this, childNamesCache, methodCache);
        this.tokenSegmentFactory = new TokenSegmentFactory(ignoreMinutiae);
    }

    public static NodeSegmentFactory fromConfig(SyntaxApiCallsGenConfig config) {
        return new NodeSegmentFactory(ChildNamesCache.fromConfig(config), NodeFactoryMethodCache.create(), config.ignoreMinutiae());
    }

    public Segment createNodeSegment(Node node) {
        if (node == null) {
            return SegmentFactory.createNullSegment();
        }
        if (node instanceof Token) {
            Token token = (Token)node;
            return this.tokenSegmentFactory.createTokenSegment(token);
        }
        if (node instanceof NonTerminalNode) {
            NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
            return this.nonTerminalSegmentFactory.createNonTerminalSegment(nonTerminalNode);
        }
        throw new SyntaxApiCallsGenException("Expected non terminal or token. Found unexpected node type for: " + String.valueOf(node));
    }
}

