/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.annotations;

import io.ballerina.runtime.api.types.AnnotatableType;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.annotations.AbstractAnnotations;
import io.ballerina.stdlib.constraint.annotations.RecordFieldAnnotations;
import java.util.List;

public class TypeAnnotations
extends AbstractAnnotations {
    private final List<ConstraintErrorInfo> failedConstraintsInfo;

    public TypeAnnotations(List<ConstraintErrorInfo> failedConstraintsInfo) {
        super(failedConstraintsInfo);
        this.failedConstraintsInfo = failedConstraintsInfo;
    }

    @Override
    public void validate(Object value, AnnotatableType type, String path, boolean isMemberValue) {
        BMap typeAnnotations = type.getAnnotations();
        Object fieldValue = this.getFieldValue(value);
        super.validateAnnotations((BMap<BString, Object>)typeAnnotations, fieldValue, path, isMemberValue);
        if (type.getTag() == 53) {
            this.validateReferredType(value, (Type)type, path, isMemberValue);
        }
    }

    private Object getFieldValue(Object value) {
        if (value instanceof BDecimal) {
            return ((BDecimal)value).value();
        }
        if (value instanceof BString) {
            return ((BString)value).getValue();
        }
        if (value instanceof BArray) {
            return ((BArray)value).getLength();
        }
        return value;
    }

    private void validateReferredType(Object value, Type type, String path, boolean isMemberValue) {
        List constituentTypes;
        Type referredType = TypeUtils.getReferredType((Type)type);
        if (referredType.isReadOnly() && referredType instanceof IntersectionType && (constituentTypes = ((IntersectionType)referredType).getConstituentTypes()).size() == 2) {
            referredType = ((Type)constituentTypes.get(0)).getTag() == 51 ? TypeUtils.getReferredType((Type)((Type)constituentTypes.get(1))) : TypeUtils.getReferredType((Type)((Type)constituentTypes.get(0)));
        }
        if (referredType instanceof AnnotatableType) {
            if (referredType instanceof RecordType) {
                RecordFieldAnnotations recordFieldAnnotations = new RecordFieldAnnotations(this.failedConstraintsInfo);
                recordFieldAnnotations.validate(value, (AnnotatableType)referredType, path, isMemberValue);
            } else {
                this.validate(value, (AnnotatableType)referredType, path, isMemberValue);
            }
        } else if (referredType instanceof ArrayType) {
            this.validateArrayType((ArrayType)referredType, (BArray)value, path);
        }
    }

    private void validateArrayType(ArrayType referredType, BArray value, String path) {
        block4: {
            Type elementType = referredType.getElementType();
            if (elementType.getTag() != 53 || !(elementType instanceof AnnotatableType)) break block4;
            if (elementType instanceof RecordType) {
                RecordFieldAnnotations recordFieldAnnotations = new RecordFieldAnnotations(this.failedConstraintsInfo);
                int i = 0;
                while ((long)i < value.getLength()) {
                    BMap map = (BMap)value.getRefValue((long)i);
                    recordFieldAnnotations.validate(map, (AnnotatableType)elementType, path + "[" + i + "]", true);
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < value.getLength()) {
                    this.validate(value.getRefValue((long)i), (AnnotatableType)elementType, path + "[" + i + "]", true);
                    ++i;
                }
            }
        }
    }
}

