/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.codeaction;

import io.ballerina.stdlib.persist.compiler.DiagnosticsCodes;
import io.ballerina.stdlib.persist.compiler.codeaction.AbstractRemoveUnsupportedSyntax;
import io.ballerina.stdlib.persist.compiler.codeaction.PersistCodeActionName;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextRange;
import java.util.List;

public class RemoveDiagnosticLocation
extends AbstractRemoveUnsupportedSyntax {
    @Override
    protected String getName() {
        return PersistCodeActionName.REMOVE_DIAGNOSTIC_LOCATION.getName();
    }

    @Override
    protected List<String> getSupportedDiagnosticCodes() {
        return List.of(DiagnosticsCodes.PERSIST_101.getCode(), DiagnosticsCodes.PERSIST_301.getCode(), DiagnosticsCodes.PERSIST_303.getCode(), DiagnosticsCodes.PERSIST_401.getCode());
    }

    @Override
    protected String getTitle(Diagnostic diagnostic) {
        String code = diagnostic.diagnosticInfo().code();
        if (code.equals(DiagnosticsCodes.PERSIST_101.getCode())) {
            return "Remove unsupported member";
        }
        if (code.equals(DiagnosticsCodes.PERSIST_301.getCode())) {
            return "Remove rest descriptor field";
        }
        if (code.equals(DiagnosticsCodes.PERSIST_303.getCode())) {
            return "Remove inherited field";
        }
        return "Remove self-referenced field";
    }

    @Override
    protected TextRange getNodeLocation(Diagnostic diagnostic) {
        return diagnostic.location().textRange();
    }
}

