/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.codeaction;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.plugins.codeaction.CodeAction;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionInfo;
import io.ballerina.projects.plugins.codeaction.DocumentEdit;
import io.ballerina.stdlib.persist.compiler.DiagnosticsCodes;
import io.ballerina.stdlib.persist.compiler.codeaction.PersistCodeActionName;
import io.ballerina.stdlib.persist.compiler.utils.Utils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SwitchRelationOwner
implements CodeAction {
    public List<String> supportedDiagnosticCodes() {
        return List.of(DiagnosticsCodes.PERSIST_004.getCode());
    }

    public Optional<CodeActionInfo> codeActionInfo(CodeActionContext codeActionContext) {
        Diagnostic diagnostic = codeActionContext.diagnostic();
        List properties = diagnostic.properties();
        if (properties.size() % 4 != 1) {
            return Optional.empty();
        }
        String ownerName = Utils.getStringDiagnosticProperty(properties, 0);
        ArrayList<CodeActionArgument> arguments = new ArrayList<CodeActionArgument>();
        for (int i = 1; i < properties.size(); i += 4) {
            TextRange deleteRange = TextRange.from((int)Utils.getNumericDiagnosticProperty(properties, i), (int)Utils.getNumericDiagnosticProperty(properties, i + 1));
            TextRange addRange = TextRange.from((int)Utils.getNumericDiagnosticProperty(properties, i + 2), (int)0);
            String addText = Utils.getStringDiagnosticProperty(properties, i + 3);
            arguments.add(CodeActionArgument.from((String)("remove.text.range." + i), (Object)deleteRange));
            arguments.add(CodeActionArgument.from((String)("add.text.range." + i), (Object)addRange));
            arguments.add(CodeActionArgument.from((String)("add.text." + i), (Object)addText));
        }
        return Optional.of(CodeActionInfo.from((String)MessageFormat.format("Make ''{0}'' entity relation owner", ownerName), arguments));
    }

    public List<DocumentEdit> execute(CodeActionExecutionContext context) {
        List arguments = context.arguments();
        if (arguments.size() % 3 != 0) {
            return Collections.emptyList();
        }
        if (arguments.stream().anyMatch(Objects::isNull)) {
            return Collections.emptyList();
        }
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        for (int i = 0; i < arguments.size(); i += 3) {
            TextRange removeRange = (TextRange)((CodeActionArgument)arguments.get(i)).valueAs(TextRange.class);
            TextRange addRange = (TextRange)((CodeActionArgument)arguments.get(i + 1)).valueAs(TextRange.class);
            String addText = (String)((CodeActionArgument)arguments.get(i + 2)).valueAs(String.class);
            textEdits.add(TextEdit.from((TextRange)removeRange, (String)""));
            textEdits.add(TextEdit.from((TextRange)addRange, (String)addText));
        }
        textEdits.sort(Comparator.comparingInt(t -> t.range().startOffset()));
        SyntaxTree syntaxTree = context.currentDocument().syntaxTree();
        TextDocumentChange change = TextDocumentChange.from((TextEdit[])textEdits.toArray(new TextEdit[0]));
        TextDocument modifiedTextDocument = syntaxTree.textDocument().apply(change);
        return Collections.singletonList(new DocumentEdit(context.fileUri(), SyntaxTree.from((TextDocument)modifiedTextDocument)));
    }

    public String name() {
        return PersistCodeActionName.SWITCH_RELATION_OWNER.getName();
    }
}

