/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.model;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.stdlib.persist.compiler.model.GroupedRelationField;
import io.ballerina.stdlib.persist.compiler.model.IdentityField;
import io.ballerina.stdlib.persist.compiler.model.RelationField;
import io.ballerina.stdlib.persist.compiler.model.SimpleTypeField;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class Entity {
    private final String entityName;
    private final NodeLocation entityNameLocation;
    private final RecordTypeDescriptorNode typeDescriptorNode;
    private final List<IdentityField> identityFields = new ArrayList<IdentityField>();
    private final List<SimpleTypeField> nonRelationFields = new ArrayList<SimpleTypeField>();
    private final HashMap<String, RelationField> relationFields = new HashMap();
    private final HashMap<String, GroupedRelationField> groupedRelationFields = new HashMap();
    private final List<Diagnostic> diagnosticList = new ArrayList<Diagnostic>();
    private boolean containsRelations = false;
    private final List<AnnotationNode> annotations;

    public Entity(String entityName, NodeLocation entityNameLocation, RecordTypeDescriptorNode typeDescriptorNode, List<AnnotationNode> annotations) {
        this.entityName = entityName;
        this.entityNameLocation = entityNameLocation;
        this.typeDescriptorNode = typeDescriptorNode;
        this.annotations = annotations;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public NodeLocation getEntityNameLocation() {
        return this.entityNameLocation;
    }

    public RecordTypeDescriptorNode getTypeDescriptorNode() {
        return this.typeDescriptorNode;
    }

    public List<String> getIdentityFieldNames() {
        return this.identityFields.stream().map(IdentityField::getName).collect(Collectors.toList());
    }

    public List<IdentityField> getIdentityFields() {
        return this.identityFields;
    }

    public void addIdentityField(IdentityField field) {
        this.identityFields.add(field);
    }

    public List<SimpleTypeField> getNonRelationFields() {
        return this.nonRelationFields;
    }

    public void addNonRelationField(SimpleTypeField field) {
        this.nonRelationFields.add(field);
    }

    public boolean isContainsRelations() {
        return this.containsRelations;
    }

    public void setContainsRelations(boolean containsRelations) {
        this.containsRelations = containsRelations;
    }

    public HashMap<String, RelationField> getRelationFields() {
        return this.relationFields;
    }

    public HashMap<String, GroupedRelationField> getGroupedRelationFields() {
        return this.groupedRelationFields;
    }

    public void addRelationField(RelationField relationField) {
        if (this.relationFields.containsKey(relationField.getType())) {
            RelationField existingRelation = this.relationFields.remove(relationField.getType());
            this.groupedRelationFields.compute(relationField.getType(), (key, value) -> {
                if (value == null) {
                    value = new GroupedRelationField(this.entityName);
                    value.addRelationField(existingRelation);
                }
                value.addRelationField(relationField);
                return value;
            });
        } else if (this.getGroupedRelationFields().containsKey(relationField.getType())) {
            this.getGroupedRelationFields().computeIfPresent(relationField.getType(), (key, value) -> {
                value.addRelationField(relationField);
                return value;
            });
        } else {
            this.relationFields.put(relationField.getType(), relationField);
        }
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnosticList;
    }

    public void reportDiagnostic(String code, String message, DiagnosticSeverity severity, NodeLocation location) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, message, severity);
        this.diagnosticList.add(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
    }

    public void reportDiagnostic(String code, String message, DiagnosticSeverity severity, NodeLocation location, List<DiagnosticProperty<?>> diagnosticProperties) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(code, message, severity);
        this.diagnosticList.add(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, diagnosticProperties, (Object[])new Object[0]));
    }

    public List<AnnotationNode> getAnnotations() {
        return Collections.unmodifiableList(this.annotations);
    }
}

