/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler.utils;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.projects.plugins.codeaction.CodeActionArgument;
import io.ballerina.projects.plugins.codeaction.CodeActionContext;
import io.ballerina.projects.plugins.codeaction.CodeActionExecutionContext;
import io.ballerina.stdlib.persist.compiler.BalException;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import io.ballerina.tools.text.TextRange;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BNumericProperty;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BStringProperty;

public final class Utils {
    private Utils() {
    }

    public static boolean hasCompilationErrors(SyntaxNodeAnalysisContext context) {
        for (Diagnostic diagnostic : context.compilation().diagnosticResult().diagnostics()) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return true;
        }
        return false;
    }

    public static String stripEscapeCharacter(String name) {
        return name.startsWith("'") ? name.substring(1) : name;
    }

    public static String getTypeName(Node processedTypeNode) {
        String typeName = processedTypeNode.kind().stringValue();
        switch (processedTypeNode.kind()) {
            case HANDLE_TYPE_DESC: 
            case ANY_TYPE_DESC: 
            case ANYDATA_TYPE_DESC: 
            case NEVER_TYPE_DESC: {
                break;
            }
            case UNION_TYPE_DESC: {
                typeName = "union";
                break;
            }
            case NIL_TYPE_DESC: {
                typeName = "()";
                break;
            }
            case MAP_TYPE_DESC: {
                typeName = "map";
                break;
            }
            case ERROR_TYPE_DESC: {
                typeName = "error";
                break;
            }
            case STREAM_TYPE_DESC: {
                typeName = "stream";
                break;
            }
            case FUNCTION_TYPE_DESC: {
                typeName = "function";
                break;
            }
            case TUPLE_TYPE_DESC: {
                typeName = "tuple";
                break;
            }
            case TABLE_TYPE_DESC: {
                typeName = "table";
                break;
            }
            case DISTINCT_TYPE_DESC: {
                typeName = "distinct";
                break;
            }
            case INTERSECTION_TYPE_DESC: {
                typeName = "intersection";
                break;
            }
            case FUTURE_TYPE_DESC: {
                typeName = "future";
                break;
            }
            case RECORD_TYPE_DESC: {
                typeName = "in-line record";
                break;
            }
            case OBJECT_TYPE_DESC: {
                typeName = "object";
                break;
            }
            default: {
                if (!typeName.isBlank()) break;
                typeName = processedTypeNode.kind().name();
            }
        }
        return typeName;
    }

    public static String getStringArgument(CodeActionExecutionContext context, String key) {
        for (CodeActionArgument arg : context.arguments()) {
            if (!key.equals(arg.key())) continue;
            return (String)arg.valueAs(String.class);
        }
        return null;
    }

    public static TextRange getTextRangeArgument(CodeActionExecutionContext context, String key) {
        for (CodeActionArgument arg : context.arguments()) {
            if (!key.equals(arg.key())) continue;
            return (TextRange)arg.valueAs(TextRange.class);
        }
        return null;
    }

    public static String getStringDiagnosticProperty(List<DiagnosticProperty<?>> diagnosticProperties, int index) {
        return ((BStringProperty)diagnosticProperties.get(index)).value();
    }

    public static int getNumericDiagnosticProperty(List<DiagnosticProperty<?>> diagnosticProperties, int index) {
        return ((BNumericProperty)diagnosticProperties.get(index)).value().intValue();
    }

    public static String getFieldName(String entityName, ArrayList<String> fieldNames) {
        Object fieldName = entityName.toLowerCase(Locale.ROOT);
        if (fieldNames.contains(fieldName)) {
            int i = 1;
            while (fieldNames.contains((String)fieldName + i)) {
                ++i;
            }
            fieldName = (String)fieldName + i;
        }
        return fieldName;
    }

    public static String getDatastore(SyntaxNodeAnalysisContext ctx) throws BalException {
        Path balFilePath = ctx.currentPackage().project().sourceRoot().toAbsolutePath();
        Path balFileContainingFolder = balFilePath.getParent();
        if (balFileContainingFolder == null) {
            throw new BalException("unable to locate the project's Ballerina.toml file");
        }
        Path balProjectDir = balFileContainingFolder.getParent();
        if (balProjectDir == null) {
            throw new BalException("unable to locate the project's Ballerina.toml file");
        }
        Path configPath = balProjectDir.resolve("Ballerina.toml");
        Path targetDir = Paths.get(String.valueOf(balProjectDir), "target");
        Path genCmdConfigPath = targetDir.resolve("Persist.toml");
        if (Files.exists(genCmdConfigPath, new LinkOption[0])) {
            configPath = genCmdConfigPath;
        }
        return Utils.getDataStoreName(configPath);
    }

    private static String getDataStoreName(Path configPath) throws BalException {
        try {
            TextDocument configDocument = TextDocuments.from((String)Files.readString(configPath));
            SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)configDocument);
            DocumentNode rootNote = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNote.members();
            for (DocumentMemberDeclarationNode member : nodeList) {
                TableNode tableNode;
                String tableName;
                if (member instanceof TableArrayNode) {
                    TableArrayNode arrNode = (TableArrayNode)member;
                    tableName = arrNode.identifier().toSourceCode().trim();
                    if (!tableName.equals("tool.persist")) continue;
                    for (KeyValueNode field : arrNode.fields()) {
                        if (!field.identifier().toSourceCode().trim().equals("options.datastore")) continue;
                        return field.value().toSourceCode().trim().replaceAll("\"", "");
                    }
                    continue;
                }
                if (!(member instanceof TableNode) || !(tableName = (tableNode = (TableNode)member).identifier().toSourceCode().trim()).equals("persist")) continue;
                for (KeyValueNode field : tableNode.fields()) {
                    if (!field.identifier().toSourceCode().trim().equals("datastore")) continue;
                    return field.value().toSourceCode().trim().replaceAll("\"", "");
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new BalException("error while reading persist configurations. " + e.getMessage());
        }
    }

    public static String getDatastore(CodeActionContext ctx) throws BalException {
        Path balFilePath = ctx.filePath();
        Path balFileContainingFolder = balFilePath.getParent();
        if (balFileContainingFolder == null) {
            throw new BalException("unable to locate the project's Ballerina.toml file");
        }
        Path balProjectDir = balFileContainingFolder.getParent();
        if (balProjectDir == null) {
            throw new BalException("unable to locate the project's Ballerina.toml file");
        }
        Path configPath = balProjectDir.resolve("Ballerina.toml");
        return Utils.getDataStoreName(configPath);
    }

    public static List<String> readStringArrayValueFromAnnotation(List<AnnotationNode> annotationNodes, String annotation, String field) {
        for (AnnotationNode annotationNode : annotationNodes) {
            Optional annotationFieldNode;
            String annotationName = annotationNode.annotReference().toSourceCode().trim();
            if (!annotationName.equals(annotation) || !(annotationFieldNode = annotationNode.annotValue()).isPresent()) continue;
            for (MappingFieldNode mappingFieldNode : ((MappingConstructorExpressionNode)annotationFieldNode.get()).fields()) {
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)mappingFieldNode;
                String fieldName = specificFieldNode.fieldName().toSourceCode().trim();
                if (!fieldName.equals(field)) {
                    return Collections.emptyList();
                }
                Optional valueExpr = specificFieldNode.valueExpr();
                if (!valueExpr.isPresent()) continue;
                return Stream.of(((ExpressionNode)valueExpr.get()).toSourceCode().trim().replace("\"", "").replace("[", "").replace("]", "").split(",")).map(String::trim).toList();
            }
        }
        return Collections.emptyList();
    }
}

