/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import java.util.Optional;

public class MethodDefinitionNodeVisitor
extends NodeVisitor {
    private final SemanticModel semanticModel;
    private final MethodSymbol methodSymbol;
    private final ParameterSymbol parameterSymbol;
    private ParameterNode parameterNode;

    public MethodDefinitionNodeVisitor(SemanticModel semanticModel, MethodSymbol methodSymbol, ParameterSymbol parameterSymbol) {
        this.semanticModel = semanticModel;
        this.methodSymbol = methodSymbol;
        this.parameterSymbol = parameterSymbol;
    }

    public void visit(FunctionDefinitionNode functionDefinitionNode) {
        if (this.parameterNode != null) {
            return;
        }
        Optional functionSymbol = this.semanticModel.symbol((Node)functionDefinitionNode);
        if (functionSymbol.isEmpty() || !((Symbol)functionSymbol.get()).equals((Object)this.methodSymbol)) {
            return;
        }
        for (ParameterNode paramNode : functionDefinitionNode.functionSignature().parameters()) {
            Symbol symbol;
            if (this.semanticModel.symbol((Node)paramNode).isEmpty() || (symbol = (Symbol)this.semanticModel.symbol((Node)paramNode).get()).kind() != SymbolKind.PARAMETER || !symbol.equals((Object)this.parameterSymbol)) continue;
            this.parameterNode = paramNode;
        }
    }

    public Optional<ParameterNode> getParameterNode() {
        return Optional.ofNullable(this.parameterNode);
    }
}

