/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.service.validator;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.stdlib.graphql.compiler.FinderContext;
import io.ballerina.stdlib.graphql.compiler.service.validator.FunctionDefinitionNodeVisitor;
import java.util.Collection;
import java.util.Optional;

public class ResourceConfigAnnotationFinder {
    private final MethodSymbol methodSymbol;
    private final FinderContext context;

    public ResourceConfigAnnotationFinder(FinderContext context, MethodSymbol methodSymbol) {
        this.context = context;
        this.methodSymbol = methodSymbol;
    }

    public Optional<AnnotationNode> find() {
        return this.getAnnotationNodeFromModule();
    }

    private Optional<AnnotationNode> getAnnotationNodeFromModule() {
        Optional<AnnotationNode> annotationNode;
        Module currentModule = this.context.project().currentPackage().module(this.context.moduleId());
        Collection documentIds = currentModule.documentIds();
        FunctionDefinitionNodeVisitor functionDefinitionNodeVisitor = new FunctionDefinitionNodeVisitor(this.context.semanticModel(), this.methodSymbol);
        for (DocumentId documentId : documentIds) {
            Node rootNode = currentModule.document(documentId).syntaxTree().rootNode();
            rootNode.accept((NodeVisitor)functionDefinitionNodeVisitor);
            if (!functionDefinitionNodeVisitor.getAnnotationNode().isPresent()) continue;
            break;
        }
        if ((annotationNode = functionDefinitionNodeVisitor.getAnnotationNode()).isEmpty()) {
            documentIds = currentModule.testDocumentIds();
            for (DocumentId documentId : documentIds) {
                Node rootNode = currentModule.document(documentId).syntaxTree().rootNode();
                rootNode.accept((NodeVisitor)functionDefinitionNodeVisitor);
                if (!functionDefinitionNodeVisitor.getAnnotationNode().isPresent()) continue;
                break;
            }
            annotationNode = functionDefinitionNodeVisitor.getAnnotationNode();
        }
        return annotationNode;
    }
}

