/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker;

import io.ballerina.projects.Package;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.semver.checker.BallerinaPackageResolver;
import io.ballerina.semver.checker.comparator.PackageComparator;
import io.ballerina.semver.checker.diff.PackageDiff;
import io.ballerina.semver.checker.exception.SemverToolException;
import io.ballerina.semver.checker.util.DiffUtils;
import io.ballerina.semver.checker.util.PackageUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class SemverChecker {
    private final Path projectPath;
    private Package currentPackage;
    private SemanticVersion releaseVersion;
    private final PrintStream outStream;
    private final PrintStream errStream;

    public SemverChecker(Path projectPath, SemanticVersion releaseVersion, PrintStream out, PrintStream err) {
        this.projectPath = projectPath;
        this.releaseVersion = releaseVersion;
        this.outStream = out;
        this.errStream = err;
    }

    public String getVersionSuggestionSummary() throws SemverToolException {
        Optional<PackageDiff> packageDiff = this.computeDiff();
        return DiffUtils.getVersionSuggestion(packageDiff.orElse(null), this.getLocalVersion(), this.releaseVersion);
    }

    public String getDiffSummary() throws SemverToolException {
        StringBuilder sb = new StringBuilder();
        Optional<PackageDiff> packageDiff = this.computeDiff();
        sb.append(DiffUtils.getDiffSummary(packageDiff.orElse(null), this.getLocalVersion(), this.releaseVersion));
        sb.append(DiffUtils.getVersionSuggestion(packageDiff.orElse(null), this.getLocalVersion(), this.releaseVersion));
        return sb.toString();
    }

    public Optional<PackageDiff> computeDiff() throws SemverToolException {
        this.loadCurrentPackage();
        String orgName = this.currentPackage.packageOrg().value();
        String pkgName = this.currentPackage.packageName().value();
        SemanticVersion pkgVersion = this.currentPackage.packageVersion().value();
        BallerinaPackageResolver pkgResolver = new BallerinaPackageResolver(this.outStream, this.errStream);
        if (this.releaseVersion == null) {
            this.outStream.println("checking for the latest compatible release version available in central...");
            this.releaseVersion = pkgResolver.resolveClosestCompatibleCentralVersion(orgName, pkgName, pkgVersion);
        }
        Path balaPath = pkgResolver.resolvePackage(orgName, pkgName, this.releaseVersion);
        Package balaPackage = PackageUtils.loadPackage(balaPath);
        PackageComparator packageComparator = new PackageComparator(this.currentPackage, balaPackage);
        return packageComparator.computeDiff();
    }

    private SemanticVersion getLocalVersion() throws SemverToolException {
        this.loadCurrentPackage();
        return SemanticVersion.from((String)this.currentPackage.packageVersion().value().toString());
    }

    private void loadCurrentPackage() throws SemverToolException {
        if (this.currentPackage == null) {
            this.currentPackage = PackageUtils.loadPackage(this.projectPath);
            PackageCompilation compilation = this.currentPackage.getCompilation();
            if (!compilation.diagnosticResult().hasErrors()) {
                return;
            }
            List<Diagnostic> srcErrors = compilation.diagnosticResult().errors().stream().filter(diagnostic -> diagnostic.location().lineRange().fileName().endsWith(".bal")).toList();
            if (srcErrors.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("semver checker execution failed due to compilation errors:").append(System.lineSeparator());
            srcErrors.forEach(diagnostic -> sb.append(diagnostic.toString()).append(System.lineSeparator()));
            throw new SemverToolException(sb.toString());
        }
    }
}

