/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.EnumMemberDiff;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class EnumMemberComparator
extends NodeComparator<EnumMemberNode> {
    public EnumMemberComparator(EnumMemberNode newNode, EnumMemberNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        NodeDiffBuilder diffBuilder = new EnumMemberDiff.Builder((EnumMemberNode)this.newNode, (EnumMemberNode)this.oldNode).withChildDiffs(this.compareMetadata((EnumMemberNode)this.newNode, (EnumMemberNode)this.oldNode)).withChildDiffs(this.compareExpression((EnumMemberNode)this.newNode, (EnumMemberNode)this.oldNode));
        return diffBuilder.build();
    }

    private List<Diff> compareMetadata(EnumMemberNode newNode, EnumMemberNode oldNode) {
        ArrayList<Diff> metadataDiffs = new ArrayList<Diff>();
        Optional newMeta = newNode.metadata();
        Optional oldMeta = oldNode.metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        DumbNodeListComparator annotComparator = new DumbNodeListComparator(newAnnots, oldAnnots, DiffKind.ENUM_MEMBER_ANNOTATION);
        annotComparator.computeDiff().ifPresent(metadataDiffs::add);
        return metadataDiffs;
    }

    private List<Diff> compareExpression(EnumMemberNode newNode, EnumMemberNode oldNode) {
        ArrayList<Diff> memberExpressionDiffs = new ArrayList<Diff>();
        Optional newValue = newNode.constExprNode();
        Optional oldValue = oldNode.constExprNode();
        NodeDiffImpl.Builder<EnumMemberNode> enumValueDiffBuilder = new NodeDiffImpl.Builder<EnumMemberNode>(newNode, oldNode);
        enumValueDiffBuilder.withKind(DiffKind.ENUM_MEMBER_VALUE);
        if (newValue.isPresent() && oldValue.isEmpty()) {
            enumValueDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage(String.format("new constant value is added to the enum member '%s'", newNode.identifier().text()));
            enumValueDiffBuilder.build().ifPresent(memberExpressionDiffs::add);
        } else if (newValue.isEmpty() && oldValue.isPresent()) {
            enumValueDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage(String.format("constant value is removed from the enum member '%s'", oldNode.identifier().text()));
            enumValueDiffBuilder.build().ifPresent(memberExpressionDiffs::add);
        } else if (newValue.isPresent() && !((ExpressionNode)newValue.get()).toSourceCode().trim().equals(((ExpressionNode)oldValue.get()).toSourceCode().trim())) {
            enumValueDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage(String.format("constant value of the enum member '%s' is modified", newNode.identifier().text()));
            enumValueDiffBuilder.build().ifPresent(memberExpressionDiffs::add);
        }
        return memberExpressionDiffs;
    }
}

