/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.ModuleConstantDiff;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class ModuleConstantComparator
extends NodeComparator<ConstantDeclarationNode> {
    public ModuleConstantComparator(ConstantDeclarationNode newNode, ConstantDeclarationNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        NodeDiffBuilder diffBuilder = new ModuleConstantDiff.Builder((ConstantDeclarationNode)this.newNode, (ConstantDeclarationNode)this.oldNode).withChildDiffs(this.compareModuleVariableMetadata((ConstantDeclarationNode)this.newNode, (ConstantDeclarationNode)this.oldNode)).withChildDiffs(this.compareQualifiers((ConstantDeclarationNode)this.newNode, (ConstantDeclarationNode)this.oldNode)).withChildDiffs(this.compareType((ConstantDeclarationNode)this.newNode, (ConstantDeclarationNode)this.oldNode)).withChildDiffs(this.compareExpression((ConstantDeclarationNode)this.newNode, (ConstantDeclarationNode)this.oldNode));
        if (!this.isPublic()) {
            diffBuilder = diffBuilder.withVersionImpact(SemverImpact.PATCH);
        }
        return diffBuilder.build();
    }

    private List<Diff> compareModuleVariableMetadata(ConstantDeclarationNode newNode, ConstantDeclarationNode oldNode) {
        ArrayList<Diff> metadataDiffs = new ArrayList<Diff>();
        Optional newMeta = newNode.metadata();
        Optional oldMeta = oldNode.metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        DumbNodeListComparator annotComparator = new DumbNodeListComparator(newAnnots, oldAnnots, DiffKind.MODULE_CONST_ANNOTATION);
        annotComparator.computeDiff().ifPresent(metadataDiffs::add);
        return metadataDiffs;
    }

    private List<Diff> compareQualifiers(ConstantDeclarationNode newNode, ConstantDeclarationNode oldNode) {
        ArrayList<Diff> qualifierDiffs = new ArrayList<Diff>();
        Optional newPublicQual = newNode.visibilityQualifier();
        Optional oldPublicQual = oldNode.visibilityQualifier();
        if (newPublicQual.isPresent() && oldPublicQual.isEmpty()) {
            NodeDiffImpl.Builder<Object> qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newPublicQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MINOR).withMessage("'public' qualifier is added to module constant '" + this.getModuleConstantName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newPublicQual.isEmpty() && oldPublicQual.isPresent()) {
            NodeDiffImpl.Builder<Node> qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldPublicQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("'public' qualifier is removed from module constant '" + this.getModuleConstantName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        return qualifierDiffs;
    }

    private List<Diff> compareType(ConstantDeclarationNode newNode, ConstantDeclarationNode oldNode) {
        LinkedList<Diff> typeDiffs = new LinkedList<Diff>();
        Optional newType = newNode.typeDescriptor();
        Optional oldType = oldNode.typeDescriptor();
        if (newType.isEmpty() && oldType.isEmpty()) {
            return typeDiffs;
        }
        if (newType.isPresent() && oldType.isEmpty()) {
            NodeDiffBuilder diffBuilder = new NodeDiffImpl.Builder<Object>(((TypeDescriptorNode)newType.get()), null);
            diffBuilder = diffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS);
            diffBuilder.withMessage("module constant type added");
            diffBuilder.build().ifPresent(typeDiffs::add);
        } else if (newType.isEmpty()) {
            NodeDiffBuilder diffBuilder = new NodeDiffImpl.Builder<TypeDescriptorNode>(null, (TypeDescriptorNode)oldType.get());
            diffBuilder = diffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS);
            diffBuilder.withMessage("module constant type removed");
            diffBuilder.build().ifPresent(typeDiffs::add);
        } else if (!((TypeDescriptorNode)newType.get()).toSourceCode().trim().equals(((TypeDescriptorNode)oldType.get()).toSourceCode().trim())) {
            NodeDiffBuilder diffBuilder = new NodeDiffImpl.Builder<TypeDescriptorNode>((TypeDescriptorNode)newType.get(), (TypeDescriptorNode)oldType.get());
            diffBuilder = diffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS);
            diffBuilder.withMessage(String.format("module constant type changed from '%s' to '%s'", ((TypeDescriptorNode)oldType.get()).toSourceCode().trim(), ((TypeDescriptorNode)newType.get()).toSourceCode().trim()));
            diffBuilder.build().ifPresent(typeDiffs::add);
        }
        return typeDiffs;
    }

    private List<Diff> compareExpression(ConstantDeclarationNode newNode, ConstantDeclarationNode oldNode) {
        LinkedList<Diff> exprDiffs = new LinkedList<Diff>();
        DumbNodeComparator<Node> exprComparator = new DumbNodeComparator<Node>(newNode.initializer(), oldNode.initializer(), DiffKind.MODULE_CONST_INIT);
        exprComparator.computeDiff().ifPresent(exprDiffs::add);
        return exprDiffs;
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((ConstantDeclarationNode)this.newNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((ConstantDeclarationNode)this.oldNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    private String getModuleConstantName() {
        return this.newNode != null ? ((ConstantDeclarationNode)this.newNode).variableName().toSourceCode().trim() : ((ConstantDeclarationNode)this.oldNode).variableName().toSourceCode().trim();
    }
}

