/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.ModuleVarDiff;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class ModuleVariableComparator
extends NodeComparator<ModuleVariableDeclarationNode> {
    public ModuleVariableComparator(ModuleVariableDeclarationNode newNode, ModuleVariableDeclarationNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        NodeDiffBuilder diffBuilder = new ModuleVarDiff.Builder((ModuleVariableDeclarationNode)this.newNode, (ModuleVariableDeclarationNode)this.oldNode).withChildDiffs(this.compareMetadata((ModuleVariableDeclarationNode)this.newNode, (ModuleVariableDeclarationNode)this.oldNode)).withChildDiffs(this.compareQualifiers((ModuleVariableDeclarationNode)this.newNode, (ModuleVariableDeclarationNode)this.oldNode)).withChildDiffs(this.compareType((ModuleVariableDeclarationNode)this.newNode, (ModuleVariableDeclarationNode)this.oldNode)).withChildDiffs(this.compareExpression((ModuleVariableDeclarationNode)this.newNode, (ModuleVariableDeclarationNode)this.oldNode));
        if (!this.isPublic()) {
            diffBuilder = diffBuilder.withVersionImpact(SemverImpact.PATCH);
        }
        return diffBuilder.build();
    }

    private List<Diff> compareMetadata(ModuleVariableDeclarationNode newNode, ModuleVariableDeclarationNode oldNode) {
        ArrayList<Diff> metadataDiffs = new ArrayList<Diff>();
        Optional newMeta = newNode.metadata();
        Optional oldMeta = oldNode.metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        DumbNodeListComparator annotComparator = new DumbNodeListComparator(newAnnots, oldAnnots, DiffKind.MODULE_VAR_ANNOTATION);
        annotComparator.computeDiff().ifPresent(metadataDiffs::add);
        return metadataDiffs;
    }

    private List<Diff> compareQualifiers(ModuleVariableDeclarationNode newNode, ModuleVariableDeclarationNode oldNode) {
        ArrayList<Diff> qualifierDiffs = new ArrayList<Diff>();
        NodeList newQualifiers = newNode.qualifiers();
        NodeList oldQualifiers = oldNode.qualifiers();
        Optional newPublicQual = newNode.visibilityQualifier();
        Optional oldPublicQual = oldNode.visibilityQualifier();
        if (newPublicQual.isPresent() && oldPublicQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newPublicQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MINOR).withMessage("'public' qualifier is added to variable '" + this.getModuleVariableName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newPublicQual.isEmpty() && oldPublicQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldPublicQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("'public' qualifier is removed from variable '" + this.getModuleVariableName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newIsolatedQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.PRIVATE_KEYWORD);
        Optional<Token> oldIsolatedQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.PRIVATE_KEYWORD);
        if (newIsolatedQual.isPresent() && oldIsolatedQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newIsolatedQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage("'private' qualifier is added to variable '" + this.getModuleVariableName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newIsolatedQual.isEmpty() && oldIsolatedQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldIsolatedQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage("'private' qualifier is removed from variable '" + this.getModuleVariableName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newTransactionalQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.FINAL_KEYWORD);
        Optional<Token> oldTransactionalQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.FINAL_KEYWORD);
        if (newTransactionalQual.isPresent() && oldTransactionalQual.isEmpty()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newTransactionalQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS).withMessage("'final' qualifier is added to variable '" + this.getModuleVariableName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newTransactionalQual.isEmpty() && oldTransactionalQual.isPresent()) {
            qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldTransactionalQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.PATCH).withMessage("'final' qualifier is removed from variable '" + this.getModuleVariableName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        Optional<Token> newConfigurableQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)newQualifiers, SyntaxKind.CONFIGURABLE_KEYWORD);
        Optional<Token> oldConfigurableQual = SyntaxTreeUtils.lookupQualifier((NodeList<Token>)oldQualifiers, SyntaxKind.CONFIGURABLE_KEYWORD);
        if (newConfigurableQual.isPresent() && oldConfigurableQual.isEmpty()) {
            NodeDiffImpl.Builder<Object> qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newConfigurableQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("'configurable' qualifier is added to variable '" + this.getModuleVariableName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newConfigurableQual.isEmpty() && oldConfigurableQual.isPresent()) {
            NodeDiffImpl.Builder<Node> qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldConfigurableQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("'configurable' qualifier is removed from variable '" + this.getModuleVariableName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        return qualifierDiffs;
    }

    private List<Diff> compareType(ModuleVariableDeclarationNode newNode, ModuleVariableDeclarationNode oldNode) {
        LinkedList<Diff> typeDiffs = new LinkedList<Diff>();
        TypeDescriptorNode newType = newNode.typedBindingPattern().typeDescriptor();
        TypeDescriptorNode oldType = oldNode.typedBindingPattern().typeDescriptor();
        if (newType == null || oldType == null) {
            return typeDiffs;
        }
        if (!newType.toSourceCode().trim().equals(oldType.toSourceCode().trim())) {
            NodeDiffBuilder diffBuilder = new NodeDiffImpl.Builder<TypeDescriptorNode>(newType, oldType);
            diffBuilder = diffBuilder.withVersionImpact(SemverImpact.AMBIGUOUS);
            diffBuilder.withMessage(String.format("module variable type changed from '%s' to '%s'", oldType.toSourceCode().trim(), newType.toSourceCode().trim()));
            diffBuilder.build().ifPresent(typeDiffs::add);
        }
        return typeDiffs;
    }

    private List<Diff> compareExpression(ModuleVariableDeclarationNode newNode, ModuleVariableDeclarationNode oldNode) {
        LinkedList<Diff> exprDiffs = new LinkedList<Diff>();
        DumbNodeComparator<Node> exprComparator = new DumbNodeComparator<Node>(newNode.initializer().orElse(null), oldNode.initializer().orElse(null), DiffKind.MODULE_VAR_INIT);
        exprComparator.computeDiff().ifPresent(exprDiffs::add);
        return exprDiffs;
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((ModuleVariableDeclarationNode)this.newNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((ModuleVariableDeclarationNode)this.oldNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    private String getModuleVariableName() {
        return this.newNode != null ? ((ModuleVariableDeclarationNode)this.newNode).typedBindingPattern().bindingPattern().toSourceCode().trim() : ((ModuleVariableDeclarationNode)this.oldNode).typedBindingPattern().bindingPattern().toSourceCode().trim();
    }
}

