/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.comparator;

import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.semver.checker.comparator.DocumentationComparator;
import io.ballerina.semver.checker.comparator.DumbNodeComparator;
import io.ballerina.semver.checker.comparator.DumbNodeListComparator;
import io.ballerina.semver.checker.comparator.NodeComparator;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.diff.TypeDefinitionDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class TypeDefComparator
extends NodeComparator<TypeDefinitionNode> {
    public TypeDefComparator(TypeDefinitionNode newNode, TypeDefinitionNode oldNode) {
        super(newNode, oldNode);
    }

    @Override
    public Optional<? extends Diff> computeDiff() {
        TypeDefinitionDiff.Builder typeDiffBuilder = new TypeDefinitionDiff.Builder((TypeDefinitionNode)this.newNode, (TypeDefinitionNode)this.oldNode);
        return typeDiffBuilder.withChildDiffs(this.compareMetadata()).withChildDiffs(this.compareTypeDefQualifiers()).withChildDiffs(this.compareTypeDescriptor()).build();
    }

    public List<Diff> compareMetadata() {
        LinkedList<Diff> metadataDiffs = new LinkedList<Diff>();
        Optional newMeta = ((TypeDefinitionNode)this.newNode).metadata();
        Optional oldMeta = ((TypeDefinitionNode)this.oldNode).metadata();
        Node newDocs = newMeta.flatMap(MetadataNode::documentationString).orElse(null);
        Node oldDocs = oldMeta.flatMap(MetadataNode::documentationString).orElse(null);
        DocumentationComparator documentationComparator = new DocumentationComparator(newDocs, oldDocs);
        documentationComparator.computeDiff().ifPresent(metadataDiffs::add);
        NodeList newAnnots = newMeta.map(MetadataNode::annotations).orElse(null);
        NodeList oldAnnots = oldMeta.map(MetadataNode::annotations).orElse(null);
        DumbNodeListComparator annotsComparator = new DumbNodeListComparator(newAnnots, oldAnnots, DiffKind.MODULE_VAR_ANNOTATION);
        annotsComparator.computeDiff().ifPresent(metadataDiffs::add);
        return metadataDiffs;
    }

    private List<Diff> compareTypeDefQualifiers() {
        ArrayList<Diff> qualifierDiffs = new ArrayList<Diff>();
        Optional newPublicQual = ((TypeDefinitionNode)this.newNode).visibilityQualifier();
        Optional oldPublicQual = ((TypeDefinitionNode)this.oldNode).visibilityQualifier();
        if (newPublicQual.isPresent() && oldPublicQual.isEmpty()) {
            NodeDiffImpl.Builder<Object> qualifierDiffBuilder = new NodeDiffImpl.Builder<Object>(((Node)newPublicQual.get()), null);
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MINOR).withMessage("'public' qualifier is added to type '" + this.getTypeDefName() + "'").build().ifPresent(qualifierDiffs::add);
        } else if (newPublicQual.isEmpty() && oldPublicQual.isPresent()) {
            NodeDiffImpl.Builder<Node> qualifierDiffBuilder = new NodeDiffImpl.Builder<Node>(null, (Node)oldPublicQual.get());
            qualifierDiffBuilder.withVersionImpact(SemverImpact.MAJOR).withMessage("'public' qualifier is removed from type '" + this.getTypeDefName() + "'").build().ifPresent(qualifierDiffs::add);
        }
        return qualifierDiffs;
    }

    private List<Diff> compareTypeDescriptor() {
        Node oldTypeDef;
        Node newTypeDef = ((TypeDefinitionNode)this.newNode).typeDescriptor();
        DumbNodeComparator<Node> typeDescriptorComparator = new DumbNodeComparator<Node>(newTypeDef, oldTypeDef = ((TypeDefinitionNode)this.oldNode).typeDescriptor(), DiffKind.TYPE_DESCRIPTOR);
        Optional<Diff> diff = typeDescriptorComparator.computeDiff();
        if (diff.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(diff.get());
    }

    private String getTypeDefName() {
        return this.newNode != null ? ((TypeDefinitionNode)this.newNode).typeName().text().trim() : ((TypeDefinitionNode)this.oldNode).typeName().text().trim();
    }
}

