/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.diff;

import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.NodeDiffBuilder;
import io.ballerina.semver.checker.diff.NodeDiffImpl;
import io.ballerina.semver.checker.diff.SemverImpact;
import java.util.Collection;
import java.util.Optional;

public class ObjectFieldDiff
extends NodeDiffImpl<ObjectFieldNode> {
    private ObjectFieldDiff(ObjectFieldNode newNode, ObjectFieldNode oldNode) {
        super(newNode, oldNode, DiffKind.OBJECT_FIELD);
    }

    @Override
    public void computeVersionImpact() {
        boolean isPublic = this.isPublic();
        if (this.newNode != null && this.oldNode == null) {
            this.versionImpact = isPublic ? SemverImpact.MINOR : SemverImpact.PATCH;
        } else if (this.newNode == null && this.oldNode != null) {
            this.versionImpact = isPublic ? SemverImpact.MAJOR : SemverImpact.PATCH;
        } else if (isPublic) {
            super.computeVersionImpact();
        } else {
            this.versionImpact = SemverImpact.PATCH;
        }
    }

    private boolean isPublic() {
        boolean isNewPublic = this.newNode != null && ((ObjectFieldNode)this.newNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        boolean isOldPublic = this.oldNode != null && ((ObjectFieldNode)this.oldNode).visibilityQualifier().stream().anyMatch(qualifier -> qualifier.kind() == SyntaxKind.PUBLIC_KEYWORD);
        return isNewPublic || isOldPublic;
    }

    public static class Builder
    extends NodeDiffImpl.Builder<ObjectFieldNode> {
        private final ObjectFieldDiff fieldDiff;

        public Builder(ObjectFieldNode newNode, ObjectFieldNode oldNode) {
            super(newNode, oldNode);
            this.fieldDiff = new ObjectFieldDiff(newNode, oldNode);
        }

        @Override
        public Optional<ObjectFieldDiff> build() {
            if (!this.fieldDiff.getChildDiffs().isEmpty()) {
                this.fieldDiff.computeVersionImpact();
                this.fieldDiff.setType(DiffType.MODIFIED);
                return Optional.of(this.fieldDiff);
            }
            if (this.fieldDiff.getType() == DiffType.NEW || this.fieldDiff.getType() == DiffType.REMOVED) {
                return Optional.of(this.fieldDiff);
            }
            return Optional.empty();
        }

        @Override
        public NodeDiffBuilder withType(DiffType diffType) {
            this.fieldDiff.setType(diffType);
            return this;
        }

        @Override
        public NodeDiffBuilder withVersionImpact(SemverImpact versionImpact) {
            this.fieldDiff.setVersionImpact(versionImpact);
            return this;
        }

        @Override
        public NodeDiffBuilder withMessage(String message) {
            this.fieldDiff.setMessage(message);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiff(Diff childDiff) {
            this.fieldDiff.childDiffs.add(childDiff);
            return this;
        }

        @Override
        public NodeDiffBuilder withChildDiffs(Collection<? extends Diff> childDiffs) {
            this.fieldDiff.childDiffs.addAll(childDiffs);
            return this;
        }
    }
}

