/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.util;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.SemanticVersion;
import io.ballerina.semver.checker.diff.ClassDiff;
import io.ballerina.semver.checker.diff.Diff;
import io.ballerina.semver.checker.diff.DiffKind;
import io.ballerina.semver.checker.diff.DiffType;
import io.ballerina.semver.checker.diff.EnumDiff;
import io.ballerina.semver.checker.diff.EnumMemberDiff;
import io.ballerina.semver.checker.diff.FunctionDiff;
import io.ballerina.semver.checker.diff.ModuleConstantDiff;
import io.ballerina.semver.checker.diff.ModuleDiff;
import io.ballerina.semver.checker.diff.ModuleVarDiff;
import io.ballerina.semver.checker.diff.NodeDiff;
import io.ballerina.semver.checker.diff.NodeListDiff;
import io.ballerina.semver.checker.diff.ObjectFieldDiff;
import io.ballerina.semver.checker.diff.PackageDiff;
import io.ballerina.semver.checker.diff.SemverImpact;
import io.ballerina.semver.checker.diff.ServiceDiff;
import io.ballerina.semver.checker.diff.TypeDefinitionDiff;
import io.ballerina.semver.checker.util.SemverUtils;
import io.ballerina.semver.checker.util.SyntaxTreeUtils;

public final class DiffUtils {
    public static final String DIFF_ATTR_KIND = "kind";
    public static final String DIFF_ATTR_TYPE = "type";
    public static final String DIFF_ATTR_MESSAGE = "message";
    public static final String DIFF_ATTR_VERSION_IMPACT = "versionImpact";
    public static final String DIFF_ATTR_CHILDREN = "childDiffs";
    private static final String UNKNOWN = "unknown";

    private DiffUtils() {
    }

    public static String getDiffSummary(PackageDiff packageDiff, SemanticVersion localVersion, SemanticVersion previousVersion) {
        StringBuilder sb = new StringBuilder();
        if (packageDiff == null) {
            sb.append("no changes detected").append(System.lineSeparator());
        } else {
            String title = String.format(" Comparing version '%s'(local) with version '%s'(central) ", localVersion, previousVersion);
            sb.append(System.lineSeparator());
            sb.append("=".repeat(title.length())).append(System.lineSeparator());
            sb.append(title).append(System.lineSeparator());
            sb.append("=".repeat(title.length())).append(System.lineSeparator());
            sb.append(packageDiff.getAsString());
        }
        return sb.toString();
    }

    public static String getVersionSuggestion(PackageDiff packageDiff, SemanticVersion localVersion, SemanticVersion previousVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append("current version: ").append(localVersion).append(System.lineSeparator());
        sb.append("compatibility impact (compared with the release version '").append(previousVersion).append("'): ");
        if (packageDiff == null) {
            sb.append("no changes detected").append(System.lineSeparator());
        } else {
            switch (packageDiff.getVersionImpact()) {
                case MAJOR: {
                    sb.append("backward-incompatible changes detected").append(System.lineSeparator());
                    break;
                }
                case MINOR: {
                    sb.append("patch-incompatible changes detected").append(System.lineSeparator());
                    break;
                }
                case PATCH: {
                    sb.append("patch-compatible changes detected").append(System.lineSeparator());
                    break;
                }
                case AMBIGUOUS: {
                    sb.append("one or more changes detected with ambiguous level of impact. the developer is expected to manually review the changes below and choose an appropriate version");
                    sb.append(System.lineSeparator());
                    packageDiff.getChildDiffs(SemverImpact.AMBIGUOUS).forEach(diff -> sb.append(diff.getAsString()));
                    break;
                }
                default: {
                    sb.append("one or more changes detected with unknown level of impact. the developer is expected to manually review the changes below and choose an appropriate version");
                    sb.append(System.lineSeparator());
                    packageDiff.getChildDiffs(SemverImpact.UNKNOWN);
                }
            }
        }
        sb.append("suggested version: ").append(SemverUtils.calculateSuggestedVersion(previousVersion, packageDiff));
        return sb.toString();
    }

    public static String stringifyDiff(Diff diff) {
        NodeListDiff nodeListDiff;
        NodeDiff nodeDiff;
        StringBuilder sb = new StringBuilder();
        sb.append(DiffUtils.getDiffIndentation(diff)).append(DiffUtils.getDiffSign(diff)).append(" ");
        if (diff instanceof NodeDiff && (nodeDiff = (NodeDiff)diff).getMessage().isPresent()) {
            sb.append(nodeDiff.getMessage().get());
        } else if (diff instanceof NodeListDiff && (nodeListDiff = (NodeListDiff)diff).getMessage().isPresent()) {
            sb.append(nodeListDiff.getMessage().get());
        } else {
            sb.append(diff.getKind() != null && diff.getKind() != DiffKind.UNKNOWN ? diff.getKind().toString() : DiffUtils.getDiffTypeName(diff)).append(" '").append(DiffUtils.getDiffName(diff)).append("' is ").append(DiffUtils.getDiffVerb(diff));
        }
        sb.append(" [").append("version impact: ").append((Object)diff.getVersionImpact()).append("]").append(System.lineSeparator());
        return sb.toString();
    }

    public static boolean isCompoundDiff(Diff diff) {
        return diff instanceof FunctionDiff || diff instanceof ServiceDiff || diff instanceof ModuleVarDiff || diff instanceof ModuleConstantDiff || diff instanceof ClassDiff || diff instanceof ObjectFieldDiff || diff instanceof TypeDefinitionDiff || diff instanceof EnumDiff || diff instanceof EnumMemberDiff;
    }

    private static String getPackageName(PackageDiff packageDiff) {
        switch (packageDiff.getType()) {
            case NEW: {
                return packageDiff.getNewPackage().orElseThrow().packageName().value();
            }
            case REMOVED: {
                return packageDiff.getOldPackage().orElseThrow().packageName().value();
            }
        }
        if (packageDiff.getNewPackage().isPresent()) {
            return packageDiff.getNewPackage().orElseThrow().packageName().value();
        }
        if (packageDiff.getOldPackage().isPresent()) {
            return packageDiff.getOldPackage().orElseThrow().packageName().value();
        }
        return UNKNOWN;
    }

    private static String getModuleName(ModuleDiff moduleDiff) {
        switch (moduleDiff.getType()) {
            case NEW: {
                return moduleDiff.getNewModule().orElseThrow().moduleName().toString();
            }
            case REMOVED: {
                return moduleDiff.getOldModule().orElseThrow().moduleName().toString();
            }
        }
        if (moduleDiff.getNewModule().isPresent()) {
            return moduleDiff.getNewModule().orElseThrow().moduleName().toString();
        }
        if (moduleDiff.getOldModule().isPresent()) {
            return moduleDiff.getOldModule().orElseThrow().moduleName().toString();
        }
        return UNKNOWN;
    }

    private static String getDiffSign(Diff diff) {
        return switch (diff.getType()) {
            case DiffType.NEW -> "[++]";
            case DiffType.REMOVED -> "[--]";
            case DiffType.MODIFIED -> "[+-]";
            default -> "[??]";
        };
    }

    private static String getDiffVerb(Diff diff) {
        return switch (diff.getType()) {
            case DiffType.NEW -> "added";
            case DiffType.REMOVED -> "removed";
            case DiffType.MODIFIED -> "modified";
            default -> "?";
        };
    }

    private static String getDiffName(Diff diff) {
        if (diff instanceof PackageDiff) {
            PackageDiff packageDiff = (PackageDiff)diff;
            return DiffUtils.getPackageName(packageDiff);
        }
        if (diff instanceof ModuleDiff) {
            ModuleDiff moduleDiff = (ModuleDiff)diff;
            return DiffUtils.getModuleName(moduleDiff);
        }
        if (diff instanceof FunctionDiff) {
            FunctionDiff funcDiff = (FunctionDiff)diff;
            return DiffUtils.getFunctionName(funcDiff);
        }
        if (diff instanceof ServiceDiff) {
            ServiceDiff serviceDiff = (ServiceDiff)diff;
            return DiffUtils.getServiceName(serviceDiff);
        }
        if (diff instanceof ModuleVarDiff) {
            ModuleVarDiff moduleVarDiff = (ModuleVarDiff)diff;
            return DiffUtils.getModuleVariableName(moduleVarDiff);
        }
        if (diff instanceof ModuleConstantDiff) {
            ModuleConstantDiff moduleConstantDiff = (ModuleConstantDiff)diff;
            return DiffUtils.getModuleConstantName(moduleConstantDiff);
        }
        if (diff instanceof ClassDiff) {
            ClassDiff classDiff = (ClassDiff)diff;
            return DiffUtils.getModuleClassName(classDiff);
        }
        if (diff instanceof TypeDefinitionDiff) {
            TypeDefinitionDiff typeDefDiff = (TypeDefinitionDiff)diff;
            return DiffUtils.getModuleTypeDefName(typeDefDiff);
        }
        if (diff instanceof EnumDiff) {
            EnumDiff enumDiff = (EnumDiff)diff;
            return DiffUtils.getModuleEnumName(enumDiff);
        }
        return UNKNOWN;
    }

    public static String getDiffTypeName(Diff diff) {
        if (diff instanceof PackageDiff) {
            return "package";
        }
        if (diff instanceof ModuleDiff) {
            return "module";
        }
        if (diff instanceof ServiceDiff) {
            return "service";
        }
        if (diff instanceof ModuleVarDiff) {
            return "module variable";
        }
        if (diff instanceof ModuleConstantDiff) {
            return "module constant";
        }
        if (diff instanceof ClassDiff) {
            return "class";
        }
        if (diff instanceof TypeDefinitionDiff) {
            return "type definition";
        }
        if (diff instanceof EnumDiff) {
            return "enum declaration";
        }
        if (diff instanceof FunctionDiff) {
            FunctionDiff functionDiff = (FunctionDiff)diff;
            if (functionDiff.isResource()) {
                return "resource function";
            }
            if (functionDiff.isRemote()) {
                return "remote function";
            }
            return "function";
        }
        return UNKNOWN;
    }

    private static String getDiffIndentation(Diff diff) {
        if (diff instanceof PackageDiff) {
            return " ".repeat(0);
        }
        if (diff instanceof ModuleDiff) {
            return " ".repeat(2);
        }
        if (diff instanceof ServiceDiff) {
            return " ".repeat(4);
        }
        if (diff instanceof ModuleVarDiff) {
            return " ".repeat(4);
        }
        if (diff instanceof ModuleConstantDiff) {
            return " ".repeat(4);
        }
        if (diff instanceof ClassDiff) {
            return " ".repeat(4);
        }
        if (diff instanceof TypeDefinitionDiff) {
            return " ".repeat(4);
        }
        if (diff instanceof EnumDiff) {
            return " ".repeat(4);
        }
        if (diff instanceof EnumMemberDiff) {
            return " ".repeat(6);
        }
        if (diff instanceof ObjectFieldDiff) {
            return " ".repeat(6);
        }
        if (diff instanceof FunctionDiff) {
            FunctionDiff functionDiff = (FunctionDiff)diff;
            if (functionDiff.isResource()) {
                return " ".repeat(6);
            }
            if (functionDiff.isRemote()) {
                return " ".repeat(6);
            }
            return " ".repeat(4);
        }
        return " ".repeat(6);
    }

    private static String getFunctionName(FunctionDiff functionDiff) {
        if (functionDiff.getNewNode().isPresent()) {
            return SyntaxTreeUtils.getFunctionIdentifier((FunctionDefinitionNode)functionDiff.getNewNode().get());
        }
        if (functionDiff.getOldNode().isPresent()) {
            return SyntaxTreeUtils.getFunctionIdentifier((FunctionDefinitionNode)functionDiff.getOldNode().get());
        }
        return UNKNOWN;
    }

    private static String getServiceName(ServiceDiff serviceDiff) {
        if (serviceDiff.getNewNode().isPresent()) {
            return SyntaxTreeUtils.getServiceIdentifier((ServiceDeclarationNode)serviceDiff.getNewNode().get()).orElse(UNKNOWN);
        }
        if (serviceDiff.getOldNode().isPresent()) {
            return SyntaxTreeUtils.getServiceIdentifier((ServiceDeclarationNode)serviceDiff.getOldNode().get()).orElse(UNKNOWN);
        }
        return UNKNOWN;
    }

    private static String getModuleVariableName(ModuleVarDiff moduleVarDiff) {
        if (moduleVarDiff.getNewNode().isPresent()) {
            return SyntaxTreeUtils.getModuleVarIdentifier((ModuleVariableDeclarationNode)moduleVarDiff.getNewNode().get());
        }
        if (moduleVarDiff.getOldNode().isPresent()) {
            return SyntaxTreeUtils.getModuleVarIdentifier((ModuleVariableDeclarationNode)moduleVarDiff.getOldNode().get());
        }
        return UNKNOWN;
    }

    private static String getModuleConstantName(ModuleConstantDiff moduleConstantDiff) {
        if (moduleConstantDiff.getNewNode().isPresent()) {
            return SyntaxTreeUtils.getConstIdentifier((ConstantDeclarationNode)moduleConstantDiff.getNewNode().get());
        }
        if (moduleConstantDiff.getOldNode().isPresent()) {
            return SyntaxTreeUtils.getConstIdentifier((ConstantDeclarationNode)moduleConstantDiff.getOldNode().get());
        }
        return UNKNOWN;
    }

    private static String getModuleClassName(ClassDiff classDiff) {
        if (classDiff.getNewNode().isPresent()) {
            return SyntaxTreeUtils.getClassIdentifier((ClassDefinitionNode)classDiff.getNewNode().get());
        }
        if (classDiff.getOldNode().isPresent()) {
            return SyntaxTreeUtils.getClassIdentifier((ClassDefinitionNode)classDiff.getOldNode().get());
        }
        return UNKNOWN;
    }

    private static String getModuleTypeDefName(TypeDefinitionDiff typeDefinitionDiff) {
        if (typeDefinitionDiff.getNewNode().isPresent()) {
            return SyntaxTreeUtils.getTypeDefIdentifier((TypeDefinitionNode)typeDefinitionDiff.getNewNode().get());
        }
        if (typeDefinitionDiff.getOldNode().isPresent()) {
            return SyntaxTreeUtils.getTypeDefIdentifier((TypeDefinitionNode)typeDefinitionDiff.getOldNode().get());
        }
        return UNKNOWN;
    }

    private static String getModuleEnumName(EnumDiff enumDiff) {
        if (enumDiff.getNewNode().isPresent()) {
            return SyntaxTreeUtils.getEnumIdentifier((EnumDeclarationNode)enumDiff.getNewNode().get());
        }
        if (enumDiff.getOldNode().isPresent()) {
            return SyntaxTreeUtils.getEnumIdentifier((EnumDeclarationNode)enumDiff.getOldNode().get());
        }
        return UNKNOWN;
    }
}

