/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.semver.checker.util;

import io.ballerina.projects.SemanticVersion;
import io.ballerina.semver.checker.diff.PackageDiff;

public final class SemverUtils {
    private static final String SEMVER_FORMAT = "%d.%d.%d";
    public static final String BAL_FILE_EXT = ".bal";

    private SemverUtils() {
    }

    public static String calculateSuggestedVersion(SemanticVersion prevVersion, PackageDiff packageDiff) {
        if (packageDiff == null) {
            return prevVersion.toString();
        }
        switch (packageDiff.getVersionImpact()) {
            case MAJOR: 
            case AMBIGUOUS: {
                if (prevVersion.isInitialVersion()) {
                    return String.format(SEMVER_FORMAT, prevVersion.major(), prevVersion.minor() + 1, 0);
                }
                return String.format(SEMVER_FORMAT, prevVersion.major() + 1, 0, 0);
            }
            case MINOR: {
                return String.format(SEMVER_FORMAT, prevVersion.major(), prevVersion.minor() + 1, 0);
            }
            case PATCH: {
                return String.format(SEMVER_FORMAT, prevVersion.major(), prevVersion.minor(), prevVersion.patch() + 1);
            }
        }
        return "N/A";
    }
}

