/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.commons.utils;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;

public final class Utils {
    public static final String PACKAGE_NAME = "graphql";
    public static final String SUBGRAPH_SUB_MODULE_NAME = "graphql.subgraph";
    public static final String PACKAGE_ORG = "ballerina";
    public static final String SERVICE_NAME = "Service";

    private Utils() {
    }

    public static boolean isGraphqlService(SyntaxNodeAnalysisContext context) {
        ServiceDeclarationNode node = (ServiceDeclarationNode)context.node();
        if (context.semanticModel().symbol((Node)node).isEmpty()) {
            return false;
        }
        if (((Symbol)context.semanticModel().symbol((Node)node).get()).kind() != SymbolKind.SERVICE_DECLARATION) {
            return false;
        }
        ServiceDeclarationSymbol symbol = (ServiceDeclarationSymbol)context.semanticModel().symbol((Node)node).get();
        return Utils.hasGraphqlListener(symbol);
    }

    public static boolean hasGraphqlListener(ServiceDeclarationSymbol symbol) {
        for (TypeSymbol listener : symbol.listenerTypes()) {
            if (!Utils.isGraphqlListener(listener)) continue;
            return true;
        }
        return false;
    }

    public static boolean isGraphqlListener(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
            for (TypeSymbol member : unionTypeSymbol.memberTypeDescriptors()) {
                if (!Utils.isGraphqlModuleSymbol((Symbol)member)) continue;
                return true;
            }
        } else {
            return Utils.isGraphqlModuleSymbol((Symbol)typeSymbol);
        }
        return false;
    }

    public static boolean isGraphqlModuleSymbol(Symbol symbol) {
        return Utils.hasExpectedModuleName(symbol, PACKAGE_NAME, PACKAGE_ORG);
    }

    public static boolean isSubgraphModuleSymbol(Symbol symbol) {
        return Utils.hasExpectedModuleName(symbol, SUBGRAPH_SUB_MODULE_NAME, PACKAGE_ORG);
    }

    private static boolean hasExpectedModuleName(Symbol symbol, String expectedModuleName, String expectedOrgName) {
        if (symbol.getModule().isEmpty()) {
            return false;
        }
        String moduleName = ((ModuleSymbol)symbol.getModule().get()).id().moduleName();
        String orgName = ((ModuleSymbol)symbol.getModule().get()).id().orgName();
        return expectedModuleName.equals(moduleName) && expectedOrgName.equals(orgName);
    }

    public static boolean isGraphQLServiceObjectDeclaration(ModuleVariableDeclarationNode variableNode) {
        TypedBindingPatternNode typedBindingPatternNode = variableNode.typedBindingPattern();
        TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
        if (typeDescriptorNode.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            return false;
        }
        return Utils.isGraphqlServiceQualifiedNameReference((QualifiedNameReferenceNode)typeDescriptorNode);
    }

    private static boolean isGraphqlServiceQualifiedNameReference(QualifiedNameReferenceNode nameReferenceNode) {
        Token modulePrefixToken = nameReferenceNode.modulePrefix();
        String graphqlModulePrefix = Utils.getGraphqlModulePrefix((ModulePartNode)nameReferenceNode.syntaxTree().rootNode());
        if (modulePrefixToken.kind() != SyntaxKind.IDENTIFIER_TOKEN) {
            return false;
        }
        if (!graphqlModulePrefix.equals(modulePrefixToken.text())) {
            return false;
        }
        IdentifierToken identifier = nameReferenceNode.identifier();
        return SERVICE_NAME.equals(identifier.text());
    }

    public static String getGraphqlModulePrefix(ModulePartNode rootNode) {
        for (ImportDeclarationNode importDeclarationNode : rootNode.imports()) {
            if (!Utils.isGraphqlImportNode(importDeclarationNode) || !importDeclarationNode.prefix().isPresent()) continue;
            return ((ImportPrefixNode)importDeclarationNode.prefix().get()).prefix().text();
        }
        return PACKAGE_NAME;
    }

    public static boolean isGraphqlImportNode(ImportDeclarationNode importNode) {
        if (importNode.orgName().isEmpty()) {
            return false;
        }
        if (!PACKAGE_ORG.equals(((ImportOrgNameNode)importNode.orgName().get()).orgName().text())) {
            return false;
        }
        if (importNode.moduleName().size() != 1) {
            return false;
        }
        return PACKAGE_NAME.equals(((IdentifierToken)importNode.moduleName().get(0)).text());
    }
}

